/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.base.io;

import org.qedeq.base.utility.Splitter;
import org.qedeq.base.utility.StringUtility;

public abstract class AbstractOutput {
    private StringBuffer spaces = new StringBuffer();
    private int breakAt;
    private int col;
    private StringBuffer tokenBuffer = new StringBuffer();
    private StringBuffer wsBuffer = new StringBuffer();

    public void addWs(String ws) {
        if (this.tokenBuffer.length() > 0) {
            if (this.fits(this.wsBuffer.length() + this.tokenBuffer.length())) {
                if (this.col == 0) {
                    this.appendSpaces();
                }
                this.append(this.wsBuffer.toString());
                this.col += this.wsBuffer.length();
                this.append(this.tokenBuffer.toString());
                this.col += this.tokenBuffer.length();
            } else {
                this.append("\n");
                this.col = 0;
                this.appendSpaces();
                this.append(this.tokenBuffer.toString());
                this.col += this.tokenBuffer.length();
            }
            this.wsBuffer.setLength(0);
            this.tokenBuffer.setLength(0);
        }
        this.wsBuffer.append(ws);
    }

    public void addToken(String part) {
        this.tokenBuffer.append(part);
    }

    public void flush() {
        this.addWs("");
        this.wsBuffer.setLength(0);
    }

    public void print(char c) {
        this.flush();
        this.print("" + c);
    }

    public void print(String text) {
        this.flush();
        if (text == null) {
            this.printWithoutSplit("null");
            return;
        }
        String[] lines = StringUtility.split(text, "\n");
        for (int i = 0; i < lines.length; ++i) {
            Splitter split = new Splitter(lines[i]);
            while (split.hasNext()) {
                String token = split.nextToken();
                if (!this.fits(token) && " ".equals(token)) continue;
                this.printWithoutSplit(token);
            }
            if (i + 1 >= lines.length) continue;
            this.println();
        }
    }

    public abstract void append(String var1);

    public void printWithoutSplit(String text) {
        this.flush();
        if (text == null) {
            return;
        }
        if (this.col == 0) {
            if (text.length() > 0) {
                this.appendSpaces();
            }
        } else if (!this.fits(text)) {
            this.println();
            this.appendSpaces();
        }
        this.append(text);
        this.col += text.length();
    }

    private boolean fits(String text) {
        if (text == null) {
            return true;
        }
        return this.fits(text.length());
    }

    private boolean fits(int length) {
        return this.breakAt <= 0 || this.col + length <= this.breakAt;
    }

    public void print(Object object) {
        this.print(String.valueOf(object));
    }

    public final void println(String token) {
        this.print(token);
        this.println();
    }

    public final void println(Object object) {
        this.println(String.valueOf(object));
    }

    public void println() {
        this.flush();
        if (this.col == 0 && this.spaces.toString().trim().length() > 0) {
            this.appendSpaces();
        }
        this.append("\n");
        this.col = 0;
    }

    public final void clearLevel() {
        this.flush();
        this.spaces.setLength(0);
    }

    public final void popLevel() {
        this.flush();
        if (this.spaces.length() > 0) {
            this.spaces.setLength(this.spaces.length() - 2);
        }
    }

    public final void popLevel(int characters) {
        this.flush();
        if (this.spaces.length() > 0) {
            this.spaces.setLength(Math.max(this.spaces.length() - characters, 0));
        }
    }

    public final String getLevel() {
        return this.spaces.toString();
    }

    public final void pushLevel() {
        this.flush();
        this.spaces.append("  ");
    }

    public final void pushLevel(String symbols) {
        this.flush();
        this.spaces.append(symbols);
    }

    public void setColumns(int columns) {
        this.breakAt = columns < 0 ? 0 : columns;
    }

    private void appendSpaces() {
        this.append(this.spaces.toString());
        this.col += this.spaces.length();
    }
}

