/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.ResourceLoaderUtility;
import org.qedeq.gui.se.main.GuiOptions;

public final class GuiHelper {
    private static final Class CLASS = GuiHelper.class;
    private static Color lineHighlighterBackgroundColor = new Color(232, 242, 254);
    private static Color markedAndHiglightedBackgroundColor = new Color(232, 242, 254, 128);
    private static Color markedTextBackgroundColor = new Color(255, 255, 190);

    private GuiHelper() {
    }

    public static void configureUI(GuiOptions options) {
        UIManager.put("ClassLoader", CLASS.getClassLoader());
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        Options.setUseNarrowButtons((boolean)options.isUseNarrowButtons());
        Options.setTabIconsEnabled((boolean)options.isTabIconsEnabled());
        UIManager.put("jgoodies.popupDropShadowEnabled", options.isPopupDropShadowEnabled());
        LookAndFeel selectedLaf = options.getSelectedLookAndFeel();
        if (selectedLaf instanceof PlasticLookAndFeel) {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)options.getSelectedTheme());
            PlasticLookAndFeel.setTabStyle((String)options.getPlasticTabStyle());
            PlasticLookAndFeel.setHighContrastFocusColorsEnabled((boolean)options.isPlasticHighContrastFocusEnabled());
        } else if (selectedLaf.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        JRadioButton radio = new JRadioButton();
        radio.getUI().uninstallUI(radio);
        JCheckBox checkBox = new JCheckBox();
        checkBox.getUI().uninstallUI(checkBox);
        try {
            UIManager.setLookAndFeel(selectedLaf);
        }
        catch (Exception e) {
            Trace.trace((Class)CLASS, (String)"configureUI", (String)"Can't change L&F", (Throwable)e);
        }
    }

    public static AbstractButton createToolBarButton(String iconName, String toolTipText) {
        JButton button = new JButton(GuiHelper.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public static AbstractButton createToolBarButton(String iconName, String toolTipText, ActionListener action, KeyStroke keyStroke) {
        AbstractButton button = GuiHelper.createToolBarButton(iconName, toolTipText);
        button.registerKeyboardAction(action, keyStroke, 2);
        return button;
    }

    public static AbstractButton createToolBarRadioButton(String iconName, String toolTipText) {
        JToggleButton button = new JToggleButton(GuiHelper.readImageIcon(iconName));
        button.setToolTipText(toolTipText);
        button.setFocusable(false);
        return button;
    }

    public static ImageIcon readImageIcon(String filename) {
        URL url = ResourceLoaderUtility.getResourceUrl((String)("images/" + filename));
        return new ImageIcon(url);
    }

    public static Color getLineHighlighterBackgroundColor() {
        return lineHighlighterBackgroundColor;
    }

    public static Color getMarkedTextBackgroundColor() {
        return markedTextBackgroundColor;
    }

    public static Color getCurrentAndMarkedBackgroundColor() {
        return markedAndHiglightedBackgroundColor;
    }

    public static void paintCurrentLineBackground(Graphics g, JTextComponent c, Color col) {
        Rectangle r;
        if (c.getSelectionStart() != c.getSelectionEnd()) {
            return;
        }
        try {
            r = c.modelToView(c.getCaretPosition());
        }
        catch (BadLocationException couldNotHappen) {
            throw new RuntimeException(couldNotHappen);
        }
        g.setColor(col);
        g.fillRect(0, r.y, c.getWidth(), r.height);
    }
}

