/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.util;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;
import org.qedeq.gui.se.util.DocumentMarkerPainter;
import org.qedeq.gui.se.util.GuiHelper;

public class DocumentMarker {
    private JTextArea textComp;
    private Highlighter.HighlightPainter highlightPainter = new DocumentMarkerPainter(GuiHelper.getMarkedTextBackgroundColor());
    private final List pos = new ArrayList();

    public DocumentMarker(JTextArea textComp) {
        this.textComp = textComp;
    }

    public int getOffsetOfFistLineFromBlock(int blockNumber) {
        Position[] p;
        int offset = 0;
        if (0 <= blockNumber && blockNumber < this.pos.size() && (p = (Position[])this.pos.get(blockNumber)) != null) {
            offset = p[0].getOffset();
        }
        return offset;
    }

    public int getLandmarkOffsetForBlock(int blockNumber) {
        Position[] p;
        int offset = 0;
        if (0 <= blockNumber && blockNumber < this.pos.size() && (p = (Position[])this.pos.get(blockNumber)) != null) {
            offset = p[2].getOffset();
        }
        return offset;
    }

    public List getBlockNumbersForOffset(int offset) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.pos.size(); ++i) {
            Position[] p = (Position[])this.pos.get(i);
            if (p == null) continue;
            int g1 = p[0].getOffset() - 1;
            int g2 = p[1].getOffset() + 1;
            if (g1 >= offset || offset >= g2) continue;
            list.add(new Integer(i));
        }
        return list;
    }

    public void addEmptyBlock() {
        this.pos.add(null);
    }

    public void addMarkedLines(int fromLine, int toLine, int off) throws BadLocationException {
        int fromOffset = this.textComp.getLineStartOffset(fromLine);
        int toOffset = this.textComp.getLineEndOffset(toLine);
        this.addMarkedBlock(fromOffset, toOffset, fromOffset + off);
    }

    private void addMarkedBlock(int fromOffset, int toOffset, int pos) throws BadLocationException {
        AbstractDocument doc = (AbstractDocument)this.textComp.getDocument();
        this.addMarkedBlock(doc.createPosition(fromOffset), doc.createPosition(toOffset - 1), doc.createPosition(pos));
        this.textComp.getHighlighter().addHighlight(fromOffset + 1, toOffset - 1, this.highlightPainter);
    }

    public void addMarkedBlock(int startLine, int startLineOffset, int endLine, int endLineOffset) throws BadLocationException {
        AbstractDocument doc = (AbstractDocument)this.textComp.getDocument();
        int fromOffset = this.textComp.getLineStartOffset(startLine) + startLineOffset;
        int toOffset = this.textComp.getLineStartOffset(endLine) + endLineOffset;
        this.addMarkedBlock(doc.createPosition(fromOffset), doc.createPosition(toOffset - 1), doc.createPosition(fromOffset));
        this.textComp.getHighlighter().addHighlight(fromOffset, toOffset - 1, this.highlightPainter);
    }

    private void addMarkedBlock(Position start, Position end, Position pos) throws BadLocationException {
        this.pos.add(new Position[]{start, end, pos});
    }
}

