/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.tree;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.qedeq.gui.se.tree.QedeqTreeCellRenderer;

public final class QedeqTreeView
extends JPanel {
    public static final String REFRESH_ACTION = "Refresh";
    public static final String DELETE_ACTION = "Delete";
    public static final String ADD_ACTION = "Add";
    public static final String LATEX_ACTION = "LaTeX";
    public static final String HTML_ACTION = "HTML";
    private final JTree theTree;
    private final JPopupMenu contextMenu = new JPopupMenu();
    private final JMenuItem refreshItem;
    private final JMenuItem deleteItem;
    private final JMenuItem addItem;
    private final JMenuItem htmlItem;
    private final JMenuItem latexItem;

    public QedeqTreeView(TreeModel treeModel) {
        super(new GridLayout(1, 1));
        this.theTree = new JTree(treeModel);
        this.theTree.setEditable(false);
        this.theTree.setRootVisible(false);
        this.theTree.setExpandsSelectedPaths(true);
        this.theTree.setScrollsOnExpand(true);
        this.theTree.setShowsRootHandles(true);
        this.theTree.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.theTree);
        this.theTree.setCellRenderer(new QedeqTreeCellRenderer());
        this.theTree.setRowHeight(-1);
        this.add(this.theTree);
        this.setMinimumSize(new Dimension(150, 100));
        this.refreshItem = new JMenuItem(REFRESH_ACTION);
        this.refreshItem.setActionCommand(REFRESH_ACTION);
        this.refreshItem.setEnabled(false);
        this.contextMenu.add(this.refreshItem);
        this.deleteItem = new JMenuItem(DELETE_ACTION);
        this.deleteItem.setActionCommand(DELETE_ACTION);
        this.contextMenu.add(this.deleteItem);
        this.addItem = new JMenuItem(ADD_ACTION);
        this.addItem.setActionCommand(ADD_ACTION);
        this.contextMenu.add(this.addItem);
        this.latexItem = new JMenuItem(LATEX_ACTION);
        this.latexItem.setActionCommand(LATEX_ACTION);
        this.contextMenu.add(this.latexItem);
        this.htmlItem = new JMenuItem(HTML_ACTION);
        this.htmlItem.setActionCommand(HTML_ACTION);
        this.htmlItem.setEnabled(false);
        this.contextMenu.add(this.htmlItem);
    }

    public final void expandPath(TreePath path) {
        this.theTree.expandPath(path);
    }

    public final JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    public final void addActionCommandToContextMenus(ActionListener listener) {
        this.refreshItem.addActionListener(listener);
        this.deleteItem.addActionListener(listener);
        this.addItem.addActionListener(listener);
        this.htmlItem.addActionListener(listener);
        this.latexItem.addActionListener(listener);
    }

    public final void addTreeSelectionListener(TreeSelectionListener listener) {
        this.theTree.addTreeSelectionListener(listener);
    }

    public void setSelectionRow(int row) {
        this.theTree.setSelectionRow(row);
    }

    public void setSelectionPath(TreePath path) {
        this.theTree.setSelectionPath(path);
    }

    public TreePath getSelectionPath() {
        return this.theTree.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.theTree.getSelectionPaths();
    }

    public TreePath getPathForLocation(int x, int y) {
        return this.theTree.getPathForLocation(x, y);
    }

    public void startEditingAtPath(TreePath path) {
        this.theTree.startEditingAtPath(path);
    }

    public void treeAddMouseListener(MouseListener mouseListener) {
        this.theTree.addMouseListener(mouseListener);
    }
}

