/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.main.LowerTabbedView;
import org.qedeq.gui.se.main.UpperTabbedView;
import org.qedeq.gui.se.tree.NothingSelectedException;
import org.qedeq.gui.se.tree.QedeqTreeModel;
import org.qedeq.gui.se.tree.QedeqTreeNode;
import org.qedeq.gui.se.tree.QedeqTreeView;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.bo.context.KernelContext;

public final class QedeqTreeCtrl
implements TreeModelListener {
    private static final Class CLASS = QedeqTreeCtrl.class;
    private final QedeqTreeView treeView;
    private final QedeqTreeModel treeModel;
    private final QedeqController controller;
    private final UpperTabbedView pane;
    private final LowerTabbedView lower;
    private final ActionListener removeAction;
    static /* synthetic */ Class class$org$qedeq$gui$se$tree$QedeqTreeCtrl$RemoveAction;

    public QedeqTreeCtrl(QedeqTreeView treeView, QedeqTreeModel treeModel, UpperTabbedView pane, LowerTabbedView lowerView, QedeqController controller) {
        this.treeView = treeView;
        this.treeModel = treeModel;
        this.treeModel.addTreeModelListener(this);
        this.controller = controller;
        this.treeView.addActionCommandToContextMenus(new QedeqActionCommand());
        this.treeView.treeAddMouseListener(new QedeqMouseListener());
        this.treeView.addTreeSelectionListener(new SelectionChangedCommand());
        this.removeAction = new RemoveAction();
        this.pane = pane;
        this.lower = lowerView;
    }

    public final ActionListener getRemoveAction() {
        return this.removeAction;
    }

    public final QedeqBo[] getSelected() throws NothingSelectedException {
        String method = "getSelected";
        Trace.begin((Class)CLASS, (Object)this, (String)"getSelected");
        try {
            TreePath[] selected = this.treeView.getSelectionPaths();
            ArrayList<QedeqBo> list = new ArrayList<QedeqBo>();
            if (selected != null && selected.length > 0) {
                Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (Object)("selection=" + selected[selected.length - 1]));
                for (int i = 0; i < selected.length; ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected[i].getLastPathComponent();
                    if (!(node instanceof QedeqTreeNode)) continue;
                    QedeqBo prop = (QedeqBo)node.getUserObject();
                    list.add(prop);
                }
            }
            if (list.size() <= 0) {
                throw new NothingSelectedException();
            }
            QedeqBo[] qedeqBoArray = list.toArray(new QedeqBo[0]);
            return qedeqBoArray;
        }
        catch (RuntimeException ex) {
            Trace.trace((Class)CLASS, (Object)this, (String)"getSelected", (Throwable)ex);
            throw new NothingSelectedException();
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"getSelected");
        }
    }

    public final String getEditedQedeq() {
        return this.pane.getEditedQedeq();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        Trace.param((Class)CLASS, (Object)this, (String)"treeNodesChanged", (String)"event", (Object)e);
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    QedeqTreeCtrl.this.pane.updateView();
                }
                catch (RuntimeException ex) {
                    Trace.fatal((Class)CLASS, (Object)this, (String)"treeNodesChanged", (String)"unexpected problem", (Throwable)ex);
                }
            }
        };
        SwingUtilities.invokeLater(runLater);
        Trace.end((Class)CLASS, (Object)this, (String)"treeNodesChanged");
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Trace.begin((Class)CLASS, (Object)this, (String)"treeNodesInserted");
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    if (((DefaultMutableTreeNode)QedeqTreeCtrl.this.treeModel.getRoot()).getChildCount() > 0) {
                        Trace.trace((Class)CLASS, (Object)this, (String)"treeNodesInserted", (Object)"expandPath");
                        QedeqTreeCtrl.this.treeView.expandPath(new TreePath(QedeqTreeCtrl.this.treeModel.getRoot()));
                    }
                }
                catch (RuntimeException ex) {
                    Trace.fatal((Class)CLASS, (Object)this, (String)"treeNodesInserted", (String)"unexpected problem", (Throwable)ex);
                }
            }
        };
        SwingUtilities.invokeLater(runLater);
        Trace.end((Class)CLASS, (Object)this, (String)"treeNodesInserted");
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        Trace.trace((Class)CLASS, (Object)this, (String)"treeNodeRemoved", (Object)node.getUserObject());
    }

    public void treeStructureChanged(TreeModelEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
        Trace.trace((Class)CLASS, (Object)this, (String)"treeStructureChanged", (Object)node.getUserObject());
    }

    private class QedeqMouseListener
    extends MouseAdapter {
        private QedeqMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            TreePath path = QedeqTreeCtrl.this.treeView.getPathForLocation(evt.getX(), evt.getY());
            if (SwingUtilities.isRightMouseButton(evt)) {
                if (path != null) {
                    QedeqTreeCtrl.this.treeView.setSelectionPath(path);
                }
                QedeqTreeCtrl.this.treeView.getContextMenu().show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                QedeqBo[] bos = QedeqTreeCtrl.this.getSelected();
                Runnable runExtra = new Runnable(this, bos){
                    private final /* synthetic */ QedeqBo[] val$bos;
                    private final /* synthetic */ RemoveAction this$1;
                    {
                        this.this$1 = this$1;
                        this.val$bos = val$bos;
                    }

                    public void run() {
                        for (int i = 0; i < this.val$bos.length; ++i) {
                            KernelContext.getInstance().removeModule(this.val$bos[i].getModuleAddress());
                        }
                    }
                };
                Thread thread = new Thread(runExtra);
                thread.setDaemon(true);
                thread.start();
            }
            catch (NothingSelectedException e1) {
                Trace.trace((Class)(class$org$qedeq$gui$se$tree$QedeqTreeCtrl$RemoveAction == null ? (class$org$qedeq$gui$se$tree$QedeqTreeCtrl$RemoveAction = QedeqTreeCtrl.class$("org.qedeq.gui.se.tree.QedeqTreeCtrl$RemoveAction")) : class$org$qedeq$gui$se$tree$QedeqTreeCtrl$RemoveAction), (Object)this, (String)"actionPerformed(ActionEvent", (Object)e);
            }
        }
    }

    private class QedeqActionCommand
    implements ActionListener {
        private QedeqActionCommand() {
        }

        public void actionPerformed(ActionEvent event) {
            String method = "actionPerformed";
            Trace.param((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"action", (Object)event);
            if (event.getActionCommand() == "Delete") {
                QedeqTreeCtrl.this.getRemoveAction().actionPerformed(event);
            } else if (event.getActionCommand() == "Add") {
                QedeqTreeCtrl.this.controller.getAddAction().actionPerformed(event);
            } else if (event.getActionCommand() == "LaTeX") {
                QedeqTreeCtrl.this.controller.getLatexAction().actionPerformed(event);
            }
        }
    }

    private class SelectionChangedCommand
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent event) {
            Trace.trace((Class)CLASS, (Object)this, (String)"valueChanged", (Object)event);
            TreePath path = event.getPath();
            QedeqTreeNode treeNode = (QedeqTreeNode)path.getLastPathComponent();
            if (event.isAddedPath() && treeNode.getUserObject() instanceof QedeqBo) {
                QedeqBo prop = (QedeqBo)treeNode.getUserObject();
                QedeqTreeCtrl.this.pane.setQedeqModel(prop);
                QedeqTreeCtrl.this.lower.setQedeqModel(prop);
            } else {
                QedeqTreeCtrl.this.pane.setQedeqModel(null);
                QedeqTreeCtrl.this.lower.setQedeqModel(null);
            }
        }
    }
}

