/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.BadLocationException;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.ErrorSelectionListener;
import org.qedeq.gui.se.control.ErrorSelectionListenerList;
import org.qedeq.gui.se.util.CurrentLineHighlighterUtility;
import org.qedeq.gui.se.util.DocumentMarker;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.common.SourceArea;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;

public class QedeqPane
extends JPanel
implements ErrorSelectionListener {
    private static final Class CLASS = QedeqPane.class;
    private QedeqBo prop;
    private JTextArea qedeq = new JTextArea(){

        public String getToolTipText(MouseEvent e) {
            if (QedeqPane.this.marker == null) {
                this.setToolTipText(null);
                return super.getToolTipText();
            }
            TextUI mapper = QedeqPane.this.qedeq.getUI();
            int i = mapper.viewToModel(QedeqPane.this.qedeq, e.getPoint());
            List errNos = QedeqPane.this.marker.getBlockNumbersForOffset(i);
            if (errNos.size() == 0) {
                this.setToolTipText(null);
                return super.getToolTipText(e);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            for (int j = 0; j < errNos.size(); ++j) {
                if (j > 0) {
                    buffer.append("<br>");
                }
                buffer.append(QedeqPane.this.prop.getException().get(((Integer)errNos.get(j)).intValue()).getMessage());
            }
            buffer.append("</html>");
            this.setToolTipText(buffer.toString());
            return this.getToolTipText();
        }
    };
    private DocumentMarker marker;

    public QedeqPane(QedeqBo prop) {
        super(false);
        this.prop = prop;
        this.setupView();
        this.updateView();
        ErrorSelectionListenerList.getInstance().addListener(this);
    }

    public void setupView() {
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.qedeq);
        this.setLayout(new BorderLayout(0, 0));
        this.add(scroller);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.qedeq.setEditable(false);
        this.qedeq.setToolTipText("");
        this.qedeq.putClientProperty("JTextArea.infoBackground", Boolean.TRUE);
        this.qedeq.setLineWrap(true);
    }

    public void setModel(QedeqBo prop) {
        Trace.trace((Class)CLASS, (Object)this, (String)"setModel", (Object)prop);
        this.prop = prop;
        this.updateView();
    }

    public QedeqBo getModel() {
        return this.prop;
    }

    public void setLineWrap(boolean wrap) {
        this.qedeq.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.qedeq.getLineWrap();
    }

    public synchronized void updateView() {
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        if (this.prop != null) {
            try {
                this.qedeq.setText(KernelContext.getInstance().getSource(this.prop.getModuleAddress()));
                CurrentLineHighlighterUtility.install(this.qedeq);
                this.qedeq.setLineWrap(this.getLineWrap());
                if (this.prop.hasFailures()) {
                    SourceFileExceptionList pe = this.prop.getException();
                    if (this.prop.getModuleAddress().isFileAddress()) {
                        this.qedeq.setEditable(true);
                    } else {
                        this.qedeq.setEditable(false);
                    }
                    this.qedeq.setCaretPosition(0);
                    this.qedeq.getCaret().setSelectionVisible(true);
                    this.marker = new DocumentMarker(this.qedeq);
                    for (int i = 0; i < pe.size(); ++i) {
                        if (pe.get(i).getSourceArea() != null) {
                            try {
                                SourceArea sa = pe.get(i).getSourceArea();
                                if (sa != null) {
                                    int from = sa.getStartPosition().getLine() - 1;
                                    int to = sa.getEndPosition().getLine() - 1;
                                    this.marker.addMarkedBlock(from, sa.getStartPosition().getColumn() - 1, to, sa.getEndPosition().getColumn() - 1);
                                    continue;
                                }
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                        this.marker.addEmptyBlock();
                    }
                } else {
                    if (this.prop.getModuleAddress().isFileAddress()) {
                        this.qedeq.setEditable(true);
                    } else {
                        this.qedeq.setEditable(false);
                    }
                    this.qedeq.getCaret().setSelectionVisible(false);
                    this.qedeq.setCaretPosition(0);
                    this.qedeq.setSelectedTextColor(MetalLookAndFeel.getHighlightedTextColor());
                    this.qedeq.setSelectionColor(MetalLookAndFeel.getTextHighlightColor());
                }
                Trace.trace((Class)CLASS, (Object)this, (String)"updateView", (Object)"Text updated");
            }
            catch (IOException ioException) {
                this.qedeq.setEditable(false);
                this.qedeq.setText("");
                Trace.trace((Class)CLASS, (Object)this, (String)"updateView", (Throwable)ioException);
            }
        } else {
            this.marker = null;
            CurrentLineHighlighterUtility.uninstall(this.qedeq);
            this.qedeq.setEditable(false);
            this.qedeq.setText("");
            Trace.end((Class)CLASS, (Object)this, (String)"updateView");
        }
        this.repaint();
    }

    public final String getEditedQedeq() {
        if (this.qedeq.isEditable()) {
            return this.qedeq.getText();
        }
        throw new IllegalStateException("no editable QEDEQ text");
    }

    public final boolean isContentChanged() {
        return !this.qedeq.isEditable();
    }

    public void selectError(int errorNumber, SourceFileException sf) {
        if (this.marker != null) {
            this.requestFocus();
            this.qedeq.requestFocus();
            this.qedeq.setCaretPosition(this.marker.getLandmarkOffsetForBlock(errorNumber));
        }
    }
}

