/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.pane.QedeqGuiConfig;

public final class Preferences
extends JFrame {
    private static final Class CLASS = Preferences.class;
    private JCheckBox automaticLogScrollCB;
    private JCheckBox autoReloadLastSessionCheckedCB;
    private JCheckBox directResponseCB;
    private JCheckBox autoStartHtmlBrowserCB;
    private JCheckBox oldHtmlCodeCB;
    private JLabel moduleBufferLabel;
    private JTextField moduleBufferTextField;
    private JLabel generationPathLabel;
    private JTextField generationPathTextField;
    private JLabel localModulesPathLabel;
    private JTextField localModulesPathTextField;
    private File bufferDirectory;
    private File generationDirectory;
    private File localModulesDirectory;
    private boolean automaticLogScroll;
    private boolean autoReloadLastSessionChecked;
    private boolean autoStartHtmlBrowser;
    private boolean directResponse;
    private boolean oldHtmlCode;
    private boolean changed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences(String title) {
        super(title);
        String method = "Constructor";
        Trace.begin((Class)CLASS, (Object)this, (String)"Constructor");
        try {
            this.changed = false;
            this.setupView();
            this.pack();
            this.setSize(660, 490);
        }
        catch (Throwable e) {
            Trace.trace((Class)CLASS, (Object)this, (String)"Constructor", (Throwable)e);
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"Constructor");
        }
    }

    public final void setupView() {
        Container contents = this.getContentPane();
        contents.setLayout(null);
        int y = 0;
        y = this.addCheckButtons(y);
        y = this.addDirectorySettings(y);
        JButton cancel = new JButton("Cancel");
        contents.add(cancel);
        cancel.setBounds(443, y, 90, 21);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.dispose();
            }
        });
        JButton ok = new JButton("OK");
        contents.add(ok);
        ok.setBounds(543, y, 90, 21);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.save();
                Preferences.this.dispose();
            }
        });
    }

    private int addCheckButtons(int ystart) {
        int y = ystart;
        Container contents = this.getContentPane();
        this.automaticLogScroll = QedeqGuiConfig.getInstance().isAutomaticLogScroll();
        this.automaticLogScrollCB = new JCheckBox(" Automatic Scroll of Log Window", this.automaticLogScroll);
        contents.add(this.automaticLogScrollCB);
        this.automaticLogScrollCB.setBounds(33, 20 + y, 400, 17);
        this.automaticLogScrollCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.automaticLogScroll = Preferences.this.automaticLogScrollCB.isSelected();
                Preferences.this.changed = true;
            }
        });
        this.autoReloadLastSessionChecked = QedeqGuiConfig.getInstance().isAutoReloadLastSessionChecked();
        this.autoReloadLastSessionCheckedCB = new JCheckBox(" Auto loading of in last session successfully checked modules", this.autoReloadLastSessionChecked);
        contents.add(this.autoReloadLastSessionCheckedCB);
        this.autoReloadLastSessionCheckedCB.setBounds(33, 20 + (y += 40), 400, 17);
        this.autoReloadLastSessionCheckedCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.autoReloadLastSessionChecked = Preferences.this.autoReloadLastSessionCheckedCB.isSelected();
                Preferences.this.changed = true;
            }
        });
        this.directResponse = QedeqGuiConfig.getInstance().isDirectResponse();
        this.directResponseCB = new JCheckBox(" Direct message response for actions", this.directResponse);
        contents.add(this.directResponseCB);
        this.directResponseCB.setBounds(33, 60 + y, 400, 17);
        this.directResponseCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.directResponse = Preferences.this.directResponseCB.isSelected();
                Preferences.this.changed = true;
            }
        });
        this.autoStartHtmlBrowser = QedeqGuiConfig.getInstance().isAutoStartHtmlBrowser();
        this.autoStartHtmlBrowserCB = new JCheckBox(" Auto start web browser after HTML generation", this.autoStartHtmlBrowser);
        contents.add(this.autoStartHtmlBrowserCB);
        this.autoStartHtmlBrowserCB.setBounds(33, 100 + y, 400, 17);
        this.autoStartHtmlBrowserCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.autoStartHtmlBrowser = Preferences.this.autoStartHtmlBrowserCB.isSelected();
                Preferences.this.changed = true;
            }
        });
        this.oldHtmlCode = QedeqGuiConfig.getInstance().isOldHtml();
        this.oldHtmlCodeCB = new JCheckBox(" Use System font HTML at web browser start", this.oldHtmlCode);
        contents.add(this.oldHtmlCodeCB);
        this.oldHtmlCodeCB.setBounds(33, 140 + y, 400, 17);
        this.oldHtmlCodeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.oldHtmlCode = Preferences.this.oldHtmlCodeCB.isSelected();
                Preferences.this.changed = true;
            }
        });
        return y;
    }

    private int addDirectorySettings(int y) {
        String method = "addDirectorySettings";
        Container contents = this.getContentPane();
        this.moduleBufferLabel = new JLabel("Local file path for QEDEQ module buffer");
        contents.add(this.moduleBufferLabel);
        this.moduleBufferLabel.setBounds(33, 180 + y, 400, 17);
        this.bufferDirectory = QedeqGuiConfig.getInstance().getBufferDirectory();
        this.moduleBufferTextField = new JTextField(this.bufferDirectory.getAbsolutePath());
        this.moduleBufferTextField.setEditable(false);
        contents.add(this.moduleBufferTextField);
        this.moduleBufferTextField.setBounds(33, 210 + y, 600, 21);
        JButton chooseBufferLocation = new JButton("Choose");
        chooseBufferLocation.setEnabled(false);
        contents.add(chooseBufferLocation);
        chooseBufferLocation.setBounds(543, 180 + y, 90, 21);
        chooseBufferLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Trace.trace((Class)CLASS, (Object)this, (String)"addDirectorySettings", (Object)("mkdirs=" + new Boolean(Preferences.this.bufferDirectory.mkdirs())));
                    JFileChooser chooser = new JFileChooser(Preferences.this.bufferDirectory);
                    FileFilter filter = new FileFilter(this){
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        public String getDescription() {
                            return "Directory";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(Preferences.this);
                    if (returnVal == 0) {
                        Preferences.this.moduleBufferTextField.setText(chooser.getSelectedFile().getPath());
                        Preferences.this.bufferDirectory = chooser.getSelectedFile();
                        Preferences.this.changed = true;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Preferences.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        this.generationPathLabel = new JLabel("Path for generated files");
        contents.add(this.generationPathLabel);
        this.generationPathLabel.setBounds(33, 250 + y, 400, 17);
        this.generationDirectory = QedeqGuiConfig.getInstance().getGenerationDirectory();
        this.generationPathTextField = new JTextField(this.generationDirectory.getAbsolutePath());
        this.generationPathTextField.setEditable(false);
        contents.add(this.generationPathTextField);
        this.generationPathTextField.setBounds(33, 280 + y, 600, 21);
        JButton chooseGenerationLocation = new JButton("Choose");
        chooseGenerationLocation.setEnabled(false);
        contents.add(chooseGenerationLocation);
        chooseGenerationLocation.setBounds(543, 250 + y, 90, 21);
        chooseGenerationLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Trace.trace((Class)CLASS, (Object)this, (String)"addDirectorySettings", (Object)("mkdirs=" + new Boolean(Preferences.this.generationDirectory.mkdirs())));
                    JFileChooser chooser = new JFileChooser(Preferences.this.generationDirectory);
                    FileFilter filter = new FileFilter(this){
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        public String getDescription() {
                            return "Directory";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(Preferences.this);
                    if (returnVal == 0) {
                        Preferences.this.generationPathTextField.setText(chooser.getSelectedFile().getPath());
                        Preferences.this.generationDirectory = chooser.getSelectedFile();
                        Preferences.this.changed = true;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Preferences.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        this.localModulesPathLabel = new JLabel("Path for newly created module files");
        contents.add(this.localModulesPathLabel);
        this.localModulesPathLabel.setBounds(33, 310 + y, 400, 17);
        this.localModulesDirectory = QedeqGuiConfig.getInstance().getLocalModulesDirectory();
        this.localModulesPathTextField = new JTextField(this.localModulesDirectory.getAbsolutePath());
        this.localModulesPathTextField.setEditable(false);
        contents.add(this.localModulesPathTextField);
        this.localModulesPathTextField.setBounds(33, 340 + y, 600, 21);
        JButton chooselocalModulesLocation = new JButton("Choose");
        chooselocalModulesLocation.setEnabled(false);
        contents.add(chooselocalModulesLocation);
        chooselocalModulesLocation.setBounds(543, 310 + y, 90, 21);
        chooselocalModulesLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Trace.trace((Class)CLASS, (Object)this, (String)"addDirectorySettings", (Object)("mkdirs=" + new Boolean(Preferences.this.localModulesDirectory.mkdirs())));
                    JFileChooser chooser = new JFileChooser(Preferences.this.localModulesDirectory);
                    FileFilter filter = new FileFilter(this){
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        public String getDescription() {
                            return "Directory";
                        }
                    };
                    chooser.setFileFilter(filter);
                    chooser.setFileSelectionMode(1);
                    int returnVal = chooser.showOpenDialog(Preferences.this);
                    if (returnVal == 0) {
                        Preferences.this.localModulesPathTextField.setText(chooser.getSelectedFile().getPath());
                        Preferences.this.localModulesDirectory = chooser.getSelectedFile();
                        Preferences.this.changed = true;
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(Preferences.this, e.getMessage(), "Alert", 0);
                }
            }
        });
        return y + 390;
    }

    final void save() {
        if (this.changed) {
            QedeqGuiConfig.getInstance().setBufferDirectory(this.bufferDirectory);
            QedeqGuiConfig.getInstance().setGenerationDirectory(this.generationDirectory);
            QedeqGuiConfig.getInstance().setLocalModulesDirectory(this.localModulesDirectory);
            QedeqGuiConfig.getInstance().setAutomaticLogScroll(this.automaticLogScroll);
            QedeqGuiConfig.getInstance().setDirectResponse(this.directResponse);
            QedeqGuiConfig.getInstance().setAutoReloadLastSessionChecked(this.autoReloadLastSessionChecked);
            QedeqGuiConfig.getInstance().setAutoStartHtmlBrowser(this.autoStartHtmlBrowser);
            QedeqGuiConfig.getInstance().setOldHtml(this.oldHtmlCode);
            try {
                QedeqGuiConfig.getInstance().store();
            }
            catch (IOException e) {
                Trace.fatal((Class)CLASS, (Object)this, (String)"save", (String)"couldn't save preferences", (Throwable)e);
            }
        }
    }
}

