/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import org.qedeq.base.io.TextInput;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.ResourceLoaderUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.gui.se.element.CPTextArea;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.bo.parser.LatexMathParser;
import org.qedeq.kernel.bo.parser.ParserException;
import org.qedeq.kernel.bo.parser.Term;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.xml.handler.parser.LoadXmlOperatorListUtility;

public class ParserPane
extends JFrame {
    private static final Class CLASS = ParserPane.class;
    private static final String SAMPLE = "x \\land (y \\lor z) \\leftrightarrow (x \\land y) \\lor (x \\land z)\n\n\\{ x | y \\in x \\} = \\{ z | y \\in x \\}";
    private CPTextArea source = new CPTextArea("x \\land (y \\lor z) \\leftrightarrow (x \\land y) \\lor (x \\land z)\n\n\\{ x | y \\in x \\} = \\{ z | y \\in x \\}");
    private CPTextArea resultField = new CPTextArea();
    private CPTextArea error = new CPTextArea();
    private JScrollPane sourceScroller = new JScrollPane();
    private JSplitPane splitPane = new JSplitPane(0);
    private JMenuBar menu = new JMenuBar();
    private final List operators;
    private int errorPosition = -1;
    private JSplitPane globalPane;

    public ParserPane() throws SourceFileExceptionList, FileNotFoundException {
        super("QEDEQ LaTeX Parser Sample");
        String resourceDirectoryName = "config";
        String resourceName = "mengenlehreMathOperators.xml";
        this.operators = LoadXmlOperatorListUtility.getOperatorList((File)ResourceLoaderUtility.getResourceFile((File)KernelContext.getInstance().getConfig().getBasisDirectory(), (String)"config", (String)"mengenlehreMathOperators.xml"));
        this.setupView();
        this.updateView();
    }

    public static final void main(String[] args) throws Exception {
        ParserPane parserPane = new ParserPane();
        parserPane.show();
        parserPane.updateView();
    }

    private final void setupView() {
        Container pane = this.getContentPane();
        this.source.setDragEnabled(true);
        this.source.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.source.setAutoscrolls(true);
        this.source.setCaretPosition(0);
        this.source.setEditable(true);
        this.source.getCaret().setVisible(false);
        this.source.setLineWrap(true);
        this.source.setWrapStyleWord(true);
        this.source.setFocusable(true);
        this.resultField.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.resultField.setAutoscrolls(true);
        this.resultField.setCaretPosition(0);
        this.resultField.setEditable(false);
        this.resultField.getCaret().setVisible(false);
        this.resultField.setFocusable(true);
        this.error.setFont(new Font("monospaced", 0, pane.getFont().getSize()));
        this.error.setForeground(Color.RED);
        this.error.setAutoscrolls(true);
        this.error.setCaretPosition(0);
        this.error.setEditable(false);
        this.error.getCaret().setVisible(false);
        this.error.setFocusable(true);
        this.error.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ParserPane.this.updateView();
            }
        });
        JViewport qedeqPort = this.sourceScroller.getViewport();
        qedeqPort.add(this.source);
        JScrollPane resultScroller = new JScrollPane();
        JViewport resultPort = resultScroller.getViewport();
        resultPort.add(this.resultField);
        JScrollPane errorScroller = new JScrollPane();
        JViewport errorPort = errorScroller.getViewport();
        errorPort.add(this.error);
        this.splitPane.setTopComponent(this.sourceScroller);
        this.splitPane.setBottomComponent(resultScroller);
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setOneTouchExpandable(true);
        this.error.setText("");
        this.globalPane = new JSplitPane(0);
        this.globalPane.setTopComponent(this.splitPane);
        this.globalPane.setBottomComponent(errorScroller);
        this.globalPane.setResizeWeight(1.0);
        this.globalPane.setOneTouchExpandable(true);
        pane.add(this.globalPane);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }

            public void componentShown(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentShown", (Object)e);
            }
        });
        this.menu.removeAll();
        JMenu transformMenu = new JMenu("Transform");
        transformMenu.setMnemonic('T');
        JMenuItem transform = new JMenuItem("LaTeX to QEDEQ");
        transform.setMnemonic('Q');
        transform.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                ParserPane.this.resultField.setText(ParserPane.this.printMath(ParserPane.this.source.getText()));
                ParserPane.this.updateView();
            }
        });
        transformMenu.add(transform);
        JMenuItem doSwitch = new JMenuItem("switch content");
        doSwitch.setMnemonic('S');
        doSwitch.addActionListener(new AbstractAction(){

            public final void actionPerformed(ActionEvent action) {
                String text = ParserPane.this.source.getText();
                ParserPane.this.source.setText(ParserPane.this.resultField.getText());
                ParserPane.this.resultField.setText(text);
                ParserPane.this.updateView();
            }
        });
        transformMenu.add(doSwitch);
        this.menu.add(transformMenu);
        this.setJMenuBar(this.menu);
        this.setSize(600, 400);
    }

    public void setLineWrap(boolean wrap) {
        this.source.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.source.getLineWrap();
    }

    public synchronized void updateView() {
        String method = "updateView()";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView()");
        if (this.errorPosition >= 0) {
            this.globalPane.setDividerLocation(this.globalPane.getHeight() - this.globalPane.getDividerSize() - this.error.getFontMetrics(this.error.getFont()).getHeight() * 3 - 4);
        } else {
            this.error.setText("");
            this.globalPane.setDividerLocation(this.getHeight());
        }
        this.repaint();
    }

    private String printMath(String text) {
        StringBuffer buffer = new StringBuffer(text);
        TextInput input = new TextInput(buffer);
        LatexMathParser parser = new LatexMathParser(input, this.operators);
        StringBuffer out = new StringBuffer();
        this.errorPosition = -1;
        try {
            Term term = null;
            do {
                if ((term = parser.readTerm()) == null) continue;
                out.append(term.getQedeqXml()).append("\n");
                System.out.println(term.getQedeqXml());
            } while (term != null || !parser.eof());
        }
        catch (ParserException e) {
            e.printStackTrace(System.out);
            StringBuffer result = new StringBuffer();
            this.errorPosition = input.getPosition();
            result.append(input.getRow() + ":" + input.getColumn() + ":" + "\n");
            result.append(e.getMessage() + "\n");
            result.append(input.getLine().replace('\t', ' ').replace('\r', ' ') + "\n");
            StringBuffer pointer = StringUtility.getSpaces((int)input.getColumn());
            pointer.append('^');
            result.append(pointer);
            System.out.println(result.toString());
            this.error.setText(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            StringBuffer result = new StringBuffer();
            this.errorPosition = input.getPosition();
            result.append(input.getRow() + ":" + input.getColumn() + ":" + "\n");
            result.append(e.getMessage() + "\n");
            result.append(input.getLine().replace('\t', ' ').replace('\r', ' ') + "\n");
            StringBuffer pointer = StringUtility.getSpaces((int)input.getColumn());
            pointer.append('^');
            result.append(pointer);
            System.out.println(result.toString());
            this.error.setText(result.toString());
        }
        return out.toString();
    }
}

