/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.qedeq.base.trace.Trace;
import org.qedeq.base.utility.EqualsUtility;
import org.qedeq.gui.se.control.ErrorSelectionListenerList;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.bo.log.ModuleEventListener;
import org.qedeq.kernel.common.SourceFileExceptionList;

public class ModuleErrorListPane
extends JPanel
implements ModuleEventListener {
    private static final Class CLASS = ModuleErrorListPane.class;
    private int errNo = -1;
    private JTable error = new JTable(new AbstractTableModel(){

        public String getColumnName(int column) {
            if (column == 0) {
                return "Errors for " + (ModuleErrorListPane.this.prop != null ? ModuleErrorListPane.this.prop.getName() + "(" + ModuleErrorListPane.this.prop.getModuleAddress() + ")" : "");
            }
            if (column == 1) {
                return "Location";
            }
            return "";
        }

        public int getRowCount() {
            return ModuleErrorListPane.this.sfl != null ? ModuleErrorListPane.this.sfl.size() : 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int row, int col) {
            if (ModuleErrorListPane.this.sfl == null) {
                return "";
            }
            if (col == 0) {
                return ModuleErrorListPane.this.sfl.get(row).getMessage();
            }
            if (col == 1 && ModuleErrorListPane.this.sfl.get(row).getSourceArea() != null) {
                return "line " + ModuleErrorListPane.this.sfl.get(row).getSourceArea().getStartPosition().getLine();
            }
            return "";
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
        }
    });
    private final SimpleAttributeSet errorAttrs = new SimpleAttributeSet();
    private QedeqBo prop;
    private SourceFileExceptionList sfl;
    private JScrollPane scrollPane;

    public ModuleErrorListPane() {
        super(false);
        this.setModel(null);
        this.setupView();
    }

    private void selectError() {
        if (this.sfl != null && this.errNo >= 0 && this.errNo < this.sfl.size()) {
            ErrorSelectionListenerList.getInstance().selectError(this.errNo, this.sfl.get(this.errNo));
        }
    }

    private final void setupView() {
        FormLayout layout = new FormLayout("min:grow", "0:grow");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setBorder(BorderFactory.createEmptyBorder());
        builder.setRowGroupingEnabled(true);
        CellConstraints cc = new CellConstraints();
        builder.appendRow(new RowSpec("0:grow"));
        ListSelectionModel rowSM = this.error.getSelectionModel();
        rowSM.setSelectionMode(0);
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ModuleErrorListPane.this.errNo = ModuleErrorListPane.this.error.getSelectionModel().getLeadSelectionIndex();
                Trace.param((Class)CLASS, (Object)this, (String)"setupView$valueChanged", (String)"errNo", (int)ModuleErrorListPane.this.errNo);
            }
        });
        this.error.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"setupView$vmouseClicked", (Object)"doubleClick");
                }
                ModuleErrorListPane.this.selectError();
            }
        });
        this.error.getActionMap().put("selectNextRowCell", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                Trace.param((Class)CLASS, (Object)this, (String)"setupView$actionPerformed", (String)"event", (Object)event);
                ModuleErrorListPane.this.selectError();
            }
        });
        this.scrollPane = new JScrollPane(this.error);
        builder.add((Component)this.scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 1, 2, "fill, fill"));
        StyleConstants.setForeground(this.errorAttrs, Color.red);
        this.scrollPane.getViewport().setBackground(Color.white);
        StyleConstants.setBackground(this.errorAttrs, Color.white);
        JTableHeader header = this.error.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(2);
        this.changeHeaderWidth();
    }

    private void changeHeaderWidth() {
        TableColumnModel model = this.error.getColumnModel();
        model.getColumn(0).setPreferredWidth(300);
        model.getColumn(1).setPreferredWidth(30);
    }

    public void setModel(QedeqBo prop) {
        Trace.trace((Class)CLASS, (Object)this, (String)"setModel", (Object)prop);
        if (!EqualsUtility.equals((Object)this.prop, (Object)prop)) {
            this.prop = prop;
            this.updateView();
        }
    }

    public synchronized void updateView() {
        String method = "updateView";
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        this.sfl = this.prop != null ? this.prop.getException() : null;
        ((AbstractTableModel)this.error.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.error.getModel()).fireTableStructureChanged();
        this.changeHeaderWidth();
        this.error.invalidate();
        this.error.repaint();
        this.repaint();
    }

    public void addModule(final QedeqBo p) {
        Runnable addModule = new Runnable(){

            public void run() {
                if (ModuleErrorListPane.this.prop != null && ModuleErrorListPane.this.prop.equals(p)) {
                    ModuleErrorListPane.this.updateView();
                }
            }
        };
        SwingUtilities.invokeLater(addModule);
    }

    public void stateChanged(final QedeqBo p) {
        Runnable stateChanged = new Runnable(){

            public void run() {
                if (ModuleErrorListPane.this.prop != null && ModuleErrorListPane.this.prop.equals(p)) {
                    ModuleErrorListPane.this.updateView();
                }
            }
        };
        SwingUtilities.invokeLater(stateChanged);
    }

    public void removeModule(final QedeqBo p) {
        Runnable removeModule = new Runnable(){

            public void run() {
                if (ModuleErrorListPane.this.prop != null && ModuleErrorListPane.this.prop.equals(p)) {
                    ModuleErrorListPane.this.prop = null;
                    ModuleErrorListPane.this.updateView();
                }
            }
        };
        SwingUtilities.invokeLater(removeModule);
    }
}

