/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.kernel.bo.log.LogListener;

public class LogPane
extends JPanel
implements LogListener {
    private static final Class CLASS = LogPane.class;
    private JTextPane textPane = new JTextPane();
    private final SimpleAttributeSet errorAttrs = new SimpleAttributeSet();
    private final SimpleAttributeSet successAttrs = new SimpleAttributeSet();
    private final SimpleAttributeSet messageAttrs = new SimpleAttributeSet();
    private final SimpleAttributeSet requestAttrs = new SimpleAttributeSet();

    public LogPane() {
        super(false);
        this.setupView();
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        this.textPane.setDocument(doc);
    }

    private final void setupView() {
        this.textPane.setDragEnabled(true);
        this.textPane.setAutoscrolls(true);
        this.textPane.setCaretPosition(0);
        this.textPane.setEditable(false);
        this.textPane.getCaret().setVisible(false);
        this.textPane.setFocusable(true);
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.textPane);
        this.setLayout(new BorderLayout(1, 1));
        this.add(scroller);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }

            public void componentShown(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }
        });
        StyleConstants.setForeground(this.errorAttrs, Color.red);
        StyleConstants.setForeground(this.successAttrs, Color.darkGray);
        StyleConstants.setForeground(this.messageAttrs, Color.black);
        StyleConstants.setForeground(this.requestAttrs, Color.blue);
    }

    public final void logMessageState(final String text, final URL url) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n\t" + url + "\n", LogPane.this.messageAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logMessageState", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    public final void logFailureState(final String text, final URL url, String description) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n\t" + url + "\n", LogPane.this.errorAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logFailureState", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    public final void logSuccessfulState(final String text, final URL url) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n\t" + url + "\n", LogPane.this.successAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logSuccessfulState", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    public void logRequest(final String text) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n", LogPane.this.requestAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logRequest", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    public void logSuccessfulReply(final String text) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n", LogPane.this.successAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logSuccessfulReply", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    public void logFailureReply(final String text, final String description) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n\t" + description + "\n", LogPane.this.errorAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logFailureReply", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    public void logMessage(final String text) {
        Runnable runLater = new Runnable(){

            public void run() {
                try {
                    LogPane.this.textPane.getDocument().insertString(LogPane.this.textPane.getDocument().getLength(), text + "\n", LogPane.this.messageAttrs);
                }
                catch (BadLocationException e) {
                    Trace.trace((Class)CLASS, (Object)this, (String)"logFailureReply", (Throwable)e);
                }
                LogPane.this.rework();
            }
        };
        SwingUtilities.invokeLater(runLater);
    }

    private void rework() {
        if (QedeqGuiConfig.getInstance().isAutomaticLogScroll()) {
            this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
        }
    }
}

