/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.pane;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.qedeq.base.trace.Trace;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.common.LoadingState;
import org.qedeq.kernel.common.ModuleAddress;

public class HtmlPane
extends JPanel {
    private static final Class CLASS = HtmlPane.class;
    private QedeqBo prop;
    private JEditorPane html = new JEditorPane("text/html", "\u1200");
    private boolean blocked = false;
    private ModuleAddress currentAddress = null;
    private LoadingState currentState;

    public HtmlPane(QedeqBo prop) {
        super(false);
        this.prop = prop;
        this.currentAddress = prop == null ? null : prop.getModuleAddress();
        this.currentState = prop == null ? null : prop.getLoadingState();
        this.setupView();
        this.updateView();
    }

    private final void setupView() {
        this.html.setDragEnabled(true);
        this.html.setAutoscrolls(true);
        this.html.setCaretPosition(0);
        this.html.setEditable(false);
        this.html.getCaret().setVisible(false);
        this.html.setFocusable(true);
        this.html.setDebugGraphicsOptions(1);
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.html);
        this.setLayout(new BorderLayout(1, 1));
        this.add(scroller);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }

            public void componentShown(ComponentEvent e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"componentHidden", (Object)e);
            }
        });
    }

    public void setModel(QedeqBo prop) {
        Trace.trace((Class)CLASS, (Object)this, (String)"setModel", (Object)prop);
        this.prop = prop;
    }

    public QedeqBo getModel() {
        return this.prop;
    }

    public synchronized void updateView() {
        Trace.begin((Class)CLASS, (Object)this, (String)"updateView");
        boolean refresh = false;
        if (this.prop == null && this.currentAddress != null) {
            refresh = true;
        }
        if (this.prop != null && !this.prop.getModuleAddress().equals(this.currentAddress)) {
            this.currentAddress = this.prop.getModuleAddress();
            refresh = true;
        }
        if (this.prop != null && this.currentState != this.prop.getLoadingState()) {
            this.currentState = this.prop.getLoadingState();
            refresh = true;
        }
        if (refresh && this.prop != null && this.prop.getLoadingState() == LoadingState.STATE_LOADED && !this.blocked) {
            this.blocked = true;
            try {
                this.html.setFont(new Font("Lucida Bright", 0, 12));
                this.html.setText("<html><body>\u2227 Hallo \u2227 Werter \u2227 \u2227 \u2227<br><table><tr><td>Hei</td><td>ho</td></tr><tr><td>Ostern</td><td>weihnacht</td></tr></table></body></html>");
            }
            catch (Exception e) {
                Trace.trace((Class)CLASS, (Object)this, (String)"updateView", (Throwable)e);
                this.html.setText("");
            }
            this.blocked = false;
        } else {
            this.html.setText("");
        }
        this.repaint();
        Trace.end((Class)CLASS, (Object)this, (String)"updateView");
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HtmlPane.this.html.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            HtmlPane.this.html.setPage(e.getURL());
                        }
                        catch (IOException ioe) {
                            System.out.println("IOE: " + ioe);
                        }
                    }
                }
            }
        };
    }
}

