/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.main;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.ErrorSelectionListener;
import org.qedeq.gui.se.control.ErrorSelectionListenerList;
import org.qedeq.gui.se.pane.HtmlPane;
import org.qedeq.gui.se.pane.ModulePropertiesPane;
import org.qedeq.gui.se.pane.QedeqPane;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.common.SourceFileException;

public final class UpperTabbedView
extends JPanel
implements ErrorSelectionListener {
    private static final Class CLASS = UpperTabbedView.class;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private QedeqPane qedeqPane;
    private HtmlPane htmlPane;
    private QedeqBo prop;
    private ModulePropertiesPane propertiesPane;
    private boolean viewHtml = false;

    public UpperTabbedView() {
        try {
            this.propertiesPane = new ModulePropertiesPane(this.prop);
            this.qedeqPane = new QedeqPane(this.prop);
            this.htmlPane = new HtmlPane(this.prop);
            this.tabbedPane.addTab("State", null, this.propertiesPane, "Shows Status of Module");
            this.tabbedPane.addTab("QEDEQ", null, this.qedeqPane, "Shows Module in QEDEQ Syntax");
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        catch (RuntimeException e) {
            Trace.trace((Class)CLASS, (Object)this, (String)"constructor", (Throwable)e);
            throw e;
        }
        this.add(this.tabbedPane);
        this.setLayout(new GridLayout(1, 1));
        ErrorSelectionListenerList.getInstance().addListener(this);
    }

    public final void setHtmlView(boolean enable) {
        this.viewHtml = enable;
        if (enable) {
            this.tabbedPane.addTab("Html", null, this.htmlPane, "Shows Module in Html-View");
            this.htmlPane.updateView();
        } else {
            this.tabbedPane.remove(this.htmlPane);
        }
    }

    public boolean getHtmlView() {
        return this.viewHtml;
    }

    public void setQedeqModel(QedeqBo model) {
        this.propertiesPane.setModel(model);
        this.qedeqPane.setModel(model);
        this.htmlPane.setModel(model);
        if (this.prop != model) {
            this.prop = model;
            this.updateView();
        }
    }

    public QedeqBo getQedeqModel() {
        return this.prop;
    }

    public final void updateView() {
        this.propertiesPane.updateView();
        this.qedeqPane.updateView();
        if (this.viewHtml) {
            this.htmlPane.updateView();
        }
    }

    public void setLineWrap(boolean wrap) {
        this.qedeqPane.setLineWrap(wrap);
    }

    public boolean getLineWrap() {
        return this.qedeqPane.getLineWrap();
    }

    public String getEditedQedeq() {
        return this.qedeqPane.getEditedQedeq();
    }

    public void selectError(int errorNumber, SourceFileException sf) {
        this.tabbedPane.setSelectedComponent(this.qedeqPane);
    }
}

