/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.main;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.main.GuiOptions;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.gui.se.util.MenuHelper;

public class QedeqMenuBar
extends JMenuBar {
    private QedeqController controller;

    public QedeqMenuBar(QedeqController controller, GuiOptions options) {
        this.controller = controller;
        this.putClientProperty("jgoodies.headerStyle", options.getMenuBarHeaderStyle());
        this.putClientProperty("Plastic.borderStyle", options.getMenuBarPlasticBorderStyle());
        this.putClientProperty("jgoodies.windows.borderStyle", options.getMenuBarWindowsBorderStyle());
        this.putClientProperty("Plastic.is3D", options.getMenuBar3DHint());
        this.add(this.createFileMenu());
        this.add(this.createCheckMenu());
        this.add(this.createTransformMenu());
        this.add(this.createToolsMenu());
        this.add(this.createHelpMenu());
    }

    private JMenu createFileMenu() {
        JMenu menu = MenuHelper.createMenu("File", 'F');
        JMenuItem item = MenuHelper.createMenuItem("Load from Web", 'W');
        item.addActionListener(this.controller.getAddAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/list-add.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Load local File", 'F');
        item.addActionListener(this.controller.getAddFileAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/document-open.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Load all from QEDEQ", 'Q');
        item.addActionListener(this.controller.getAddAllModulesFromQedeqAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/go-home.png"));
        menu.add(item);
        menu.addSeparator();
        item = MenuHelper.createMenuItem("Remove module", 'R');
        item.addActionListener(this.controller.getRemoveModuleAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/edit-cut.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Clear Buffer", 'C');
        item.addActionListener(this.controller.getRemoveLocalBufferAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/edit-delete.png"));
        menu.add(item);
        if (!MenuHelper.isQuitInOSMenu()) {
            menu.addSeparator();
            item = MenuHelper.createMenuItem("Exit", 'E');
            item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/system-log-out.png"));
            item.addActionListener(this.controller.getExitAction());
            menu.add(item);
        }
        return menu;
    }

    private JMenu createCheckMenu() {
        JMenu menu = MenuHelper.createMenu("Check", 'C');
        JMenuItem item = MenuHelper.createMenuItem("Check Mathematical Logic", 'M');
        item.addActionListener(this.controller.getCheckLogicAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/actions/media-record.png"));
        menu.add(item);
        return menu;
    }

    private JMenu createTransformMenu() {
        JMenu menu = MenuHelper.createMenu("Transform", 'T');
        JMenuItem item = MenuHelper.createMenuItem("Create LaTeX output", 'L');
        item.addActionListener(this.controller.getLatexAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/mimetypes/x-office-document.png"));
        menu.add(item);
        return menu;
    }

    private JMenu createToolsMenu() {
        JMenu menu = MenuHelper.createMenu("Tools", 'o');
        JMenuItem item = MenuHelper.createMenuItem("LaTeX to QEDEQ", 'L');
        item.addActionListener(this.controller.getParserAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/categories/applications-system.png"));
        menu.add(item);
        item = MenuHelper.createMenuItem("Preferences", 'P');
        item.addActionListener(this.controller.getPreferencesAction());
        item.setIcon(GuiHelper.readImageIcon("tango/16x16/categories/preferences-system.png"));
        menu.add(item);
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = MenuHelper.createMenu("Help", 'H');
        JMenuItem item = MenuHelper.createMenuItem("Help Contents", GuiHelper.readImageIcon("tango/16x16/apps/help-browser.png"), 'H');
        item.addActionListener(this.controller.getHelpAction());
        menu.add(item);
        if (!MenuHelper.isAboutInOSMenu()) {
            menu.addSeparator();
            item = MenuHelper.createMenuItem("About", GuiHelper.readImageIcon("qedeq/16x16/qedeq.png"), 'a');
            item.addActionListener(this.controller.getAboutAction());
            menu.add(item);
        }
        return menu;
    }
}

