/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.main;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.main.LowerTabbedView;
import org.qedeq.gui.se.main.UpperTabbedView;
import org.qedeq.gui.se.tree.QedeqTreeCtrl;
import org.qedeq.gui.se.tree.QedeqTreeModel;
import org.qedeq.gui.se.tree.QedeqTreeView;
import org.qedeq.kernel.bo.log.ModuleEventListener;
import org.qedeq.kernel.bo.log.ModuleEventLog;

public class QedeqMainPane
extends JPanel {
    public QedeqMainPane(QedeqController controller) {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(Borders.DIALOG_BORDER);
        this.add(this.createSplits(controller));
    }

    private JComponent createSplits(QedeqController controller) {
        QedeqTreeModel treeModel = new QedeqTreeModel();
        ModuleEventLog.getInstance().addLog((ModuleEventListener)treeModel);
        QedeqTreeView treeView = new QedeqTreeView(treeModel);
        UpperTabbedView tabbedView = new UpperTabbedView();
        LowerTabbedView lowerView = new LowerTabbedView();
        tabbedView.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
        QedeqTreeCtrl treeCtrl = new QedeqTreeCtrl(treeView, treeModel, tabbedView, lowerView, controller);
        controller.setTreeCtrl(treeCtrl);
        JScrollPane left = new JScrollPane(treeView);
        left.setPreferredSize(new Dimension(200, 200));
        UpperTabbedView right = tabbedView;
        right.setPreferredSize(new Dimension(200, 150));
        LowerTabbedView lower = lowerView;
        lower.setPreferredSize(new Dimension(200, 100));
        UIFSplitPane horizontalSplit = UIFSplitPane.createStrippedSplitPane(1, left, right);
        UIFSplitPane verticalSplit = UIFSplitPane.createStrippedSplitPane(0, horizontalSplit, lower);
        return verticalSplit;
    }
}

