/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.main;

import com.jgoodies.looks.LookUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.qedeq.base.io.IoUtility;
import org.qedeq.base.utility.StringUtility;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.main.GuiOptions;
import org.qedeq.gui.se.main.QedeqMainPane;
import org.qedeq.gui.se.main.QedeqMenuBar;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.gui.se.util.GuiHelper;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.bo.context.KernelProperties;
import org.qedeq.kernel.bo.context.KernelServices;
import org.qedeq.kernel.bo.log.LogListener;
import org.qedeq.kernel.bo.log.LogListenerImpl;
import org.qedeq.kernel.bo.log.ModuleEventListener;
import org.qedeq.kernel.bo.log.ModuleEventListenerLog;
import org.qedeq.kernel.bo.log.ModuleEventLog;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.bo.module.QedeqFileDao;
import org.qedeq.kernel.bo.service.DefaultInternalKernelServices;
import org.qedeq.kernel.config.QedeqConfig;
import org.qedeq.kernel.xml.dao.XmlQedeqFileDao;

public class QedeqMainFrame
extends JFrame {
    protected static final Dimension PREFERRED_SIZE = LookUtils.IS_LOW_RESOLUTION ? new Dimension(650, 510) : new Dimension(730, 560);

    public QedeqMainFrame(GuiOptions settings) throws IOException {
        GuiHelper.configureUI(settings);
        this.checkDirectoryExistenceAndOptionallyCreate(QedeqGuiConfig.getInstance());
        QedeqLog.getInstance().addLog((LogListener)new LogListenerImpl());
        QedeqLog.getInstance().addLog((LogListener)new LogListenerImpl(new PrintStream(new FileOutputStream(new File(QedeqGuiConfig.getInstance().getBasisDirectory(), QedeqGuiConfig.getInstance().getLogFile()), true), true)));
        ModuleEventLog.getInstance().addLog((ModuleEventListener)new ModuleEventListenerLog());
        KernelContext.getInstance().init((KernelServices)new DefaultInternalKernelServices((KernelProperties)KernelContext.getInstance(), (QedeqFileDao)new XmlQedeqFileDao()), (QedeqConfig)QedeqGuiConfig.getInstance());
        final QedeqController controller = new QedeqController(this);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new QedeqMainPane(controller), "Center");
        this.setContentPane(panel);
        this.setTitle(" " + KernelContext.getInstance().getDescriptiveKernelVersion());
        QedeqMenuBar menuBar = new QedeqMenuBar(controller, settings);
        this.setJMenuBar(menuBar);
        this.setIconImage(GuiHelper.readImageIcon("qedeq/16x16/qedeq.png").getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                controller.getExitAction().actionPerformed(null);
            }
        });
    }

    private void checkDirectoryExistenceAndOptionallyCreate(QedeqGuiConfig config) throws IOException {
        File file = new File(config.getBasisDirectory(), config.getLogFile());
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("can't create directory: " + dir.getAbsolutePath());
        }
    }

    private static void initLog4J(QedeqGuiConfig config) {
        String resourceName = "log4j.xml";
        String resourceDirectoryName = "config";
        File resourceDir = new File(config.getBasisDirectory(), resourceDirectoryName);
        File resource = new File(resourceDir, "log4j.xml");
        String res = "/" + resourceDirectoryName + "/" + "log4j.xml";
        if (!resource.exists()) {
            URL url = QedeqMainFrame.class.getResource(res);
            if (url == null) {
                QedeqMainFrame.errorPrintln("Resource not found: " + res);
            } else {
                try {
                    if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                        QedeqMainFrame.errorPrintln("Creation of directory failed: " + resourceDir.getAbsolutePath());
                    }
                    StringBuffer buffer = new StringBuffer();
                    IoUtility.loadFile((URL)url, (StringBuffer)buffer, (String)"ISO-8859-1");
                    File traceFile = config.createAbsolutePath("log/trace.txt");
                    StringUtility.replace((StringBuffer)buffer, (String)"@trace_file_path@", (String)traceFile.toString().replace('\\', '/'));
                    IoUtility.saveFile((File)resource, (StringBuffer)buffer, (String)"ISO-8859-1");
                    res = IoUtility.toUrl((File)resource).toString();
                }
                catch (IOException e1) {
                    QedeqMainFrame.errorPrintln("Resource can not be saved: " + resource.getAbsolutePath());
                    e1.printStackTrace();
                }
            }
        } else {
            res = IoUtility.toUrl((File)resource).toString();
        }
        System.setProperty("log4j.configDebug", "true");
        System.setProperty("log4j.configuration", res);
        try {
            if (res.endsWith(".xml")) {
                DOMConfigurator.configureAndWatch((String)resource.getCanonicalPath(), (long)5000L);
            } else {
                PropertyConfigurator.configureAndWatch((String)resource.getCanonicalPath(), (long)5000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void errorPrintln(String message) {
        System.err.println("ERROR>>> " + message);
    }

    public static void main(String[] args) {
        QedeqMainFrame instance;
        try {
            QedeqGuiConfig.init(new File(IoUtility.getStartDirectory((String)"qedeq"), "config/org.qedeq.properties"), IoUtility.getStartDirectory((String)"qedeq"));
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showInternalMessageDialog(null, "Configuration file not found!\n\n" + e.getMessage(), "Hilbert II - Error", 0);
        }
        QedeqMainFrame.initLog4J(QedeqGuiConfig.getInstance());
        GuiOptions options = new GuiOptions();
        if (args.length > 0) {
            String lafShortName = args[0];
            String lafClassName = "Windows".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.windows.WindowsLookAndFeel" : ("Plastic".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.plastic.PlasticLookAndFeel" : ("Plastic3D".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.plastic.Plastic3DLookAndFeel" : ("PlasticXP".equalsIgnoreCase(lafShortName) ? "com.jgoodies.looks.plastic.PlasticXPLookAndFeel" : lafShortName)));
            options.setSelectedLookAndFeel(lafClassName);
        }
        try {
            instance = new QedeqMainFrame(options);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Application start failed!\n\n" + e.getMessage(), "Hilbert II - Error", 0);
            KernelContext.getInstance().shutdown();
            System.exit(-1);
            return;
        }
        instance.setSize(PREFERRED_SIZE);
        Dimension paneSize = instance.getSize();
        Dimension screenSize = instance.getToolkit().getScreenSize();
        instance.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
        instance.setVisible(true);
        IoUtility.sleep((int)100);
        KernelContext.getInstance().startup();
    }
}

