/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.bo.log.QedeqLog;

class RemoveLocalBufferAction
extends AbstractAction {
    private static final Class CLASS = RemoveLocalBufferAction.class;
    private final QedeqController controller;

    RemoveLocalBufferAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (Object)e);
        Thread thread = new Thread(){

            public void run() {
                try {
                    QedeqLog.getInstance().logRequest("Clear local buffer from all QEDEQ files.");
                    KernelContext.getInstance().clearLocalBuffer();
                    QedeqLog.getInstance().logSuccessfulReply("Local buffer was cleared.");
                }
                catch (IOException e) {
                    Trace.fatal((Class)CLASS, (Object)RemoveLocalBufferAction.this.controller, (String)"actionPerformed", (String)"IO access problem", (Throwable)e);
                    QedeqLog.getInstance().logFailureReply("IO access problem", e.getMessage());
                }
                catch (RuntimeException e) {
                    Trace.fatal((Class)CLASS, (Object)RemoveLocalBufferAction.this.controller, (String)"actionPerformed", (String)"unexpected problem", (Throwable)e);
                    QedeqLog.getInstance().logFailureReply("Remove failed", e.getMessage());
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

