/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.tree.NothingSelectedException;
import org.qedeq.kernel.bo.QedeqBo;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.bo.log.QedeqLog;
import org.qedeq.kernel.common.SourceFileExceptionList;

class MakeLatexAction
extends AbstractAction {
    private static final Class CLASS = MakeLatexAction.class;
    private final QedeqController controller;

    MakeLatexAction(QedeqController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        String method = "actionPerformed";
        Trace.begin((Class)CLASS, (Object)this, (String)"actionPerformed");
        try {
            QedeqBo[] props;
            try {
                props = this.controller.getSelected();
            }
            catch (NothingSelectedException ex) {
                this.controller.selectionError();
                Trace.end((Class)CLASS, (Object)this, (String)"actionPerformed");
                return;
            }
            Thread thread = new Thread(){

                public void run() {
                    for (int i = 0; i < props.length; ++i) {
                        try {
                            QedeqLog.getInstance().logRequest("Generate LaTeX from \"" + props[i].getUrl() + "\"");
                            String[] languages = MakeLatexAction.this.controller.getSupportedLanguages(props[i]);
                            for (int j = 0; j < languages.length; ++j) {
                                String result = KernelContext.getInstance().generateLatex(props[i].getModuleAddress(), languages[j], "1");
                                if (languages[j] != null) {
                                    QedeqLog.getInstance().logSuccessfulReply("LaTeX for language \"" + languages[j] + "\" was generated from \"" + props[i].getUrl() + "\" into \"" + result + "\"");
                                    continue;
                                }
                                QedeqLog.getInstance().logSuccessfulReply("LaTeX for default language was generated from \"" + props[i].getUrl() + "\" into \"" + result + "\"");
                            }
                            continue;
                        }
                        catch (SourceFileExceptionList e) {
                            String msg = "Generation failed for \"" + props[i].getUrl() + "\"";
                            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)msg, (Throwable)e);
                            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
                            continue;
                        }
                        catch (IOException e) {
                            String msg = "Generation failed for \"" + props[i].getUrl() + "\"";
                            Trace.fatal((Class)CLASS, (Object)this, (String)"actionPerformed", (String)msg, (Throwable)e);
                            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
                            continue;
                        }
                        catch (RuntimeException e) {
                            Trace.fatal((Class)CLASS, (Object)MakeLatexAction.this.controller, (String)"actionPerformed", (String)"unexpected problem", (Throwable)e);
                            QedeqLog.getInstance().logFailureReply("Generation failed", e.getMessage());
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        finally {
            Trace.end((Class)CLASS, (Object)this, (String)"actionPerformed");
        }
    }
}

