/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.gui.se.control;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.qedeq.base.trace.Trace;
import org.qedeq.gui.se.control.QedeqController;
import org.qedeq.gui.se.pane.QedeqGuiConfig;
import org.qedeq.kernel.bo.context.KernelContext;
import org.qedeq.kernel.common.ModuleAddress;

class AddFileAction
extends AbstractAction {
    private static final Class CLASS = AddFileAction.class;
    private final QedeqController controller;
    private File file = QedeqGuiConfig.getInstance().getFileBrowserStartDirecty();

    AddFileAction(QedeqController controller) {
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        ModuleAddress address;
        Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (Object)e);
        JFileChooser chooser = new JFileChooser(this.file);
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getPath().endsWith(".xml");
            }

            public String getDescription() {
                return "Qedeq Modules";
            }
        };
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.controller.getMainFrame());
        if (returnVal != 0) {
            return;
        }
        try {
            this.file = chooser.getSelectedFile().getParentFile();
            QedeqGuiConfig.getInstance().setFileBrowserStartDirecty(this.file);
            address = KernelContext.getInstance().getModuleAddress(chooser.getSelectedFile());
        }
        catch (IOException ie) {
            Trace.trace((Class)CLASS, (Object)this, (String)"actionPerformed", (String)"no correct URL", (Throwable)ie);
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "this is no valid QEDEQ file: " + chooser.getSelectedFile() + "\n" + ie.getMessage(), "Error", 0);
            return;
        }
        this.controller.addToModuleHistory(address.getURL().toString());
        Thread thread = new Thread(){

            public void run() {
                KernelContext.getInstance().loadModule(address);
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

