/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.tracker;

import com.sun.syndication.io.XmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.kernel.common.SourcePosition;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.Enumerator;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.TextInput;
import org.qedeq.kernel.xml.parser.SimpleHandler;
import org.qedeq.kernel.xml.tracker.SimpleXPath;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XPathLocationParser
extends SimpleHandler {
    private static final Class CLASS = class$org$qedeq$kernel$xml$tracker$XPathLocationParser == null ? (class$org$qedeq$kernel$xml$tracker$XPathLocationParser = XPathLocationParser.class$("org.qedeq.kernel.xml.tracker.XPathLocationParser")) : class$org$qedeq$kernel$xml$tracker$XPathLocationParser;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private XMLReader reader;
    private final SimpleXPath find;
    private SimpleXPath current;
    private SimpleXPath summary;
    private File xmlFile;
    private final List elements;
    private int level;
    private URL original;
    static /* synthetic */ Class class$org$qedeq$kernel$xml$tracker$XPathLocationParser;

    public static final SimpleXPath getXPathLocation(File xmlFile, String xpath, URL original) throws ParserConfigurationException, SAXException, IOException {
        XPathLocationParser parser = new XPathLocationParser(xpath);
        parser.parse(xmlFile, original);
        return parser.getFind();
    }

    public static final SimpleXPath getXPathLocation(File xmlFile, SimpleXPath xpath, URL original) throws ParserConfigurationException, SAXException, IOException {
        return XPathLocationParser.getXPathLocation(xmlFile, xpath.toString(), original);
    }

    public XPathLocationParser(String xpath) throws ParserConfigurationException, SAXException {
        this.find = new SimpleXPath(xpath);
        this.elements = new ArrayList(20);
        this.level = 0;
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        factory.setFeature(NAMESPACES_FEATURE_ID, false);
        factory.setFeature(VALIDATION_FEATURE_ID, false);
        SAXParser parser = factory.newSAXParser();
        this.reader = parser.getXMLReader();
        this.reader.setFeature(NAMESPACES_FEATURE_ID, false);
        this.reader.setFeature(VALIDATION_FEATURE_ID, false);
    }

    public final void parse(String fileName, URL original) throws SAXException, IOException {
        File file = new File(fileName);
        this.parse(file, original);
    }

    public final void parse(File file, URL original) throws SAXException, IOException {
        this.xmlFile = file;
        this.original = original;
        this.elements.clear();
        this.level = 0;
        try {
            this.current = new SimpleXPath();
            this.summary = new SimpleXPath();
            this.reader.setContentHandler(this);
            FileInputStream stream = new FileInputStream(file);
            this.reader.parse(new InputSource(stream));
            this.xmlFile = null;
        }
        catch (SAXException e) {
            Trace.trace(CLASS, (Object)this, "parse", (Throwable)e);
            throw e;
        }
    }

    public void endDocument() throws SAXException {
        this.elements.clear();
        this.level = 0;
    }

    public void startDocument() throws SAXException {
        this.elements.clear();
        this.level = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block13: {
            String method = "startElement(String, String, Attributes)";
            ++this.level;
            this.summary.addElement("*", this.addOccurence("*"));
            this.current.addElement(qName, this.addOccurence(qName));
            if (this.getLocator() == null) {
                throw new SAXException("Locator unexpectedly null");
            }
            if (!this.find.matchesElements(this.current, this.summary)) break block13;
            Trace.trace(CLASS, (Object)this, "startElement(String, String, Attributes)", "matching elements");
            Trace.param(CLASS, (Object)this, "startElement(String, String, Attributes)", qName, this.current);
            TextInput xml = null;
            XmlReader xmlReader = null;
            try {
                xmlReader = new XmlReader(this.xmlFile);
                xml = new TextInput(xmlReader);
            }
            catch (IOException io) {
                try {
                    Trace.fatal(CLASS, this, "startElement(String, String, Attributes)", "File \"" + this.xmlFile + "\" should be readable", io);
                    if (this.getLocator() == null) {
                        throw new SAXException("Locator unexpectedly null");
                    }
                    this.find.setStartLocation(new SourcePosition(this.original, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()));
                }
                catch (Throwable throwable) {
                    IoUtility.close(xmlReader);
                    throw throwable;
                }
                IoUtility.close(xmlReader);
                return;
            }
            IoUtility.close(xmlReader);
            xml.setRow(this.getLocator().getLineNumber());
            xml.setColumn(this.getLocator().getColumnNumber());
            try {
                xml.skipBackToBeginOfXmlTag();
            }
            catch (RuntimeException e) {
                Trace.trace(CLASS, (Object)this, "startElement(String, String, Attributes)", (Throwable)e);
            }
            this.find.setStartLocation(new SourcePosition(this.original, xml.getRow(), xml.getColumn()));
            if (this.find.getAttribute() != null) {
                xml.read();
                xml.readNextXmlName();
                while (true) {
                    String tag;
                    xml.skipWhiteSpace();
                    int row = xml.getRow();
                    int col = xml.getColumn();
                    try {
                        tag = xml.readNextXmlName();
                    }
                    catch (IllegalArgumentException e) {
                        break;
                    }
                    if (tag.equals(this.find.getAttribute())) {
                        this.find.setStartLocation(new SourcePosition(this.original, row, col));
                        xml.readNextAttributeValue();
                        this.find.setEndLocation(new SourcePosition(this.original, xml.getRow(), xml.getColumn()));
                        break;
                    }
                    xml.readNextAttributeValue();
                }
            }
        }
    }

    private int addOccurence(String name) {
        Enumerator counter;
        while (this.level < this.elements.size()) {
            this.elements.remove(this.elements.size() - 1);
        }
        while (this.level > this.elements.size()) {
            this.elements.add(new HashMap());
        }
        Map levelMap = (Map)this.elements.get(this.level - 1);
        if (levelMap.containsKey(name)) {
            counter = (Enumerator)levelMap.get(name);
            counter.increaseNumber();
        } else {
            counter = new Enumerator(1);
            levelMap.put(name, counter);
        }
        return counter.getNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        block6: {
            String method = "endElement(String, String, Attributes)";
            --this.level;
            if (this.getLocator() == null) {
                this.current.deleteLastElement();
                this.summary.deleteLastElement();
                throw new SAXException("Locator unexpectly null");
            }
            if (!this.find.matchesElements(this.current, this.summary) || this.find.getAttribute() != null) break block6;
            TextInput xml = null;
            XmlReader xmlReader = null;
            try {
                xmlReader = new XmlReader(this.xmlFile);
                xml = new TextInput(xmlReader);
            }
            catch (IOException io) {
                try {
                    Trace.fatal(CLASS, this, "endElement(String, String, Attributes)", "File \"" + this.xmlFile + "\" should be readable", io);
                    if (this.getLocator() == null) {
                        throw new SAXException("Locator unexpectedly null");
                    }
                    this.find.setStartLocation(new SourcePosition(this.original, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()));
                }
                catch (Throwable throwable) {
                    IoUtility.close(xmlReader);
                    throw throwable;
                }
                IoUtility.close(xmlReader);
                return;
            }
            IoUtility.close(xmlReader);
            xml.setRow(this.getLocator().getLineNumber());
            xml.setColumn(this.getLocator().getColumnNumber());
            this.find.setEndLocation(new SourcePosition(this.original, xml.getRow(), xml.getColumn()));
        }
        this.current.deleteLastElement();
        this.summary.deleteLastElement();
    }

    public SimpleXPath getFind() {
        return this.find;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

