/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxEntityResolver;
import org.qedeq.kernel.xml.parser.SaxErrorHandler;
import org.qedeq.kernel.xml.parser.SimpleHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;

public final class SaxParser {
    private static final Class CLASS = class$org$qedeq$kernel$xml$parser$SaxParser == null ? (class$org$qedeq$kernel$xml$parser$SaxParser = SaxParser.class$("org.qedeq.kernel.xml.parser.SaxParser")) : class$org$qedeq$kernel$xml$parser$SaxParser;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private SaxDefaultHandler handler;
    private XMLReader reader;
    private final SimpleHandler deflt;
    private DefaultSourceFileExceptionList exceptionList;
    static /* synthetic */ Class class$org$qedeq$kernel$xml$parser$SaxParser;

    public SaxParser(SaxDefaultHandler handler) throws ParserConfigurationException, SAXException {
        this.handler = handler;
        this.deflt = new SimpleHandler();
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        if (factoryImpl == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setFeature(NAMESPACES_FEATURE_ID, true);
        factory.setFeature(VALIDATION_FEATURE_ID, true);
        try {
            factory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
        try {
            factory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
        SAXParser parser = factory.newSAXParser();
        if (!parser.isNamespaceAware()) {
            throw new ParserConfigurationException("Current XML parser doesn't support namespaces.");
        }
        if (!parser.isValidating()) {
            throw new ParserConfigurationException("Current XML parser doesn't support schema validation.");
        }
        this.reader = parser.getXMLReader();
        this.reader.setEntityResolver(new SaxEntityResolver(handler));
        this.reader.setFeature(NAMESPACES_FEATURE_ID, true);
        this.reader.setFeature(VALIDATION_FEATURE_ID, true);
        try {
            this.reader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
        try {
            this.reader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        }
        catch (SAXNotRecognizedException e) {
            Trace.trace(CLASS, (Object)this, "constructor", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parse(File in, boolean validateOnly, URL original) throws SourceFileExceptionList {
        block14: {
            method = "parse(URL, boolean, InputStream)";
            stream = null;
            try {
                block13: {
                    stream = new FileInputStream(in);
                    input = new InputSource(stream);
                    this.exceptionList = new DefaultSourceFileExceptionList();
                    this.reader.setErrorHandler(new SaxErrorHandler(original, this.exceptionList));
                    if (validateOnly) {
                        this.reader.setContentHandler(this.deflt);
                        this.reader.parse(input);
                        break block13;
                    }
                    this.handler.setExceptionList(this.exceptionList);
                    this.reader.setContentHandler(this.handler);
                    this.handler.setUrl(original);
                    this.reader.parse(input);
                }
                var9_9 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {
                        Trace.trace(SaxParser.CLASS, (Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    Trace.trace(SaxParser.CLASS, (Object)this, "parse(URL, boolean, InputStream)", (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (SAXException e) {
                    ex = new SourceFileException(e);
                    if (this.exceptionList.size() <= 0) {
                        this.exceptionList.add(ex);
                    }
                    throw this.exceptionList;
                }
                catch (IOException e) {
                    this.exceptionList.add(e);
                    throw this.exceptionList;
                }
            }
        }
        if (this.exceptionList.size() > 0) {
            throw this.exceptionList;
        }
    }

    public final void parse(String fileName, URL original) throws SourceFileExceptionList {
        File file = new File(fileName);
        this.parse(file.getAbsoluteFile(), original);
    }

    public final void parse(File file, URL original) throws SourceFileExceptionList {
        this.parse(file, true, original);
        this.parse(file, false, original);
    }

    public DefaultSourceFileExceptionList getExceptionList() {
        return this.exceptionList;
    }

    public String getEncoding() {
        return this.deflt.getEncoding();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

