/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.common;

import org.qedeq.kernel.common.QedeqException;
import org.qedeq.kernel.common.SourcePosition;

public final class XmlSyntaxException
extends QedeqException {
    public static final int SAX_PARSER_EXCEPTION = 9001;
    public static final int UNEXPECTED_TAG_CODE = 9002;
    public static final String UNEXPECTED_TAG_TEXT = "Unexpected tag: ";
    public static final int UNEXPECTED_DATA_CODE = 9003;
    public static final String UNEXPECTED_DATA_TEXT = "Unexpected character data in tag: ";
    public static final int MISSING_ATTRIBUTE_CODE = 9004;
    public static final String MISSING_ATTRIBUTE_TEXT_1 = "Missing attribute: ";
    public static final String MISSING_ATTRIBUTE_TEXT_2 = " in tag: ";
    public static final int EMPTY_ATTRIBUTE_CODE = 9004;
    public static final String EMPTY_ATTRIBUTE_TEXT_1 = "Missing attribute: ";
    public static final String EMPTY_ATTRIBUTE_TEXT_2 = " in tag: ";
    public static final int PROGRAMMING_ERROR_CODE = 9999;
    public static final String PROGRAMMING_ERROR_TEXT = "A programming error occurred.";
    private SourcePosition position;

    private XmlSyntaxException(int code, String message) {
        super(code, message);
    }

    private XmlSyntaxException(int code, String message, RuntimeException e) {
        super(code, message, e);
    }

    public final SourcePosition getErrorPosition() {
        return this.position;
    }

    public final void setErrorPosition(SourcePosition position) {
        this.position = position;
    }

    public static final XmlSyntaxException createUnexpectedTagException(String name) {
        return new XmlSyntaxException(9002, UNEXPECTED_TAG_TEXT + name);
    }

    public static final XmlSyntaxException createUnexpectedTextDataException(String name, String value) {
        return new XmlSyntaxException(9003, UNEXPECTED_DATA_TEXT + name);
    }

    public static final XmlSyntaxException createMissingAttributeException(String name, String attribute) {
        return new XmlSyntaxException(9004, "Missing attribute: " + attribute + " in tag: " + name);
    }

    public static final XmlSyntaxException createEmptyAttributeException(String name, String attribute) {
        return new XmlSyntaxException(9004, "Missing attribute: " + attribute + " in tag: " + name);
    }

    public static final XmlSyntaxException createByRuntimeException(RuntimeException e) {
        return new XmlSyntaxException(9999, PROGRAMMING_ERROR_TEXT, e);
    }
}

