/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.utility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public final class StringUtility {
    private StringUtility() {
    }

    public static String replace(String text, String search, String replace) {
        int pos2;
        int len = search.length();
        if (len == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int pos1 = 0;
        while (0 <= (pos2 = text.indexOf(search, pos1))) {
            result.append(text.substring(pos1, pos2));
            result.append(replace);
            pos1 = pos2 + len;
        }
        if (pos1 < text.length()) {
            result.append(text.substring(pos1));
        }
        return result.toString();
    }

    public static void replace(StringBuffer text, String search, String replace) {
        String result = StringUtility.replace(text.toString(), search, replace);
        text.setLength(0);
        text.append(result);
    }

    public static String quote(String unquoted) {
        String result = "\"";
        for (int i = 0; i < unquoted.length(); ++i) {
            result = unquoted.charAt(i) == '\"' ? result + "\"\"" : result + unquoted.charAt(i);
        }
        result = result + '\"';
        return result;
    }

    public static boolean isLetterDigitString(String text) {
        if (text.length() <= 0) {
            return false;
        }
        if (!Character.isLetter(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Character.isLetterOrDigit(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static StringBuffer getSpaces(int length) {
        StringBuffer buffer = new StringBuffer(length >= 0 ? length : 0);
        for (int i = 0; i < length; ++i) {
            buffer.append(' ');
        }
        return buffer;
    }

    public static String getClassName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    public static void deleteLineLeadingWhitespace(StringBuffer buffer) {
        int start = -1;
        while (0 <= (start = buffer.indexOf("\n", start + 1)) && (start + 1 >= buffer.length() || '\n' == buffer.charAt(start + 1))) {
        }
        if (start >= 0) {
            int next;
            for (next = start + 1; next < buffer.length() && Character.isWhitespace(buffer.charAt(next)) && '\n' != buffer.charAt(next); ++next) {
            }
            String empty = buffer.substring(start, next);
            if (empty.length() > 0) {
                StringUtility.replace(buffer, empty, "\n");
            }
        }
    }

    public static String escapeProperty(String value) {
        Properties newprops = new Properties();
        newprops.put("key", value);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            newprops.store(out, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            String file = out.toString("ISO-8859-1");
            return file.substring(file.indexOf(10) + 1 + "key=".length());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeXmlMarkup(StringBuffer value) {
        StringUtility.replace(value, "&lt;", "<");
        StringUtility.replace(value, "&gt;", ">");
        StringUtility.replace(value, "&amp;", "&");
        return value.toString();
    }
}

