/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.utility;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class IoUtility {
    static /* synthetic */ Class class$java$lang$Object;

    private IoUtility() {
    }

    public static String getDefaultEncoding() {
        return new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    }

    public static String getWorkingEncoding(String encoding) {
        if (encoding != null) {
            try {
                if (Charset.isSupported(encoding) && Charset.forName(encoding).canEncode()) {
                    return encoding;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        System.err.println("not supported encoding: " + encoding);
        return "ISO-8859-1";
    }

    public static String loadFile(String filename, String encoding) throws IOException {
        StringBuffer buffer = new StringBuffer();
        IoUtility.loadFile(filename, buffer, encoding);
        return buffer.toString();
    }

    public static void loadFile(String filename, StringBuffer buffer, String encoding) throws IOException {
        IoUtility.loadFile(new File(filename), buffer, encoding);
    }

    public static void loadStream(InputStream in, StringBuffer buffer) throws IOException {
        int c;
        buffer.setLength(0);
        while ((c = in.read()) >= 0) {
            buffer.append((char)c);
        }
    }

    public static void loadReader(Reader in, StringBuffer buffer) throws IOException {
        int c;
        buffer.setLength(0);
        while ((c = in.read()) >= 0) {
            buffer.append((char)c);
        }
    }

    public static void loadFile(File file, StringBuffer buffer) throws IOException {
        int size = (int)file.length();
        buffer.setLength(0);
        FileReader in = new FileReader(file);
        char[] data = new char[size];
        for (int charsread = 0; charsread < size; charsread += in.read(data, charsread, size - charsread)) {
        }
        in.close();
        buffer.insert(0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(File file, StringBuffer buffer, String encoding) throws IOException {
        buffer.setLength((int)file.length());
        buffer.setLength(0);
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        char[] data = new char[10240];
        try {
            int charsread = 0;
            while (0 < (charsread = in.read(data, 0, data.length))) {
                buffer.append(data, 0, charsread);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadFileBinary(File file) throws IOException {
        int size = (int)file.length();
        FileInputStream in = new FileInputStream(file);
        try {
            int read;
            byte[] data = new byte[size];
            for (int charsread = 0; charsread < size; charsread += read) {
                read = in.read(data, charsread, size - charsread);
                if (read != -1) continue;
                byte[] result = new byte[charsread];
                System.arraycopy(data, 0, result, 0, charsread);
                byte[] byArray = result;
                return byArray;
            }
            in.close();
            byte[] byArray = data;
            return byArray;
        }
        finally {
            IoUtility.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(URL url, StringBuffer buffer) throws IOException {
        InputStream in = null;
        BufferedReader dis = null;
        try {
            int i;
            in = url.openStream();
            dis = new BufferedReader(new InputStreamReader(in));
            while ((i = dis.read()) != -1) {
                buffer.append((char)i);
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(in);
            IoUtility.close(dis);
            throw throwable;
        }
        IoUtility.close(in);
        IoUtility.close(dis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFile(URL url, StringBuffer buffer, String encoding) throws IOException {
        InputStream in = null;
        BufferedReader dis = null;
        try {
            int i;
            in = url.openStream();
            dis = new BufferedReader(new InputStreamReader(in, encoding));
            while ((i = dis.read()) != -1) {
                buffer.append((char)i);
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(in);
            IoUtility.close(dis);
            throw throwable;
        }
        IoUtility.close(in);
        IoUtility.close(dis);
    }

    public static void saveFileBinary(URL url, File file) throws IOException {
        int length;
        InputStream in = url.openStream();
        FileOutputStream out = new FileOutputStream(file);
        byte[] data = new byte[8192];
        while ((length = in.read(data)) != -1) {
            out.write(data, 0, length);
        }
        in.close();
        out.close();
    }

    public static final Reader stringToReader(String data) {
        try {
            return new InputStreamReader(new ByteArrayInputStream(data.getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveFile(String filename, String text) throws IOException {
        IoUtility.saveFile(new File(filename), text);
    }

    public static void saveFile(String filename, StringBuffer text) throws IOException {
        IoUtility.saveFile(new File(filename), text.toString());
    }

    public static void saveFile(File file, StringBuffer text) throws IOException {
        IoUtility.saveFile(file, text.toString());
    }

    public static void saveFile(File file, String text) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        out.write(text);
        out.close();
    }

    public static void saveFile(File file, StringBuffer text, String encoding) throws IOException {
        IoUtility.saveFile(file, text.toString(), encoding);
    }

    public static void saveFile(File file, String text, String encoding) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
        out.write(text);
        out.close();
    }

    public static void saveFileBinary(File file, byte[] data) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        out.write(data);
        out.close();
    }

    public static void copyFile(File from, File to) throws IOException {
        int length;
        if (from.getCanonicalFile().equals(to.getCanonicalFile())) {
            return;
        }
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        byte[] data = new byte[8192];
        while ((length = in.read(data)) != -1) {
            out.write(data, 0, length);
        }
        in.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFilesBinary(File from, File with) throws IOException {
        boolean bl;
        if (from == null && with == null) {
            return true;
        }
        if (from == null || with == null) {
            return false;
        }
        if (from.getAbsoluteFile().equals(with.getAbsoluteFile())) {
            return true;
        }
        if (from.length() != with.length()) {
            return false;
        }
        byte[] dataOne = new byte[8192];
        byte[] dataTwo = new byte[8192];
        FileInputStream one = null;
        FileInputStream two = null;
        try {
            int length;
            one = new FileInputStream(from);
            two = new FileInputStream(with);
            while ((length = one.read(dataOne)) != -1) {
                if (length == two.read(dataTwo)) break block9;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            IoUtility.close(one);
            IoUtility.close(two);
            throw throwable;
        }
        {
            block9: {
                IoUtility.close(one);
                IoUtility.close(two);
                return bl;
            }
            if (Arrays.equals(dataOne, dataTwo)) continue;
            boolean bl2 = false;
            IoUtility.close(one);
            IoUtility.close(two);
            return bl2;
        }
        boolean bl3 = true;
        IoUtility.close(one);
        IoUtility.close(two);
        return bl3;
    }

    public static boolean deleteDir(File directory, boolean deleteDir) {
        File candir;
        try {
            candir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(directory.getAbsoluteFile())) {
            return false;
        }
        boolean success = true;
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                boolean deleted = file.delete();
                if (!deleted && file.isDirectory()) {
                    deleted = IoUtility.deleteDir(file, true);
                }
                success = success && deleted;
            }
        }
        if (deleteDir) {
            return directory.delete();
        }
        return success;
    }

    public static void printAllSystemProperties() {
        Properties sysprops = System.getProperties();
        Enumeration<?> e = sysprops.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = sysprops.getProperty(key);
            System.out.println(key + "=" + value);
        }
    }

    public static File getUserHomeDirectory() {
        return new File((String)System.getProperties().get("user.home"));
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createNecessaryDirectories(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    public static final String createRelativePath(File orgin, File next) {
        try {
            if (orgin.equals(next)) {
                return "";
            }
            try {
                String nex;
                String org = orgin.getCanonicalPath().replace('\\', '/');
                if (!org.endsWith("/")) {
                    org = org + '/';
                }
                if (!(nex = next.getCanonicalPath().replace('\\', '/')).endsWith("/")) {
                    nex = nex + '/';
                }
                if (org.equals(nex)) {
                    return "";
                }
                int i = -1;
                int j = 0;
                while (0 <= (i = org.indexOf("/", j)) && i >= 0 && nex.length() > i && org.substring(j, i).equals(nex.substring(j, i))) {
                    j = i + 1;
                }
                if (j > 0) {
                    i = j;
                    StringBuffer result = new StringBuffer(nex.length());
                    while (0 <= (i = org.indexOf("/", i))) {
                        ++i;
                        result.append("../");
                    }
                    result.append(nex.substring(j, nex.length() - 1));
                    return result.toString();
                }
                return nex.substring(0, nex.length() - 1);
            }
            catch (RuntimeException e) {
                return next.toString();
            }
        }
        catch (IOException e) {
            return new File(orgin, next.getPath()).getPath();
        }
    }

    public static void waitln() {
        System.out.println("\n..press <return> to continue");
        try {
            new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final File getStartDirectory(String application) {
        File startDirectory;
        if (IoUtility.isWebStarted()) {
            String userHome = System.getProperty("user.home", ".");
            startDirectory = new File(new File(userHome), "." + application);
        } else {
            startDirectory = new File(".");
        }
        return startDirectory;
    }

    public static final boolean isWebStarted() {
        String webStart = (String)System.getProperties().get("javawebstart.version");
        return webStart != null;
    }

    public static Properties loadProperties(URL url) throws IOException {
        Properties newprops = new Properties();
        InputStream in = url.openStream();
        newprops.load(in);
        in.close();
        return newprops;
    }

    public static Object getFieldContent(Object obj, String name) {
        Field field;
        try {
            field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldContentSuper(Object obj, String name) {
        Field field = null;
        try {
            Class<?> cl = obj.getClass();
            while (!(class$java$lang$Object == null ? IoUtility.class$("java.lang.Object") : class$java$lang$Object).equals(cl)) {
                try {
                    field = cl.getDeclaredField(name);
                    break;
                }
                catch (NoSuchFieldException ex) {
                    cl = cl.getSuperclass();
                    System.out.println(cl);
                }
            }
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldContent(Object obj, String name, Object value) {
        Field field;
        try {
            field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(int ms) {
        String monitor = "";
        String string = "";
        synchronized ("") {
            try {
                "".wait(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public static int[] getJavaVersion() {
        String version = System.getProperty("java.version");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        while (tokenizer.hasMoreElements()) {
            String sub = tokenizer.nextToken();
            for (int i = 0; i < sub.length(); ++i) {
                if (Character.isDigit(sub.charAt(i))) continue;
                sub = sub.substring(0, i);
                break;
            }
            try {
                numbers.add(new Integer(Integer.parseInt(sub)));
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        if (numbers.size() == 0) {
            return null;
        }
        int[] result = new int[numbers.size()];
        for (int i = 0; i < numbers.size(); ++i) {
            result[i] = (Integer)numbers.get(i);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

