/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.context;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.qedeq.kernel.bo.control.InternalKernelServices;
import org.qedeq.kernel.bo.control.KernelState;
import org.qedeq.kernel.bo.module.KernelProperties;
import org.qedeq.kernel.bo.module.KernelServices;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.QedeqBo;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.config.QedeqConfig;
import org.qedeq.kernel.log.QedeqLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;

public final class KernelContext
implements KernelProperties,
KernelState,
KernelServices {
    private static final Class CLASS = class$org$qedeq$kernel$context$KernelContext == null ? (class$org$qedeq$kernel$context$KernelContext = KernelContext.class$("org.qedeq.kernel.context.KernelContext")) : class$org$qedeq$kernel$context$KernelContext;
    private static final String KERNEL_VERSION = "0.03.10";
    private static final String KERNEL_VERSION_DIRECTORY = "0.03.10".replace('.', '_');
    private static final String DESCRIPTIVE_KERNEL_VERSION = "Hilbert II - Version 0.03.10 (mongaga)";
    private static final String MAXIMAL_RULE_VERSION = "1.00.00";
    private static final KernelContext INSTANCE = new KernelContext();
    private static File lockFile;
    private static FileOutputStream lockStream;
    private final KernelState initialState = new KernelState(){

        public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
            KernelContext.this.config = qedeqConfig;
            KernelContext.this.checkJavaVersion();
            KernelContext.this.createAllNecessaryDirectories();
            KernelContext.this.checkIfApplicationIsAlreadyRunning();
            KernelContext.this.services = moduleFactory;
            QedeqLog.getInstance().logMessage("This is " + KernelContext.getInstance().getDescriptiveKernelVersion());
            QedeqLog.getInstance().logMessage("  see \"http://www.qedeq.org\" for more information");
            QedeqLog.getInstance().logMessage("  supports rules till version " + KernelContext.getInstance().getMaximalRuleVersion());
            KernelContext.this.currentState = KernelContext.this.initializedState;
        }

        public boolean isReady() {
            return false;
        }

        public void shutdown() {
            KernelContext.this.currentState = KernelContext.this.initialState;
            if (lockStream == null) {
                return;
            }
            IoUtility.close(lockStream);
            if (lockFile != null) {
                lockFile.delete();
            }
        }

        public void startup() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void removeAllModules() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void removeModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo loadModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void loadRequiredModules(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress[] getAllLoadedModules() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress getModuleAddress(URL url) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress getModuleAddress(String url) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress getModuleAddress(File file) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String getSource(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public boolean checkModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String[] getSourceFileExceptionList(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }
    };
    private final KernelState initializedState = new KernelState(){

        public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public boolean isReady() {
            return false;
        }

        public void shutdown() {
            QedeqLog.getInstance().logMessage("QEDEQ Kernel closed.");
            KernelContext.this.services = null;
            KernelContext.this.initialState.shutdown();
        }

        public void startup() {
            KernelContext.this.services.startup();
            KernelContext.this.currentState = KernelContext.this.readyState;
            QedeqLog.getInstance().logMessage("QEDEQ kernel opened.");
        }

        public void removeAllModules() {
            throw new IllegalStateException("Kernel not started");
        }

        public void removeModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo loadModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException("Kernel not started");
        }

        public void loadRequiredModules(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress[] getAllLoadedModules() {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress getModuleAddress(URL url) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress getModuleAddress(String url) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress getModuleAddress(File file) {
            throw new IllegalStateException("Kernel not started");
        }

        public String getSource(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public boolean checkModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public String[] getSourceFileExceptionList(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }
    };
    private final KernelState readyState = new KernelState(){

        public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
        }

        public boolean isReady() {
            return false;
        }

        public void shutdown() {
            try {
                ModuleAddress[] addresses = KernelContext.this.services.getAllLoadedModules();
                String[] buffer = new String[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    buffer[i] = addresses[i].toString();
                }
                KernelContext.this.config.setLoadedModules(buffer);
                KernelContext.this.config.store();
                QedeqLog.getInstance().logMessage("Current config file successfully saved.");
            }
            catch (IOException e) {
                Trace.trace(CLASS, (Object)this, "shutdown()", (Throwable)e);
                QedeqLog.getInstance().logMessage("Saving current config file failed.");
            }
            KernelContext.this.initializedState.shutdown();
        }

        public void startup() {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public void removeAllModules() {
            KernelContext.this.services.removeAllModules();
        }

        public void removeModule(ModuleAddress address) {
            KernelContext.this.services.removeModule(address);
        }

        public void clearLocalBuffer() throws IOException {
            KernelContext.this.services.clearLocalBuffer();
        }

        public QedeqBo loadModule(ModuleAddress address) {
            return KernelContext.this.services.loadModule(address);
        }

        public boolean loadAllModulesFromQedeq() {
            return KernelContext.this.services.loadAllModulesFromQedeq();
        }

        public void loadRequiredModules(ModuleAddress address) throws SourceFileExceptionList {
            KernelContext.this.services.loadRequiredModules(address);
        }

        public ModuleAddress[] getAllLoadedModules() {
            return KernelContext.this.services.getAllLoadedModules();
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            return KernelContext.this.services.getQedeqBo(address);
        }

        public ModuleAddress getModuleAddress(URL url) throws IOException {
            return KernelContext.this.services.getModuleAddress(url);
        }

        public ModuleAddress getModuleAddress(String url) throws IOException {
            return KernelContext.this.services.getModuleAddress(url);
        }

        public ModuleAddress getModuleAddress(File file) throws IOException {
            return KernelContext.this.services.getModuleAddress(file);
        }

        public String getSource(ModuleAddress address) throws IOException {
            return KernelContext.this.services.getSource(address);
        }

        public boolean checkModule(ModuleAddress address) {
            return KernelContext.this.services.checkModule(address);
        }

        public String[] getSourceFileExceptionList(ModuleAddress address) {
            return KernelContext.this.services.getSourceFileExceptionList(address);
        }
    };
    private KernelState currentState = this.initialState;
    private QedeqConfig config;
    private InternalKernelServices services;
    static /* synthetic */ Class class$org$qedeq$kernel$context$KernelContext;

    private KernelContext() {
    }

    public static final KernelContext getInstance() {
        return INSTANCE;
    }

    public final String getKernelVersion() {
        return KERNEL_VERSION;
    }

    public final String getKernelVersionDirectory() {
        return KERNEL_VERSION_DIRECTORY;
    }

    public final String getDescriptiveKernelVersion() {
        return DESCRIPTIVE_KERNEL_VERSION;
    }

    public final String getMaximalRuleVersion() {
        return MAXIMAL_RULE_VERSION;
    }

    public final boolean isRuleVersionSupported(String ruleVersion) {
        return MAXIMAL_RULE_VERSION.equals(ruleVersion);
    }

    public QedeqConfig getConfig() {
        return this.config;
    }

    public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
        this.currentState.init(moduleFactory, qedeqConfig);
    }

    public boolean isReady() {
        return this.currentState.isReady();
    }

    public void shutdown() {
        this.currentState.shutdown();
    }

    public void startup() {
        this.currentState.startup();
    }

    public void removeAllModules() {
        this.currentState.removeAllModules();
    }

    public void removeModule(ModuleAddress address) {
        this.currentState.removeModule(address);
    }

    public void clearLocalBuffer() throws IOException {
        this.currentState.clearLocalBuffer();
    }

    public QedeqBo loadModule(ModuleAddress address) {
        return this.currentState.loadModule(address);
    }

    public boolean loadAllModulesFromQedeq() {
        return this.currentState.loadAllModulesFromQedeq();
    }

    public void loadRequiredModules(ModuleAddress address) throws SourceFileExceptionList {
        this.currentState.loadRequiredModules(address);
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.currentState.getAllLoadedModules();
    }

    public QedeqBo getQedeqBo(ModuleAddress address) {
        return this.currentState.getQedeqBo(address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return this.currentState.getModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return this.currentState.getModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return this.currentState.getModuleAddress(file);
    }

    public String getSource(ModuleAddress address) throws IOException {
        return this.currentState.getSource(address);
    }

    public boolean checkModule(ModuleAddress address) {
        return this.currentState.checkModule(address);
    }

    public String[] getSourceFileExceptionList(ModuleAddress address) {
        return this.currentState.getSourceFileExceptionList(address);
    }

    private void checkJavaVersion() throws IOException {
        int[] versions = IoUtility.getJavaVersion();
        if (versions == null) {
            Trace.fatal(CLASS, this, "checkJavaVersion", "running java version unknown", null);
            return;
        }
        StringBuffer version = new StringBuffer();
        for (int i = 0; i < versions.length; ++i) {
            if (i > 0) {
                version.append(".");
            }
            version.append(versions[i]);
        }
        Trace.paramInfo(CLASS, (Object)this, "checkJavaVersion", "version", version);
        if (versions.length < 1 || versions[0] < 1) {
            throw new IOException("This application requires at least Java 1.4.2 but we got " + version);
        }
        if (versions[0] == 1) {
            if (versions.length < 2 || versions[1] < 4) {
                throw new IOException("This application requires at least Java 1.4.2 but we got " + version);
            }
            if (versions[1] == 4 && (versions.length < 3 || versions[2] < 2)) {
                throw new IOException("This application requires at least Java 1.4.2 but we got " + version);
            }
        }
    }

    void createAllNecessaryDirectories() throws IOException {
        File logFile = new File(this.config.getBasisDirectory(), this.config.getLogFile());
        File logDir = logFile.getParentFile();
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new IOException("can't create directory: " + logDir.getAbsolutePath());
        }
        File bufferDir = this.config.getBufferDirectory();
        if (!bufferDir.exists() && !bufferDir.mkdirs()) {
            throw new IOException("can't create directory: " + bufferDir.getAbsolutePath());
        }
        File generationDir = this.config.getGenerationDirectory();
        if (!generationDir.exists() && !generationDir.mkdirs()) {
            throw new IOException("can't create directory: " + generationDir.getAbsolutePath());
        }
    }

    private void checkIfApplicationIsAlreadyRunning() throws IOException {
        lockFile = new File(this.config.getBufferDirectory(), "qedeq_lock.lck");
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            if (lockFile.exists() && !lockFile.delete()) {
                throw new IOException("It seems the application is already running.\nAt least the file \"" + lockFile.getAbsolutePath() + "\" couldn't be deleted.");
            }
        } else if (lockFile.exists()) {
            throw new IOException("It seems the application is already running or crashed.\nAt least the file \"" + lockFile.getAbsolutePath() + "\" must be manually deleted!");
        }
        try {
            lockStream = new FileOutputStream(lockFile);
            lockStream.write("LOCKED".getBytes());
            lockStream.flush();
        }
        catch (IOException e) {
            throw new IOException("It seems the application is already running.\nAt least locking the file \"" + lockFile.getAbsolutePath() + "\" failed.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

