/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.common;

import java.io.Serializable;
import java.net.URL;
import org.qedeq.kernel.common.SourcePosition;

public final class SourceArea
implements Serializable {
    private final URL address;
    private final SourcePosition startPosition;
    private final SourcePosition endPosition;

    public SourceArea(URL address, SourcePosition startPosition, SourcePosition endPosition) {
        this.address = address;
        if (startPosition == null || endPosition == null) {
            throw new NullPointerException();
        }
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public final URL getAddress() {
        return this.address;
    }

    public final SourcePosition getStartPosition() {
        return this.startPosition;
    }

    public final SourcePosition getEndPosition() {
        return this.endPosition;
    }

    public final String toString() {
        return this.getAddress() + (this.getStartPosition() != null ? ":" + this.getStartPosition().getLine() + ":" + this.getStartPosition().getColumn() : "") + (this.getEndPosition() != null ? ":" + this.getEndPosition().getLine() + ":" + this.getEndPosition().getColumn() : "");
    }
}

