/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import org.qedeq.kernel.bo.control.ClassOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.control.IdentityOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.control.KernelQedeqBo;
import org.qedeq.kernel.bo.logic.DefaultExistenceChecker;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.ModuleReferenceList;

public class ModuleConstantsExistenceChecker
extends DefaultExistenceChecker {
    private final KernelQedeqBo prop;

    public ModuleConstantsExistenceChecker(KernelQedeqBo prop) throws ModuleDataException {
        this.prop = prop;
        this.init();
    }

    public void init() throws ModuleDataException {
        this.clear();
        boolean identityOperatorExists = false;
        boolean classOperatorExists = false;
        ModuleReferenceList list = this.prop.getRequiredModules();
        String identityOperator = null;
        for (int i = 0; i < list.size(); ++i) {
            KernelQedeqBo bo = (KernelQedeqBo)list.getQedeqBo(i);
            if (bo.getExistenceChecker().equalityOperatorExists()) {
                if (identityOperatorExists) {
                    throw new IdentityOperatorAlreadyExistsException(123476, "identity operator already defined", list.getModuleContext(i));
                }
                identityOperatorExists = true;
                identityOperator = list.getLabel(i) + "." + bo.getExistenceChecker().getIdentityOperator();
            }
            if (!bo.getExistenceChecker().classOperatorExists()) continue;
            if (classOperatorExists) {
                throw new ClassOperatorAlreadyExistsException(123478, "class operator already defined", list.getModuleContext(i));
            }
            classOperatorExists = true;
        }
        this.setIdentityOperatorDefined(identityOperatorExists, identityOperator);
        this.setClassOperatorExists(classOperatorExists);
    }

    public boolean predicateExists(String name, int arguments) {
        int external = name.indexOf(".");
        if (external < 0) {
            return super.predicateExists(name, arguments);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().predicateExists(shortName, arguments);
    }

    public boolean functionExists(String name, int arguments) {
        int external = name.indexOf(".");
        if (external < 0) {
            return super.functionExists(name, arguments);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        KernelQedeqBo newProp = (KernelQedeqBo)ref.getQedeqBo(label);
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().functionExists(shortName, arguments);
    }
}

