/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.bo.control.DefaultModuleAddress;
import org.qedeq.kernel.bo.control.InternalKernelServices;
import org.qedeq.kernel.bo.control.KernelQedeqBo;
import org.qedeq.kernel.bo.control.KernelQedeqBoPool;
import org.qedeq.kernel.bo.control.LoadRequiredModules;
import org.qedeq.kernel.bo.control.ModuleFileNotFoundException;
import org.qedeq.kernel.bo.control.ModuleLabelsCreator;
import org.qedeq.kernel.bo.control.ModuleLoader;
import org.qedeq.kernel.bo.control.QedeqBoFormalLogicChecker;
import org.qedeq.kernel.bo.load.QedeqVoBuilder;
import org.qedeq.kernel.bo.module.KernelProperties;
import org.qedeq.kernel.bo.module.KernelServices;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.DependencyState;
import org.qedeq.kernel.common.LoadingState;
import org.qedeq.kernel.common.LogicalState;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.QedeqBo;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.module.QedeqVo;
import org.qedeq.kernel.log.QedeqLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.StringUtility;
import org.qedeq.kernel.utility.TextInput;

public class DefaultInternalKernelServices
implements KernelServices,
InternalKernelServices {
    private static final Class CLASS = class$org$qedeq$kernel$bo$control$DefaultInternalKernelServices == null ? (class$org$qedeq$kernel$bo$control$DefaultInternalKernelServices = DefaultInternalKernelServices.class$("org.qedeq.kernel.bo.control.DefaultInternalKernelServices")) : class$org$qedeq$kernel$bo$control$DefaultInternalKernelServices;
    private final String monitor = "";
    private final String syncToken = "";
    private volatile int processCounter = 0;
    private final KernelQedeqBoPool modules = new KernelQedeqBoPool();
    private final KernelProperties kernel;
    private final ModuleLoader loader;
    private boolean validate = true;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$DefaultInternalKernelServices;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$DefaultModuleAddress;

    public DefaultInternalKernelServices(KernelProperties kernel, ModuleLoader loader) {
        this.kernel = kernel;
        this.loader = loader;
        loader.setServices(this);
    }

    public void startup() {
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            this.autoReloadLastSessionChecked();
        }
    }

    public void autoReloadLastSessionChecked() {
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String method = "autoReloadLastSessionChecked.thread.run()";
                    try {
                        Trace.begin(CLASS, this, "autoReloadLastSessionChecked.thread.run()");
                        QedeqLog.getInstance().logMessage("Trying to load previously successfully loaded modules.");
                        int number = DefaultInternalKernelServices.this.kernel.getConfig().getPreviouslyCheckedModules().length;
                        if (DefaultInternalKernelServices.this.loadPreviouslySuccessfullyLoadedModules()) {
                            QedeqLog.getInstance().logMessage("Loading of " + number + " previously successfully loaded module" + (number != 1 ? "s" : "") + " successfully done.");
                        } else {
                            QedeqLog.getInstance().logMessage("Loading of all previously successfully checked modules failed. " + number + " module" + (number != 1 ? "s" : "") + " were tried.");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(CLASS, (Object)this, "autoReloadLastSessionChecked.thread.run()", (Throwable)e);
                    }
                    finally {
                        Trace.end(CLASS, this, "autoReloadLastSessionChecked.thread.run()");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeAllModules() {
        while (true) {
            String string = "";
            // MONITORENTER : ""
            if (this.processCounter == 0) {
                this.getModules().removeAllModules();
                // MONITOREXIT : string
                return;
            }
            // MONITOREXIT : string
            string = "";
            // MONITORENTER : ""
            try {
                "".wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void removeModule(ModuleAddress address) {
        QedeqBo prop = this.getQedeqBo(address);
        if (prop != null) {
            this.removeModule(this.getKernelQedeqBo(address));
            if (this.validate) {
                this.modules.validateDependencies();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeModule(KernelQedeqBo prop) {
        while (true) {
            String string = "";
            // MONITORENTER : ""
            if (this.processCounter == 0) {
                prop.delete();
                this.getModules().removeModule(prop);
                // MONITOREXIT : string
                return;
            }
            // MONITOREXIT : string
            string = "";
            // MONITORENTER : ""
            try {
                this.getClass();
                "".wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void clearLocalBuffer() throws IOException {
        this.removeAllModules();
        File bufferDir = this.getBufferDirectory().getCanonicalFile();
        if (bufferDir.exists() && !IoUtility.deleteDir(bufferDir, false)) {
            throw new IOException("buffer could not be deleted: " + bufferDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QedeqBo loadModule(ModuleAddress address) {
        String method = "loadModule(ModuleAddress)";
        this.processInc();
        KernelQedeqBo prop = this.getModules().getKernelQedeqBo(address);
        try {
            KernelQedeqBo kernelQedeqBo = prop;
            synchronized (kernelQedeqBo) {
                block16: {
                    if (!prop.isLoaded()) break block16;
                    KernelQedeqBo kernelQedeqBo2 = prop;
                    return kernelQedeqBo2;
                }
                QedeqLog.getInstance().logRequest("Load module \"" + address + "\"");
                if (prop.getModuleAddress().isFileAddress()) {
                    this.loadLocalModule(prop);
                } else {
                    try {
                        this.getCanonicalReadableFile(prop);
                    }
                    catch (ModuleFileNotFoundException e) {
                        this.makeLocalCopy(prop);
                    }
                    this.loadBufferedModule(prop);
                }
                QedeqLog.getInstance().logSuccessfulReply("Module \"" + prop.getModuleAddress().getFileName() + "\" was successfully loaded.");
            }
        }
        catch (SourceFileExceptionList e) {
            Trace.trace(CLASS, (Object)this, "loadModule(ModuleAddress)", (Throwable)e);
            QedeqLog.getInstance().logFailureState("Loading of module failed!", address.getURL(), e.toString());
        }
        catch (RuntimeException e) {
            Trace.fatal(CLASS, this, "loadModule(ModuleAddress)", "unexpected problem", e);
            QedeqLog.getInstance().logFailureReply("Loading failed", e.getMessage());
        }
        finally {
            this.processDec();
        }
        return prop;
    }

    private void loadBufferedModule(KernelQedeqBo prop) throws SourceFileExceptionList {
        Qedeq qedeq;
        File localFile;
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_BUFFER);
        try {
            localFile = this.getCanonicalReadableFile(prop);
        }
        catch (ModuleFileNotFoundException e) {
            SourceFileExceptionList sfl = this.createSourcelFileExceptionList(e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, sfl);
            throw sfl;
        }
        prop.setLoader(this.loader);
        try {
            qedeq = this.loader.loadLocalModule(prop, localFile);
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, sfl);
            throw sfl;
        }
        this.setCopiedQedeq(prop, qedeq);
    }

    private void loadLocalModule(KernelQedeqBo prop) throws SourceFileExceptionList {
        Qedeq qedeq;
        File localFile;
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE);
        try {
            localFile = this.getCanonicalReadableFile(prop);
        }
        catch (ModuleFileNotFoundException e) {
            SourceFileExceptionList sfl = this.createSourcelFileExceptionList(e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED, sfl);
            throw sfl;
        }
        prop.setLoader(this.loader);
        try {
            qedeq = this.loader.loadLocalModule(prop, localFile);
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_LOCAL_FILE_FAILED, sfl);
            throw sfl;
        }
        this.setCopiedQedeq(prop, qedeq);
    }

    private void setCopiedQedeq(KernelQedeqBo prop, Qedeq qedeq) throws SourceFileExceptionList {
        String method = "setCopiedQedeq(KernelQedeqBo, Qedeq)";
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_INTO_MEMORY);
        QedeqVo vo = null;
        try {
            vo = QedeqVoBuilder.createQedeq(prop.getModuleAddress(), qedeq);
        }
        catch (ModuleDataException e) {
            Trace.trace(CLASS, (Object)this, "setCopiedQedeq(KernelQedeqBo, Qedeq)", (Throwable)e);
            SourceFileExceptionList xl = prop.createSourceFileExceptionList(e, qedeq);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
            throw xl;
        }
        prop.setQedeqVo(vo);
        ModuleLabelsCreator moduleNodesCreator = new ModuleLabelsCreator(prop);
        try {
            prop.setLoaded(vo, moduleNodesCreator.createLabels());
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, sfl);
            throw sfl;
        }
    }

    private File getCanonicalReadableFile(QedeqBo prop) throws ModuleFileNotFoundException {
        File file;
        String method = "checkLocalBuffer(File)";
        File localFile = this.getLocalFilePath(prop.getModuleAddress());
        try {
            file = localFile.getCanonicalFile();
        }
        catch (IOException e) {
            Trace.trace(CLASS, (Object)this, "checkLocalBuffer(File)", (Throwable)e);
            throw new ModuleFileNotFoundException("file path not correct: " + localFile);
        }
        if (!file.canRead()) {
            Trace.trace(CLASS, (Object)this, "checkLocalBuffer(File)", "file not readable=" + file);
            throw new ModuleFileNotFoundException("file not readable: " + file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KernelQedeqBo loadModule(ModuleAddress parent, Specification spec) throws SourceFileExceptionList {
        method = "loadModule(Module, Specification)";
        Trace.begin(DefaultInternalKernelServices.CLASS, this, "loadModule(Module, Specification)");
        Trace.trace(DefaultInternalKernelServices.CLASS, (Object)this, "loadModule(Module, Specification)", spec);
        this.processInc();
        prop = null;
        try {
            modulePaths = DefaultModuleAddress.getModulePaths(parent, spec);
        }
        catch (IOException e) {
            Trace.trace(DefaultInternalKernelServices.CLASS, (Object)this, "loadModule(Module, Specification)", (Throwable)e);
            throw this.createSourceFileExceptionList(e);
        }
        i = 0;
lbl14:
        // 2 sources

        while (i < modulePaths.length) {
            prop = this.getModules().getKernelQedeqBo(modulePaths[i]);
            Trace.trace(DefaultInternalKernelServices.CLASS, (Object)this, "loadModule(Module, Specification)", "synchronizing at prop=" + prop);
            var7_9 = prop;
            synchronized (var7_9) {
                if (!prop.isLoaded()) ** GOTO lbl-1000
                var8_11 = prop;
            }
            this.processDec();
            ** GOTO lbl28
        }
        ** GOTO lbl-1000
        {
            catch (Throwable var10_14) {
                this.processDec();
                Trace.end(DefaultInternalKernelServices.CLASS, this, "loadModule(Module, Specification)");
                throw var10_14;
            }
lbl28:
            // 1 sources

            Trace.end(DefaultInternalKernelServices.CLASS, this, "loadModule(Module, Specification)");
            return var8_11;
lbl-1000:
            // 1 sources

            {
                try {
                    if (prop.getModuleAddress().isFileAddress()) {
                        this.loadLocalModule(prop);
                    } else {
                        try {
                            this.getCanonicalReadableFile(prop);
                        }
                        catch (ModuleFileNotFoundException e) {
                            this.makeLocalCopy(prop);
                        }
                        this.loadBufferedModule(prop);
                    }
                    e = prop;
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 10] lbl43 : MonitorExitStatement: MONITOREXIT : var7_9
                    this.processDec();
                }
                catch (SourceFileExceptionList e) {}
                {
                    Trace.trace(DefaultInternalKernelServices.CLASS, (Object)this, "loadModule(Module, Specification)", (Throwable)e);
                    if (i + 1 >= modulePaths.length) {
                        throw e;
                    }
                    QedeqLog.getInstance().logMessage("trying alternate path");
                    // MONITOREXIT @DISABLED, blocks:[5, 7, 10] lbl52 : MonitorExitStatement: MONITOREXIT : var7_9
                    ++i;
                    ** GOTO lbl14
                }
                Trace.end(DefaultInternalKernelServices.CLASS, this, "loadModule(Module, Specification)");
                return e;
            }
        }
lbl-1000:
        // 1 sources

        {
            var6_8 = prop;
            this.processDec();
        }
        Trace.end(DefaultInternalKernelServices.CLASS, this, "loadModule(Module, Specification)");
        return var6_8;
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.getModules().getAllLoadedModules();
    }

    public void loadRequiredModules(ModuleAddress address) throws SourceFileExceptionList {
        KernelQedeqBo prop = (KernelQedeqBo)this.loadModule(address);
        LoadRequiredModules.loadRequired(prop, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPreviouslySuccessfullyLoadedModules() {
        this.processInc();
        try {
            String[] list = this.kernel.getConfig().getPreviouslyCheckedModules();
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    QedeqBo prop = this.loadModule(address);
                    if (!prop.hasFailures()) continue;
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAllModulesFromQedeq() {
        this.processInc();
        try {
            String prefix = "http://qedeq.org/" + this.kernel.getKernelVersionDirectory() + "/";
            String[] list = new String[]{prefix + "doc/math/qedeq_logic_v1.xml", prefix + "doc/math/qedeq_set_theory_v1.xml", prefix + "doc/project/qedeq_basic_concept.xml", prefix + "doc/project/qedeq_logic_language.xml", prefix + "sample/qedeq_sample1.xml", prefix + "sample/qedeq_error_sample_00.xml", prefix + "sample/qedeq_error_sample_01.xml", prefix + "sample/qedeq_error_sample_02.xml", prefix + "sample/qedeq_error_sample_03.xml", prefix + "sample/qedeq_error_sample_04.xml", prefix + "sample/qedeq_sample2_error.xml", prefix + "sample/qedeq_sample3_error.xml", prefix + "sample/qedeq_sample4_error.xml", prefix + "sample/qedeq_sample5_error.xml", prefix + "sample/qedeq_sample6_error.xml", prefix + "sample/qedeq_sample7_error.xml"};
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    QedeqBo prop = this.loadModule(address);
                    if (!prop.hasFailures()) continue;
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * Loose catch block
     */
    private synchronized void makeLocalCopy(KernelQedeqBo prop) throws SourceFileExceptionList {
        block20: {
            int bytesRead;
            String method = "makeLocalCopy";
            Trace.begin(CLASS, this, "makeLocalCopy");
            if (prop.getModuleAddress().isFileAddress()) {
                Trace.fatal(CLASS, this, "makeLocalCopy", "tried to make a local copy for a local module", null);
                Trace.end(CLASS, this, "makeLocalCopy");
                return;
            }
            prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
            FileOutputStream out = null;
            InputStream in = null;
            File f = this.getLocalFilePath(prop.getModuleAddress());
            URLConnection connection = prop.getUrl().openConnection();
            in = connection.getInputStream();
            int maximum = connection.getContentLength();
            if (!prop.getUrl().equals(connection.getURL())) {
                throw new FileNotFoundException("\"" + prop.getUrl() + "\" was substituted by " + "\"" + connection.getURL() + "\" from server");
            }
            IoUtility.createNecessaryDirectories(f);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[4096];
            int position = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                int completeness = (position += bytesRead) * 100 / maximum;
                if (completeness < 0) {
                    completeness = 0;
                }
                if (completeness > 100) {
                    completeness = 100;
                }
                prop.setLoadingCompleteness(completeness);
            }
            prop.setLoadingCompleteness(100);
            Object var13_16 = null;
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                in.close();
                break block20;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                break block20;
                catch (IOException e) {
                    Trace.trace(CLASS, (Object)this, "makeLocalCopy", (Throwable)e);
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        f.delete();
                    }
                    catch (Exception ex) {
                        Trace.trace(CLASS, (Object)this, "makeLocalCopy", (Throwable)ex);
                    }
                    DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList(e);
                    prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_WEB_FAILED, sfl);
                    Trace.trace(CLASS, (Object)this, "makeLocalCopy", "Couldn't access " + prop.getUrl());
                    throw sfl;
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Trace.end(CLASS, this, "makeLocalCopy");
                throw throwable;
            }
        }
        Trace.end(CLASS, this, "makeLocalCopy");
    }

    public final File getLocalFilePath(ModuleAddress address) {
        String method = "localizeInFileSystem(URL)";
        if (address.isFileAddress()) {
            return new File(address.getURL().getFile());
        }
        URL url = address.getURL();
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "protocol", url.getProtocol());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "host", url.getHost());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "port", url.getPort());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "path", url.getPath());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "file", url.getFile());
        StringBuffer file = new StringBuffer(url.getFile());
        StringUtility.replace(file, "_", "_1");
        StringUtility.replace(file, "/", "_2");
        String encoded = file.toString();
        try {
            encoded = URLEncoder.encode(file.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(class$org$qedeq$kernel$bo$control$DefaultModuleAddress == null ? (class$org$qedeq$kernel$bo$control$DefaultModuleAddress = DefaultInternalKernelServices.class$("org.qedeq.kernel.bo.control.DefaultModuleAddress")) : class$org$qedeq$kernel$bo$control$DefaultModuleAddress, "localizeInFileSystem(String)", e);
        }
        file.setLength(0);
        file.append(encoded);
        StringUtility.replace(file, "#", "##");
        StringUtility.replace(file, "_2", "#");
        StringUtility.replace(file, "_1", "_");
        StringBuffer adr = new StringBuffer(url.toExternalForm());
        try {
            adr = new StringBuffer(new URL(url.getProtocol(), url.getHost(), url.getPort(), file.toString()).toExternalForm());
        }
        catch (MalformedURLException e) {
            Trace.fatal(CLASS, this, "localizeInFileSystem(URL)", "unexpected", e);
            e.printStackTrace();
        }
        StringUtility.replace(adr, "://", "_");
        StringUtility.replace(adr, ":", "_");
        return new File(this.getBufferDirectory(), adr.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInc() {
        String string = "";
        synchronized ("") {
            ++this.processCounter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDec() {
        String string = "";
        synchronized ("") {
            --this.processCounter;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public File getBufferDirectory() {
        return this.kernel.getConfig().getBufferDirectory();
    }

    public File getGenerationDirectory() {
        return this.kernel.getConfig().getGenerationDirectory();
    }

    public KernelQedeqBo getKernelQedeqBo(ModuleAddress address) {
        return this.getModules().getKernelQedeqBo(address);
    }

    public QedeqBo getQedeqBo(ModuleAddress address) {
        return this.getModules().getKernelQedeqBo(address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return new DefaultModuleAddress(file);
    }

    public String getSource(ModuleAddress address) throws IOException {
        KernelQedeqBo bo = this.getKernelQedeqBo(address);
        if (bo.getLoadingState().equals(LoadingState.STATE_UNDEFINED) || bo.getLoadingState().equals(LoadingState.STATE_LOADING_FROM_WEB) || bo.getLoadingState().equals(LoadingState.STATE_LOADING_FROM_WEB_FAILED)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        IoUtility.loadReader(this.loader.getModuleReader(bo), buffer);
        return buffer.toString();
    }

    public boolean checkModule(ModuleAddress address) {
        String method = "checkModule(ModuleAddress)";
        KernelQedeqBo prop = this.getKernelQedeqBo(address);
        try {
            QedeqLog.getInstance().logRequest("Check logical correctness for \"" + prop.getUrl() + "\"");
            this.loadModule(address);
            LoadRequiredModules.loadRequired(prop, this);
            QedeqBoFormalLogicChecker.check(prop);
            QedeqLog.getInstance().logSuccessfulReply("Check of logical correctness successful for \"" + prop.getUrl() + "\"");
        }
        catch (SourceFileExceptionList e) {
            String msg = "Check of logical correctness failed for \"" + address.getURL() + "\"";
            QedeqLog.getInstance().logFailureReply(msg, e.getMessage());
        }
        catch (RuntimeException e) {
            String msg = "Check of logical correctness failed for \"" + address.getURL() + "\"";
            Trace.fatal(CLASS, this, "checkModule(ModuleAddress)", msg, e);
            DefaultSourceFileExceptionList xl = new DefaultSourceFileExceptionList(e);
            if (!prop.isLoaded()) {
                if (!prop.getLoadingState().isFailure()) {
                    prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
                }
            } else if (!prop.hasLoadedRequiredModules()) {
                if (!prop.getDependencyState().isFailure()) {
                    prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, xl);
                }
            } else if (!prop.getLogicalState().isFailure()) {
                prop.setLogicalFailureState(LogicalState.STATE_EXTERNAL_CHECKING_FAILED, xl);
            }
            QedeqLog.getInstance().logFailureReply(msg, e.toString());
        }
        if (this.validate) {
            this.modules.validateDependencies();
        }
        return prop.isChecked();
    }

    private KernelQedeqBoPool getModules() {
        return this.modules;
    }

    private SourceFileExceptionList createSourceFileExceptionList(IOException e) {
        return new DefaultSourceFileExceptionList(e);
    }

    private SourceFileExceptionList createSourcelFileExceptionList(ModuleFileNotFoundException e) {
        return new DefaultSourceFileExceptionList(new IOException(e.getMessage()));
    }

    public String[] getSourceFileExceptionList(ModuleAddress address) {
        ArrayList<String> list;
        block8: {
            list = new ArrayList<String>();
            KernelQedeqBo bo = this.getKernelQedeqBo(address);
            SourceFileExceptionList sfl = bo.getException();
            if (sfl != null) {
                StringBuffer buffer = new StringBuffer();
                try {
                    IoUtility.loadReader(this.loader.getModuleReader(bo), buffer);
                }
                catch (IOException e) {
                    for (int i = 0; i < sfl.size(); ++i) {
                        list.add(sfl.get(i).getDescription());
                    }
                    break block8;
                }
                TextInput input = new TextInput(buffer);
                input.setPosition(0);
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < sfl.size(); ++i) {
                    buf.setLength(0);
                    SourceFileException sf = sfl.get(i);
                    buf.append(sf.getDescription());
                    try {
                        if (sf.getSourceArea() != null && sf.getSourceArea().getStartPosition() != null) {
                            buf.append("\n");
                            input.setRow(sf.getSourceArea().getStartPosition().getLine());
                            buf.append(StringUtility.replace(input.getLine(), "\t", " "));
                            buf.append("\n");
                            StringBuffer whitespace = StringUtility.getSpaces(sf.getSourceArea().getStartPosition().getColumn() - 1);
                            buffer.append(whitespace);
                            buffer.append("^");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(CLASS, (Object)this, "getSourceFileExceptionList(ModuleAddress)", (Throwable)e);
                    }
                    list.add(buf.toString());
                }
            }
        }
        return list.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

