/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class TextOutput {
    private final PrintStream output;
    private final String name;
    private StringBuffer spaces = new StringBuffer();

    public TextOutput(String name, OutputStream output) {
        this.name = name;
        try {
            this.output = new PrintStream(output, false, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void print(String text) {
        this.output.print(text);
    }

    public void levelPrint(String text) {
        this.output.print(this.spaces);
        this.output.print(text);
    }

    public void print(Object object) {
        this.output.print(object);
    }

    public final void println(String line) {
        this.output.println(line);
    }

    public final void levelPrintln(String line) {
        this.output.print(this.spaces);
        this.output.println(line);
    }

    public final void println(Object object) {
        this.output.println(object);
    }

    public final void println() {
        this.output.println();
    }

    public final void flush() {
        this.output.flush();
    }

    public final void close() {
        this.output.close();
    }

    public final void clearLevel() {
        this.spaces.setLength(0);
    }

    public final void popLevel() {
        if (this.spaces.length() > 0) {
            this.spaces.setLength(this.spaces.length() - 2);
        }
    }

    public final void pushLevel() {
        this.spaces.append("  ");
    }

    public final boolean checkError() {
        return this.output.checkError();
    }

    public final String getName() {
        return this.name;
    }

    public final IOException getError() {
        if (this.checkError()) {
            return new IOException("Writing failed.");
        }
        return null;
    }
}

