/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.parser;

import java.util.ArrayList;
import java.util.List;
import org.qedeq.kernel.parser.MathParser;
import org.qedeq.kernel.parser.MementoTextInput;
import org.qedeq.kernel.parser.Operator;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.TextInput;

public class LatexMathParser
extends MathParser {
    private static final Class CLASS = class$org$qedeq$kernel$parser$LatexMathParser == null ? (class$org$qedeq$kernel$parser$LatexMathParser = LatexMathParser.class$("org.qedeq.kernel.parser.LatexMathParser")) : class$org$qedeq$kernel$parser$LatexMathParser;
    private static final String SPECIALCHARACTERS = "(),{}\\~%$&";
    private int tokenWhiteSpaceLines;
    static /* synthetic */ Class class$org$qedeq$kernel$parser$LatexMathParser;

    public LatexMathParser(TextInput input, List operators) {
        super(new MementoTextInput(input), operators);
    }

    public LatexMathParser(StringBuffer buffer, List operators) {
        this(new TextInput(buffer), operators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String readToken() {
        String method = "readToken()";
        Trace.begin(CLASS, this, "readToken()");
        StringBuffer token = new StringBuffer();
        this.tokenWhiteSpaceLines = 0;
        try {
            block9: do {
                this.tokenWhiteSpaceLines += this.readPureWhitespace();
                if (this.tokenWhiteSpaceLines > 1) break;
                if (this.eof()) {
                    if (token.length() > 0) break;
                    token = null;
                    break;
                }
                int c = this.getChar();
                if (Character.isDigit((char)c)) {
                    token.append((char)this.readChar());
                    if (!Character.isDigit((char)this.getChar())) break;
                    continue;
                }
                if (SPECIALCHARACTERS.indexOf(c) >= 0) {
                    switch (c) {
                        case 36: 
                        case 37: 
                        case 38: 
                        case 126: {
                            this.readChar();
                            break;
                        }
                        case 92: {
                            String t = this.readBackslashToken();
                            if (t.equals(" ") || t.equals("quad")) continue block9;
                            if (t.equals("qquad")) break;
                            token.append(t);
                            if (95 != this.getChar() && 94 != this.getChar()) break block9;
                            token.append((char)this.readChar());
                            break;
                        }
                        case 123: {
                            this.readChar();
                            token.append("(");
                            break block9;
                        }
                        case 125: {
                            this.readChar();
                            token.append(")");
                            break block9;
                        }
                        default: {
                            this.readChar();
                            token.append((char)c);
                            if (95 != this.getChar() && 94 != this.getChar()) break block9;
                            token.append((char)this.readChar());
                            break;
                        }
                    }
                    continue;
                }
                token.append((char)this.readChar());
                if (95 != this.getChar() && 94 != this.getChar()) break;
                token.append((char)this.readChar());
            } while (!this.eof());
            Trace.param(CLASS, (Object)this, "readToken()", "return token", token);
            String string = token != null ? token.toString() : null;
            return string;
        }
        finally {
            Trace.end(CLASS, this, "readToken()");
        }
    }

    private String readBackslashToken() {
        String method = "readBackslashToken()";
        Trace.begin(CLASS, this, "readBackslashToken()");
        if (this.getChar() != 92) {
            throw new IllegalArgumentException("\\ expected");
        }
        this.readChar();
        if (this.eof()) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", null);
            Trace.end(CLASS, this, "readBackslashToken()");
            return null;
        }
        if (!Character.isLetter((char)this.getChar())) {
            Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", (char)this.getChar());
            Trace.end(CLASS, this, "readBackslashToken()");
            return "" + (char)this.readChar();
        }
        StringBuffer buffer = new StringBuffer();
        do {
            buffer.append((char)this.readChar());
        } while (!this.eof() && Character.isLetter((char)this.getChar()));
        Trace.param(CLASS, (Object)this, "readBackslashToken()", "return", buffer.toString());
        Trace.end(CLASS, this, "readBackslashToken()");
        return buffer.toString();
    }

    private int readPureWhitespace() {
        int lines = 0;
        while (this.getChar() != -1 && Character.isWhitespace((char)this.getChar())) {
            if ('\n' == (char)this.getChar()) {
                ++lines;
            }
            this.readChar();
        }
        return lines;
    }

    protected final Operator getOperator(String token) {
        Operator result = null;
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result = (Operator)this.getOperators().get(i);
            break;
        }
        return result;
    }

    protected final List getOperators(String token) {
        ArrayList result = new ArrayList();
        if (token == null) {
            return result;
        }
        for (int i = 0; i < this.getOperators().size(); ++i) {
            if (!token.equals(((Operator)this.getOperators().get(i)).getStartSymbol())) continue;
            result.add(this.getOperators().get(i));
        }
        return result;
    }

    protected boolean eot(String token) {
        return token == null || token.trim().length() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

