/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.latex;

import java.util.HashMap;
import java.util.Map;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.bo.control.KernelQedeqBo;
import org.qedeq.kernel.bo.logic.DefaultExistenceChecker;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.common.ModuleReferenceList;
import org.qedeq.kernel.dto.module.PredicateDefinitionVo;
import org.qedeq.kernel.utility.StringUtility;

public final class Element2Latex
extends AbstractModuleVisitor {
    private final ModuleReferenceList references;
    private final Map predicateDefinitions = new HashMap();
    private final Map functionDefinitions = new HashMap();
    private final Map elementList2ListType = new HashMap();
    private final ListType unknown = new Unknown();

    public Element2Latex(ModuleReferenceList references) {
        this.references = references;
        this.elementList2ListType.put("PREDVAR", new Predvar());
        this.elementList2ListType.put("FUNVAR", new Funvar());
        this.elementList2ListType.put("PREDCON", new Predcon());
        this.elementList2ListType.put("FUNCON", new Funcon());
        this.elementList2ListType.put("VAR", new Var());
        this.elementList2ListType.put("AND", new BinaryLogical("\\land"));
        this.elementList2ListType.put("OR", new BinaryLogical("\\lor"));
        this.elementList2ListType.put("IMPL", new BinaryLogical("\\rightarrow"));
        this.elementList2ListType.put("EQUI", new BinaryLogical("\\leftrightarrow"));
        this.elementList2ListType.put("FORALL", new Quantifier("\\forall"));
        this.elementList2ListType.put("EXISTS", new Quantifier("\\exists"));
        this.elementList2ListType.put("EXISTSU", new Quantifier("\\exists!"));
        this.elementList2ListType.put("NOT", new Not());
        this.elementList2ListType.put("CLASS", new Class());
        this.elementList2ListType.put("CLASSLIST", new Classlist());
        this.elementList2ListType.put("QUANTOR_INTERSECTION", new QuantorIntersection());
        this.elementList2ListType.put("QUANTOR_UNION", new QuantorUnion());
        String nameEqual = "equal";
        String argNumberEqual = "2";
        String keyEqual = "equal_2";
        if (!this.getPredicateDefinitions().containsKey("equal_2")) {
            PredicateDefinitionVo equal = new PredicateDefinitionVo();
            equal.setArgumentNumber("2");
            equal.setName("equal");
            equal.setLatexPattern("#1 \\ =  \\ #2");
            this.getPredicateDefinitions().put("equal_2", equal);
        }
        String nameNotEqual = "notEqual";
        String argNumberNotEqual = "2";
        String keyNotEqual = "notEqual_2";
        if (!this.getPredicateDefinitions().containsKey("notEqual_2")) {
            PredicateDefinitionVo notEqual = new PredicateDefinitionVo();
            notEqual.setArgumentNumber("2");
            notEqual.setName("notEqual");
            notEqual.setLatexPattern("#1 \\ \\neq  \\ #2");
            this.getPredicateDefinitions().put("notEqual_2", notEqual);
        }
    }

    public void addPredicate(PredicateDefinition definition) {
        this.getPredicateDefinitions().put(definition.getName() + "_" + definition.getArgumentNumber(), definition);
    }

    public void addFunction(FunctionDefinition definition) {
        this.getFunctionDefinitions().put(definition.getName() + "_" + definition.getArgumentNumber(), definition);
    }

    public String getLatex(Element element) {
        return this.getLatex(element, true);
    }

    String getLatex(Element element, boolean first) {
        if (element.isAtom()) {
            return element.getAtom().getString();
        }
        ElementList list = element.getList();
        ListType converter = (ListType)this.elementList2ListType.get(list.getOperator());
        if (converter == null) {
            converter = this.unknown;
        }
        return converter.getLatex(list, first);
    }

    ModuleReferenceList getReferences() {
        return this.references;
    }

    Map getPredicateDefinitions() {
        return this.predicateDefinitions;
    }

    Map getFunctionDefinitions() {
        return this.functionDefinitions;
    }

    class Unknown
    implements ListType {
        Unknown() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(list.getOperator());
            buffer.append("(");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(", ");
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    class QuantorUnion
    implements ListType {
        QuantorUnion() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\bigcup";
            buffer.append("\\bigcup");
            if (0 < list.size()) {
                buffer.append("{").append(Element2Latex.this.getLatex(list.getElement(0), false)).append("}");
            }
            for (int i = 1; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(" \\ \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class QuantorIntersection
    implements ListType {
        QuantorIntersection() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\bigcap";
            buffer.append("\\bigcap");
            if (0 < list.size()) {
                buffer.append("{").append(Element2Latex.this.getLatex(list.getElement(0), false)).append("}");
            }
            for (int i = 1; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(" \\ \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class Classlist
    implements ListType {
        Classlist() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\{ ";
            buffer.append("\\{ ");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(", \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class Class
    implements ListType {
        Class() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\{ ";
            buffer.append("\\{ ");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(" \\ | \\ ");
            }
            buffer.append(" \\} ");
            return buffer.toString();
        }
    }

    class Not
    implements ListType {
        Not() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "\\neg ";
            buffer.append("\\neg ");
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
            }
            return buffer.toString();
        }
    }

    class Quantifier
    implements ListType {
        private final String latex;

        Quantifier(String latex) {
            this.latex = latex;
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.latex + " ");
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0 || i == 0 && list.size() <= 2) {
                    buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                }
                if (i + 1 < list.size()) {
                    buffer.append("\\ ");
                }
                if (list.size() <= 2 || i != 1) continue;
                buffer.append("\\ ");
            }
            return buffer.toString();
        }
    }

    class BinaryLogical
    implements ListType {
        private final String latex;

        BinaryLogical(String latex) {
            this.latex = latex;
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String infix = "\\ " + this.latex + " \\ ";
            if (!first) {
                buffer.append("(");
            }
            for (int i = 0; i < list.size(); ++i) {
                buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                if (i + 1 >= list.size()) continue;
                buffer.append(infix);
            }
            if (!first) {
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Var
    implements ListType {
        Var() {
        }

        public String getLatex(ElementList list, boolean first) {
            String text = list.getElement(0).getAtom().getString();
            try {
                int index = Integer.parseInt(text);
                String newText = "" + index;
                if (!text.equals(newText) || newText.startsWith("-")) {
                    throw new NumberFormatException("This is no allowed number: " + text);
                }
                switch (index) {
                    case 1: {
                        return "x";
                    }
                    case 2: {
                        return "y";
                    }
                    case 3: {
                        return "z";
                    }
                    case 4: {
                        return "u";
                    }
                    case 5: {
                        return "v";
                    }
                    case 6: {
                        return "w";
                    }
                }
                return "x_" + (index - 6);
            }
            catch (NumberFormatException e) {
                return text;
            }
        }
    }

    class Funcon
    implements ListType {
        Funcon() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String name = list.getElement(0).getAtom().getString();
            int arguments = list.size() - 1;
            String identifier = name + "_" + arguments;
            FunctionDefinition definition = (FunctionDefinition)Element2Latex.this.getFunctionDefinitions().get(identifier);
            if (definition == null) {
                try {
                    int external = name.indexOf(".");
                    if (external >= 0 && Element2Latex.this.getReferences() != null && Element2Latex.this.getReferences().size() > 0) {
                        String label = name.substring(0, external);
                        KernelQedeqBo newProp = (KernelQedeqBo)Element2Latex.this.getReferences().getQedeqBo(label);
                        if (newProp != null) {
                            String shortName = name.substring(external + 1);
                            if (newProp.getExistenceChecker().functionExists(shortName, arguments)) {
                                DefaultExistenceChecker checker = (DefaultExistenceChecker)newProp.getExistenceChecker();
                                definition = checker.getFunction(shortName, arguments);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (definition != null) {
                StringBuffer define = new StringBuffer(definition.getLatexPattern());
                for (int i = list.size() - 1; i >= 1; --i) {
                    StringUtility.replace(define, "#" + i, Element2Latex.this.getLatex(list.getElement(i), false));
                }
                buffer.append(define);
            } else {
                buffer.append(identifier);
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Predcon
    implements ListType {
        Predcon() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String name = list.getElement(0).getAtom().getString();
            int arguments = list.size() - 1;
            String identifier = name + "_" + arguments;
            PredicateDefinition definition = (PredicateDefinition)Element2Latex.this.getPredicateDefinitions().get(identifier);
            if (definition == null) {
                try {
                    int external = name.indexOf(".");
                    if (external >= 0 && Element2Latex.this.getReferences() != null && Element2Latex.this.getReferences().size() > 0) {
                        String label = name.substring(0, external);
                        KernelQedeqBo newProp = (KernelQedeqBo)Element2Latex.this.getReferences().getQedeqBo(label);
                        if (newProp != null) {
                            String shortName = name.substring(external + 1);
                            if (newProp.getExistenceChecker().predicateExists(shortName, arguments)) {
                                DefaultExistenceChecker checker = (DefaultExistenceChecker)newProp.getExistenceChecker();
                                definition = checker.getPredicate(shortName, arguments);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (definition != null) {
                StringBuffer define = new StringBuffer(definition.getLatexPattern());
                for (int i = list.size() - 1; i >= 1; --i) {
                    StringUtility.replace(define, "#" + i, Element2Latex.this.getLatex(list.getElement(i), false));
                }
                buffer.append(define);
            } else {
                buffer.append(identifier);
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Funvar
    implements ListType {
        Funvar() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String identifier = list.getElement(0).getAtom().getString();
            buffer.append(identifier);
            if (list.size() > 1) {
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    class Predvar
    implements ListType {
        Predvar() {
        }

        public String getLatex(ElementList list, boolean first) {
            StringBuffer buffer = new StringBuffer();
            String identifier = list.getElement(0).getAtom().getString();
            buffer.append(identifier);
            if (list.size() > 1) {
                buffer.append("(");
                for (int i = 1; i < list.size(); ++i) {
                    buffer.append(Element2Latex.this.getLatex(list.getElement(i), false));
                    if (i + 1 >= list.size()) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    static interface ListType {
        public String getLatex(ElementList var1, boolean var2);
    }
}

