/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.context;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.qedeq.kernel.bo.control.InternalKernelServices;
import org.qedeq.kernel.bo.control.KernelState;
import org.qedeq.kernel.bo.module.KernelProperties;
import org.qedeq.kernel.bo.module.KernelServices;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.QedeqBo;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.config.QedeqConfig;
import org.qedeq.kernel.log.QedeqLog;
import org.qedeq.kernel.trace.Trace;

public final class KernelContext
implements KernelProperties,
KernelState,
KernelServices {
    private static final Class CLASS = class$org$qedeq$kernel$context$KernelContext == null ? (class$org$qedeq$kernel$context$KernelContext = KernelContext.class$("org.qedeq.kernel.context.KernelContext")) : class$org$qedeq$kernel$context$KernelContext;
    private static final String KERNEL_VERSION = "0.03.09";
    private static final String KERNEL_VERSION_DIRECTORY = "0.03.09".replace('.', '_');
    private static final String DESCRIPTIVE_KERNEL_VERSION = "Hilbert II - Version 0.03.09 (mongaga)";
    private static final String MAXIMAL_RULE_VERSION = "1.00.00";
    private static final KernelContext INSTANCE = new KernelContext();
    private final KernelState initialState = new KernelState(){

        public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
            QedeqLog.getInstance().logMessage("This is " + KernelContext.getInstance().getDescriptiveKernelVersion());
            QedeqLog.getInstance().logMessage("  see \"http://www.qedeq.org\" for more information");
            QedeqLog.getInstance().logMessage("  supports rules till version " + KernelContext.getInstance().getMaximalRuleVersion());
            KernelContext.this.config = qedeqConfig;
            KernelContext.this.services = moduleFactory;
            KernelContext.this.currentState = KernelContext.this.initializedState;
        }

        public boolean isReady() {
            return false;
        }

        public void shutdown() {
        }

        public void startup() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void removeAllModules() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void removeModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo loadModule(ModuleAddress address) throws SourceFileExceptionList {
            throw new IllegalStateException("Kernel not initialized");
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public void loadRequiredModules(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress[] getAllLoadedModules() {
            throw new IllegalStateException("Kernel not initialized");
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress getModuleAddress(URL url) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress getModuleAddress(String url) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public ModuleAddress getModuleAddress(File file) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String getSource(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public boolean checkModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }

        public String[] getSourceFileExceptionList(ModuleAddress address) {
            throw new IllegalStateException("Kernel not initialized");
        }
    };
    private final KernelState initializedState = new KernelState(){

        public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public boolean isReady() {
            return false;
        }

        public void shutdown() {
            KernelContext.this.currentState = KernelContext.this.initialState;
            KernelContext.this.services = null;
            QedeqLog.getInstance().logMessage("QEDEQ Kernel closed.");
        }

        public void startup() {
            KernelContext.this.services.startup();
            KernelContext.this.currentState = KernelContext.this.readyState;
            QedeqLog.getInstance().logMessage("QEDEQ kernel opened.");
        }

        public void removeAllModules() {
            throw new IllegalStateException("Kernel not started");
        }

        public void removeModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public void clearLocalBuffer() throws IOException {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo loadModule(ModuleAddress address) throws SourceFileExceptionList {
            throw new IllegalStateException("Kernel not started");
        }

        public boolean loadAllModulesFromQedeq() {
            throw new IllegalStateException("Kernel not started");
        }

        public void loadRequiredModules(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress[] getAllLoadedModules() {
            throw new IllegalStateException("Kernel not started");
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress getModuleAddress(URL url) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress getModuleAddress(String url) {
            throw new IllegalStateException("Kernel not started");
        }

        public ModuleAddress getModuleAddress(File file) {
            throw new IllegalStateException("Kernel not started");
        }

        public String getSource(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public boolean checkModule(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }

        public String[] getSourceFileExceptionList(ModuleAddress address) {
            throw new IllegalStateException("Kernel not started");
        }
    };
    private final KernelState readyState = new KernelState(){

        public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
        }

        public boolean isReady() {
            return false;
        }

        public void shutdown() {
            try {
                ModuleAddress[] addresses = KernelContext.this.services.getAllLoadedModules();
                String[] buffer = new String[addresses.length];
                for (int i = 0; i < addresses.length; ++i) {
                    buffer[i] = addresses[i].toString();
                }
                KernelContext.this.config.setLoadedModules(buffer);
                KernelContext.this.config.store();
                QedeqLog.getInstance().logMessage("Current config file successfully saved.");
            }
            catch (IOException e) {
                Trace.trace(CLASS, (Object)this, "shutdown()", (Throwable)e);
                QedeqLog.getInstance().logMessage("Saving current config file failed.");
            }
            KernelContext.this.currentState = KernelContext.this.initialState;
            KernelContext.this.services = null;
            QedeqLog.getInstance().logMessage("QEDEQ Kernel closed.");
        }

        public void startup() {
            throw new IllegalStateException("Kernel is already initialized");
        }

        public void removeAllModules() {
            KernelContext.this.services.removeAllModules();
        }

        public void removeModule(ModuleAddress address) {
            KernelContext.this.services.removeModule(address);
        }

        public void clearLocalBuffer() throws IOException {
            KernelContext.this.services.clearLocalBuffer();
        }

        public QedeqBo loadModule(ModuleAddress address) throws SourceFileExceptionList {
            return KernelContext.this.services.loadModule(address);
        }

        public boolean loadAllModulesFromQedeq() {
            return KernelContext.this.services.loadAllModulesFromQedeq();
        }

        public void loadRequiredModules(ModuleAddress address) throws SourceFileExceptionList {
            KernelContext.this.services.loadRequiredModules(address);
        }

        public ModuleAddress[] getAllLoadedModules() {
            return KernelContext.this.services.getAllLoadedModules();
        }

        public QedeqBo getQedeqBo(ModuleAddress address) {
            return KernelContext.this.services.getQedeqBo(address);
        }

        public ModuleAddress getModuleAddress(URL url) throws IOException {
            return KernelContext.this.services.getModuleAddress(url);
        }

        public ModuleAddress getModuleAddress(String url) throws IOException {
            return KernelContext.this.services.getModuleAddress(url);
        }

        public ModuleAddress getModuleAddress(File file) throws IOException {
            return KernelContext.this.services.getModuleAddress(file);
        }

        public String getSource(ModuleAddress address) throws IOException {
            return KernelContext.this.services.getSource(address);
        }

        public boolean checkModule(ModuleAddress address) {
            return KernelContext.this.services.checkModule(address);
        }

        public String[] getSourceFileExceptionList(ModuleAddress address) {
            return KernelContext.this.services.getSourceFileExceptionList(address);
        }
    };
    private KernelState currentState = this.initialState;
    private QedeqConfig config;
    private InternalKernelServices services;
    static /* synthetic */ Class class$org$qedeq$kernel$context$KernelContext;

    private KernelContext() {
    }

    public static final KernelContext getInstance() {
        return INSTANCE;
    }

    public final String getKernelVersion() {
        return KERNEL_VERSION;
    }

    public final String getKernelVersionDirectory() {
        return KERNEL_VERSION_DIRECTORY;
    }

    public final String getDescriptiveKernelVersion() {
        return DESCRIPTIVE_KERNEL_VERSION;
    }

    public final String getMaximalRuleVersion() {
        return MAXIMAL_RULE_VERSION;
    }

    public final boolean isRuleVersionSupported(String ruleVersion) {
        return MAXIMAL_RULE_VERSION.equals(ruleVersion);
    }

    public QedeqConfig getConfig() {
        return this.config;
    }

    public void init(InternalKernelServices moduleFactory, QedeqConfig qedeqConfig) throws IOException {
        this.currentState.init(moduleFactory, qedeqConfig);
    }

    public boolean isReady() {
        return this.currentState.isReady();
    }

    public void shutdown() {
        this.currentState.shutdown();
    }

    public void startup() {
        this.currentState.startup();
    }

    public void removeAllModules() {
        this.currentState.removeAllModules();
    }

    public void removeModule(ModuleAddress address) {
        this.currentState.removeModule(address);
    }

    public void clearLocalBuffer() throws IOException {
        this.currentState.clearLocalBuffer();
    }

    public QedeqBo loadModule(ModuleAddress address) throws SourceFileExceptionList {
        return this.currentState.loadModule(address);
    }

    public boolean loadAllModulesFromQedeq() {
        return this.currentState.loadAllModulesFromQedeq();
    }

    public void loadRequiredModules(ModuleAddress address) throws SourceFileExceptionList {
        this.currentState.loadRequiredModules(address);
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.currentState.getAllLoadedModules();
    }

    public QedeqBo getQedeqBo(ModuleAddress address) {
        return this.currentState.getQedeqBo(address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return this.currentState.getModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return this.currentState.getModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return this.currentState.getModuleAddress(file);
    }

    public String getSource(ModuleAddress address) throws IOException {
        return this.currentState.getSource(address);
    }

    public boolean checkModule(ModuleAddress address) {
        return this.currentState.checkModule(address);
    }

    public String[] getSourceFileExceptionList(ModuleAddress address) {
        return this.currentState.getSourceFileExceptionList(address);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

