/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;

final class ConfigAccess {
    private final File configFile;
    private Properties properties = new Properties();
    private final String description;

    public ConfigAccess(File configFile, String description) throws IOException {
        this.configFile = configFile;
        this.description = description;
        try {
            this.load(new FileInputStream(configFile));
        }
        catch (IOException e) {
            System.out.println("no config file found, using default values");
        }
        this.setString("configFileLocation", configFile.getCanonicalPath());
    }

    public final File getConfigFile() {
        return this.configFile;
    }

    public final String getConfigDescription() {
        return this.description;
    }

    private final Properties getProperties() {
        return this.properties;
    }

    private final void load(InputStream inStream) throws IOException {
        this.getProperties().load(inStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void store() throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.getConfigFile());
            this.getProperties().store(out, this.getConfigDescription());
            Object var3_2 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public final String getString(String name) {
        return this.getProperties().getProperty(name);
    }

    public final String getString(String name, String defaultValue) {
        String value = this.getProperties().getProperty(name);
        if (value == null) {
            this.setString(name, defaultValue);
            return defaultValue;
        }
        return value;
    }

    public final void setString(String name, String value) {
        this.getProperties().setProperty(name, value);
    }

    public final String[] getStringProperties(String namePrefix) {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration<Object> keys = this.getProperties().keys();
        ArrayList<Object> keyList = Collections.list(keys);
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            if (!key.startsWith(namePrefix)) continue;
            list.add(this.getProperties().get(key));
        }
        return list.toArray(new String[0]);
    }

    public final void setInteger(String name, int value) {
        this.setString(name, "" + value);
    }

    public final int getInteger(String name) {
        String intPropAsString = this.getProperties().getProperty(name);
        if (intPropAsString != null) {
            try {
                return Integer.parseInt(intPropAsString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("int property " + intPropAsString + " has invalid format");
            }
        }
        throw new NullPointerException("property \"" + name + "\" not found");
    }

    public final int getInteger(String name, int defaultValue) {
        String intPropAsString = this.getProperties().getProperty(name);
        if (intPropAsString != null) {
            try {
                return Integer.parseInt(intPropAsString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Integer-Property " + intPropAsString + " has invalid format");
            }
        }
        this.setInteger(name, defaultValue);
        return defaultValue;
    }

    public final void removeProperty(String name) {
        this.getProperties().remove(name);
    }

    public final void removeProperties(String namePrefix) {
        Enumeration<Object> keys = this.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(namePrefix)) continue;
            this.getProperties().remove(key);
        }
    }
}

