/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.qedeq.kernel.common.QedeqException;
import org.qedeq.kernel.common.SourceArea;
import org.qedeq.kernel.common.SourcePosition;
import org.qedeq.kernel.utility.IoUtility;

public class SourceFileException
extends QedeqException {
    private static final long serialVersionUID = -4109767904038020052L;
    private final SourceArea errorArea;
    private final SourceArea referenceArea;

    public SourceFileException(int errorCode, String errorText, Throwable exception, SourceArea errorArea, SourceArea referenceArea) {
        super(errorCode, errorText, exception);
        this.errorArea = errorArea;
        this.referenceArea = referenceArea;
    }

    public SourceFileException(QedeqException exception, SourceArea errorArea, SourceArea referenceArea) {
        this(exception.getErrorCode(), exception.getMessage(), exception, errorArea, referenceArea);
    }

    public SourceFileException(URL url, Exception exception) {
        super(9997, exception.toString(), exception);
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public SourceFileException(File file, Exception exception) {
        super(9998, exception.getMessage(), exception);
        URL url = IoUtility.toUrl(file);
        this.errorArea = new SourceArea(url, new SourcePosition(url, 1, 1), null);
        this.referenceArea = null;
    }

    public SourceFileException(Exception exception) {
        super(9999, exception.getMessage(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public SourceFileException(Throwable exception) {
        super(1000, exception.toString(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public SourceFileException(IOException exception) {
        super(9997, exception.toString(), exception);
        this.errorArea = null;
        this.referenceArea = null;
    }

    public SourceArea getSourceArea() {
        return this.errorArea;
    }

    public SourceArea getReferenceArea() {
        return this.referenceArea;
    }

    public String getMessage() {
        if (this.getCause() != null) {
            if (this.getCause() instanceof IOException) {
                return this.getCause().toString();
            }
            if (this.getCause().getCause() != null) {
                return this.getCause().getCause().getMessage();
            }
            return this.getCause().getMessage();
        }
        return "";
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getErrorCode() + ": " + this.getMessage());
        if (this.errorArea != null && this.errorArea.getStartPosition() != null) {
            SourcePosition start = this.errorArea.getStartPosition();
            buffer.append("\n");
            buffer.append(this.errorArea.getAddress() + ":" + start.getLine() + ":" + start.getColumn());
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getDescription();
    }
}

