/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.visitor;

import org.qedeq.kernel.base.list.Atom;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Author;
import org.qedeq.kernel.base.module.AuthorList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.ChapterList;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Header;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LinkList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.Location;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proof;
import org.qedeq.kernel.base.module.ProofList;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.SectionList;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.SubsectionList;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.base.module.UsedByList;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.visitor.QedeqTraverser;
import org.qedeq.kernel.bo.visitor.QedeqVisitor;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.ModuleDataException;

public class QedeqNotNullTraverser
implements QedeqTraverser {
    private ModuleContext currentContext;
    private QedeqVisitor visitor;
    private boolean blocked;

    public QedeqNotNullTraverser(ModuleAddress globalContext, QedeqVisitor visitor) {
        this.currentContext = globalContext.createModuleContext();
        this.visitor = visitor;
    }

    public void accept(Qedeq qedeq) throws ModuleDataException {
        this.getCurrentContext().setLocationWithinModule("");
        this.blocked = false;
        if (qedeq == null) {
            throw new NullPointerException("null QEDEQ module");
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(qedeq);
        if (qedeq.getHeader() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getHeader()");
            this.accept(qedeq.getHeader());
        }
        if (qedeq.getChapterList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getChapterList()");
            this.accept(qedeq.getChapterList());
        }
        if (qedeq.getLiteratureItemList() != null) {
            this.getCurrentContext().setLocationWithinModule(context + "getLiteratureItemList()");
            this.accept(qedeq.getLiteratureItemList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(qedeq);
        this.setLocationWithinModule(context);
    }

    public void accept(Header header) throws ModuleDataException {
        if (this.blocked || header == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(header);
        if (header.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            this.accept(header.getSpecification());
        }
        if (header.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(header.getTitle());
        }
        if (header.getSummary() != null) {
            this.setLocationWithinModule(context + ".getSummary()");
            this.accept(header.getSummary());
        }
        if (header.getAuthorList() != null) {
            this.setLocationWithinModule(context + ".getAuthorList()");
            this.accept(header.getAuthorList());
        }
        if (header.getImportList() != null) {
            this.setLocationWithinModule(context + ".getImportList()");
            this.accept(header.getImportList());
        }
        if (header.getUsedByList() != null) {
            this.setLocationWithinModule(context + ".getUsedByList()");
            this.accept(header.getUsedByList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(header);
        this.setLocationWithinModule(context);
    }

    public void accept(UsedByList usedByList) throws ModuleDataException {
        if (this.blocked || usedByList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(usedByList);
        for (int i = 0; i < usedByList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(usedByList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(usedByList);
        this.setLocationWithinModule(context);
    }

    public void accept(ImportList importList) throws ModuleDataException {
        if (this.blocked || importList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(importList);
        for (int i = 0; i < importList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(importList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(importList);
        this.setLocationWithinModule(context);
    }

    public void accept(Import imp) throws ModuleDataException {
        if (this.blocked || imp == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(imp);
        if (imp.getSpecification() != null) {
            this.setLocationWithinModule(context + ".getSpecification()");
            this.accept(imp.getSpecification());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(imp);
        this.setLocationWithinModule(context);
    }

    public void accept(Specification specification) throws ModuleDataException {
        if (this.blocked || specification == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(specification);
        if (specification.getLocationList() != null) {
            this.setLocationWithinModule(context + ".getLocationList()");
            this.accept(specification.getLocationList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(specification);
        this.setLocationWithinModule(context);
    }

    public void accept(LocationList locationList) throws ModuleDataException {
        if (this.blocked || locationList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(locationList);
        for (int i = 0; i < locationList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(locationList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(locationList);
        this.setLocationWithinModule(context);
    }

    public void accept(Location location) throws ModuleDataException {
        if (this.blocked || location == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(location);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(location);
        this.setLocationWithinModule(context);
    }

    public void accept(AuthorList authorList) throws ModuleDataException {
        if (this.blocked || authorList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(authorList);
        for (int i = 0; i < authorList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(authorList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(authorList);
        this.setLocationWithinModule(context);
    }

    public void accept(Author author) throws ModuleDataException {
        if (this.blocked || author == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(author);
        if (author.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            this.accept(author.getName());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(author);
        this.setLocationWithinModule(context);
    }

    public void accept(ChapterList chapterList) throws ModuleDataException {
        if (this.blocked || chapterList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(chapterList);
        for (int i = 0; i < chapterList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(chapterList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(chapterList);
        this.setLocationWithinModule(context);
    }

    public void accept(Chapter chapter) throws ModuleDataException {
        if (this.blocked || chapter == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(chapter);
        if (chapter.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(chapter.getTitle());
        }
        if (chapter.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            this.accept(chapter.getIntroduction());
        }
        if (chapter.getSectionList() != null) {
            this.setLocationWithinModule(context + ".getSectionList()");
            this.accept(chapter.getSectionList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(chapter);
        this.setLocationWithinModule(context);
    }

    public void accept(LiteratureItemList literatureItemList) throws ModuleDataException {
        if (this.blocked || literatureItemList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(literatureItemList);
        for (int i = 0; i < literatureItemList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(literatureItemList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(literatureItemList);
        this.setLocationWithinModule(context);
    }

    public void accept(LiteratureItem item) throws ModuleDataException {
        if (this.blocked || item == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(item);
        if (item.getItem() != null) {
            this.setLocationWithinModule(context + ".getItem()");
            this.accept(item.getItem());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(item);
        this.setLocationWithinModule(context);
    }

    public void accept(SectionList sectionList) throws ModuleDataException {
        if (this.blocked || sectionList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(sectionList);
        for (int i = 0; i < sectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(sectionList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(sectionList);
        this.setLocationWithinModule(context);
    }

    public void accept(Section section) throws ModuleDataException {
        if (this.blocked || section == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(section);
        if (section.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(section.getTitle());
        }
        if (section.getIntroduction() != null) {
            this.setLocationWithinModule(context + ".getIntroduction()");
            this.accept(section.getIntroduction());
        }
        if (section.getSubsectionList() != null) {
            this.setLocationWithinModule(context + ".getSubsectionList()");
            this.accept(section.getSubsectionList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(section);
        this.setLocationWithinModule(context);
    }

    public void accept(SubsectionList subsectionList) throws ModuleDataException {
        if (this.blocked || subsectionList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(subsectionList);
        for (int i = 0; i < subsectionList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            if (subsectionList.get(i) instanceof Subsection) {
                this.accept((Subsection)subsectionList.get(i));
                continue;
            }
            if (subsectionList.get(i) instanceof Node) {
                this.accept((Node)subsectionList.get(i));
                continue;
            }
            if (subsectionList.get(i) == null) continue;
            throw new IllegalArgumentException("unexpected subsection type: " + subsectionList.get(i).getClass());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(subsectionList);
        this.setLocationWithinModule(context);
    }

    public void accept(Subsection subsection) throws ModuleDataException {
        if (this.blocked || subsection == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(subsection);
        if (subsection.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(subsection.getTitle());
        }
        if (subsection.getLatex() != null) {
            this.setLocationWithinModule(context + ".getLatex()");
            this.accept(subsection.getLatex());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(subsection);
        this.setLocationWithinModule(context);
    }

    public void accept(Node node) throws ModuleDataException {
        if (this.blocked || node == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(node);
        if (node.getName() != null) {
            this.setLocationWithinModule(context + ".getName()");
            this.accept(node.getName());
        }
        if (node.getTitle() != null) {
            this.setLocationWithinModule(context + ".getTitle()");
            this.accept(node.getTitle());
        }
        if (node.getPrecedingText() != null) {
            this.setLocationWithinModule(context + ".getPrecedingText()");
            this.accept(node.getPrecedingText());
        }
        if (node.getNodeType() != null) {
            this.setLocationWithinModule(context + ".getNodeType()");
            if (node.getNodeType() instanceof Axiom) {
                this.setLocationWithinModule(context + ".getNodeType().getAxiom()");
                this.accept((Axiom)node.getNodeType());
            } else if (node.getNodeType() instanceof PredicateDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getPredicateDefinition()");
                this.accept((PredicateDefinition)node.getNodeType());
            } else if (node.getNodeType() instanceof FunctionDefinition) {
                this.setLocationWithinModule(context + ".getNodeType().getFunctionDefinition()");
                this.accept((FunctionDefinition)node.getNodeType());
            } else if (node.getNodeType() instanceof Proposition) {
                this.setLocationWithinModule(context + ".getNodeType().getProposition()");
                this.accept((Proposition)node.getNodeType());
            } else if (node.getNodeType() instanceof Rule) {
                this.setLocationWithinModule(context + ".getNodeType().getRule()");
                this.accept((Rule)node.getNodeType());
            } else {
                throw new IllegalArgumentException("unexpected node type: " + node.getNodeType().getClass());
            }
        }
        if (node.getSucceedingText() != null) {
            this.setLocationWithinModule(context + ".getSucceedingText()");
            this.accept(node.getSucceedingText());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(node);
        this.setLocationWithinModule(context);
    }

    public void accept(Axiom axiom) throws ModuleDataException {
        if (this.blocked || axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(axiom);
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(axiom.getFormula());
        }
        if (axiom.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(axiom.getDescription());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(axiom);
        this.setLocationWithinModule(context);
    }

    public void accept(PredicateDefinition definition) throws ModuleDataException {
        if (this.blocked || definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(definition);
        if (definition.getVariableList() != null) {
            this.setLocationWithinModule(context + ".getVariableList()");
            this.accept(definition.getVariableList());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(definition.getFormula());
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(definition.getDescription());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(definition);
        this.setLocationWithinModule(context);
    }

    public void accept(FunctionDefinition definition) throws ModuleDataException {
        if (this.blocked || definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(definition);
        if (definition.getVariableList() != null) {
            this.setLocationWithinModule(context + ".getVariableList()");
            this.accept(definition.getVariableList());
        }
        if (definition.getTerm() != null) {
            this.setLocationWithinModule(context + ".getTerm()");
            this.accept(definition.getTerm());
        }
        if (definition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(definition.getDescription());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(definition);
        this.setLocationWithinModule(context);
    }

    public void accept(Proposition proposition) throws ModuleDataException {
        if (this.blocked || proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proposition);
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula()");
            this.accept(proposition.getFormula());
        }
        if (proposition.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(proposition.getDescription());
        }
        if (proposition.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            this.accept(proposition.getProofList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proposition);
        this.setLocationWithinModule(context);
    }

    public void accept(Rule rule) throws ModuleDataException {
        if (this.blocked || rule == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(rule);
        if (rule.getLinkList() != null) {
            this.setLocationWithinModule(context + ".getLinkList()");
            this.accept(rule.getLinkList());
        }
        if (rule.getDescription() != null) {
            this.setLocationWithinModule(context + ".getDescription()");
            this.accept(rule.getDescription());
        }
        if (rule.getProofList() != null) {
            this.setLocationWithinModule(context + ".getProofList()");
            this.accept(rule.getProofList());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(rule);
        this.setLocationWithinModule(context);
    }

    public void accept(LinkList linkList) throws ModuleDataException {
        if (this.blocked || linkList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(linkList);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(linkList);
        this.setLocationWithinModule(context);
    }

    public void accept(VariableList variableList) throws ModuleDataException {
        if (this.blocked || variableList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(variableList);
        for (int i = 0; i < variableList.size(); ++i) {
            String piece = context + ".get(" + i + ")";
            this.setLocationWithinModule(piece);
            if (variableList.get(i) == null) continue;
            if (variableList.get(i).isList()) {
                this.setLocationWithinModule(piece + ".getList()");
                this.accept(variableList.get(i).getList());
                continue;
            }
            if (variableList.get(i).isAtom()) {
                this.setLocationWithinModule(piece + ".getAtom()");
                this.accept(variableList.get(i).getAtom());
                continue;
            }
            throw new IllegalArgumentException("unexpected element type: " + ((Object)variableList.get(i)).toString());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(variableList);
        this.setLocationWithinModule(context);
    }

    public void accept(ProofList proofList) throws ModuleDataException {
        if (this.blocked || proofList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proofList);
        for (int i = 0; i < proofList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(proofList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proofList);
        this.setLocationWithinModule(context);
    }

    public void accept(Proof proof) throws ModuleDataException {
        if (this.blocked || proof == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(proof);
        if (proof.getNonFormalProof() != null) {
            this.setLocationWithinModule(context + ".getNonFormalProof()");
            this.accept(proof.getNonFormalProof());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(proof);
        this.setLocationWithinModule(context);
    }

    public void accept(Formula formula) throws ModuleDataException {
        if (this.blocked || formula == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(formula);
        if (formula.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            this.accept(formula.getElement());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(formula);
        this.setLocationWithinModule(context);
    }

    public void accept(Term term) throws ModuleDataException {
        if (this.blocked || term == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(term);
        if (term.getElement() != null) {
            this.setLocationWithinModule(context + ".getElement()");
            this.accept(term.getElement());
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(term);
        this.setLocationWithinModule(context);
    }

    public void accept(Element element) throws ModuleDataException {
        if (this.blocked || element == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (element.isList()) {
            this.setLocationWithinModule(context + ".getList()");
            this.accept(element.getList());
        } else if (element.isAtom()) {
            this.setLocationWithinModule(context + ".getAtom()");
            this.accept(element.getAtom());
        } else {
            throw new IllegalArgumentException("unexpected element type: " + ((Object)element).toString());
        }
        this.setLocationWithinModule(context);
    }

    public void accept(Atom atom) throws ModuleDataException {
        if (this.blocked || atom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(atom);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(atom);
        this.setLocationWithinModule(context);
    }

    public void accept(ElementList list) throws ModuleDataException {
        if (this.blocked || list == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(list);
        for (int i = 0; i < list.size(); ++i) {
            this.setLocationWithinModule(context + ".getElement(" + i + ")");
            this.accept(list.getElement(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(list);
        this.setLocationWithinModule(context);
    }

    public void accept(LatexList latexList) throws ModuleDataException {
        if (this.blocked || latexList == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(latexList);
        for (int i = 0; i < latexList.size(); ++i) {
            this.setLocationWithinModule(context + ".get(" + i + ")");
            this.accept(latexList.get(i));
        }
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(latexList);
        this.setLocationWithinModule(context);
    }

    public void accept(Latex latex) throws ModuleDataException {
        if (this.blocked || latex == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        this.visitor.visitEnter(latex);
        this.setLocationWithinModule(context);
        this.visitor.visitLeave(latex);
        this.setLocationWithinModule(context);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public final ModuleContext getCurrentContext() {
        return this.currentContext;
    }

    public final boolean getBlocked() {
        return this.blocked;
    }

    public final void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }
}

