/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.logic;

import org.qedeq.kernel.base.list.Atom;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.bo.logic.ElementCheckException;
import org.qedeq.kernel.bo.logic.EverythingExists;
import org.qedeq.kernel.bo.logic.ExistenceChecker;
import org.qedeq.kernel.bo.logic.FormulaBasicErrors;
import org.qedeq.kernel.bo.logic.FormulaCheckException;
import org.qedeq.kernel.bo.logic.LogicalCheckException;
import org.qedeq.kernel.bo.logic.Operators;
import org.qedeq.kernel.bo.logic.TermCheckException;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.dto.list.ElementSet;
import org.qedeq.kernel.trace.Trace;

public final class FormulaChecker
implements Operators,
FormulaBasicErrors {
    private static final Class CLASS = class$org$qedeq$kernel$bo$logic$FormulaChecker == null ? (class$org$qedeq$kernel$bo$logic$FormulaChecker = FormulaChecker.class$("org.qedeq.kernel.bo.logic.FormulaChecker")) : class$org$qedeq$kernel$bo$logic$FormulaChecker;
    private final ModuleContext currentContext;
    private final ExistenceChecker existenceChecker;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$logic$FormulaChecker;

    private FormulaChecker(ModuleContext context, ExistenceChecker existenceChecker) {
        this.existenceChecker = existenceChecker;
        if (existenceChecker.equalityOperatorExists() && !existenceChecker.predicateExists(existenceChecker.getIdentityOperator(), 2)) {
            throw new IllegalArgumentException("equality predicate should exist, but it doesn't");
        }
        this.currentContext = new ModuleContext(context);
    }

    public static final void checkFormula(Element element, ModuleContext context, ExistenceChecker existenceChecker) throws LogicalCheckException {
        FormulaChecker checker = new FormulaChecker(context, existenceChecker);
        checker.checkFormula(element);
    }

    public static final void checkFormula(Element element, ModuleContext context) throws LogicalCheckException {
        FormulaChecker.checkFormula(element, context, EverythingExists.getInstance());
    }

    public static final void checkTerm(Element element, ModuleContext context, ExistenceChecker existenceChecker) throws LogicalCheckException {
        FormulaChecker checker = new FormulaChecker(context, existenceChecker);
        checker.checkTerm(element);
    }

    public static final void checkTerm(Element element, ModuleContext context) throws LogicalCheckException {
        FormulaChecker.checkTerm(element, context, EverythingExists.getInstance());
    }

    private final void checkFormula(Element element) throws LogicalCheckException {
        String method = "checkFormula";
        Trace.begin(CLASS, this, "checkFormula");
        Trace.param(CLASS, (Object)this, "checkFormula", "element", element);
        String context = this.getCurrentContext().getLocationWithinModule();
        Trace.param(CLASS, (Object)this, "checkFormula", "context", context);
        this.checkList(element);
        ElementList list = element.getList();
        String listContext = context + ".getList()";
        this.setLocationWithinModule(listContext);
        String operator = list.getOperator();
        if (operator.equals("AND") || operator.equals("OR") || operator.equals("IMPL") || operator.equals("EQUI")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "one of (and, or, implication, equivalence) operator found");
            if (list.size() <= 1) {
                throw new FormulaCheckException(30740, "more than one argument expected for the operator \"" + operator + "\"", element, this.getCurrentContext());
            }
            if (operator.equals("IMPL") && list.size() != 2) {
                throw new FormulaCheckException(30760, "exactly two or three arguments expected\"" + operator + "\"", element, this.getCurrentContext());
            }
            for (int i = 0; i < list.size(); ++i) {
                this.setLocationWithinModule(listContext + ".getElement(" + i + ")");
                this.checkFormula(list.getElement(i));
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(0, list);
        } else if (operator.equals("NOT")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "negation operator found");
            this.setLocationWithinModule(listContext);
            if (list.size() != 1) {
                throw new FormulaCheckException(30710, "exactly one argument expected for the operator \"" + operator + "\"", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(0)");
            this.checkFormula(list.getElement(0));
        } else if (operator.equals("PREDVAR") || operator.equals("PREDCON")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "predicate operator found");
            this.setLocationWithinModule(listContext);
            if (list.size() < 1) {
                throw new FormulaCheckException(30720, "at least one argument expected for \"" + operator + "\"", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(0)");
            this.checkAtomFirst(list.getElement(0));
            for (int i = 1; i < list.size(); ++i) {
                this.setLocationWithinModule(listContext + ".getElement(" + i + ")");
                this.checkTerm(list.getElement(i));
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(1, list);
            if ("PREDCON".equals(operator) && !this.existenceChecker.predicateExists(list.getElement(0).getAtom().getString(), list.size() - 1)) {
                throw new FormulaCheckException(30590, "this predicate constant is unknown (at least for this argument number): \"" + list.getElement(0).getAtom().getString() + "\" [" + (list.size() - 1) + "]", element, this.getCurrentContext());
            }
        } else if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL")) {
            Trace.trace(CLASS, (Object)this, "checkFormula", "quantifier found");
            this.setLocationWithinModule(context);
            this.checkQuantifier(element);
        } else {
            this.setLocationWithinModule(listContext + ".getOperator()");
            throw new FormulaCheckException(30530, "this logical operator is unknown: \"" + operator + "\"", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        Trace.end(CLASS, this, "checkFormula");
    }

    private void checkQuantifier(Element element) throws LogicalCheckException {
        String method = "checkQuantifier";
        Trace.begin(CLASS, this, "checkQuantifier");
        Trace.param(CLASS, (Object)this, "checkQuantifier", "element", element);
        String context = this.getCurrentContext().getLocationWithinModule();
        Trace.param(CLASS, (Object)this, "checkQuantifier", "context", context);
        this.checkList(element);
        ElementList list = element.getList();
        String listContext = context + ".getList()";
        this.setLocationWithinModule(listContext);
        String operator = list.getOperator();
        if (!operator.equals("EXISTS") && operator.equals("EXISTSU") && operator.equals("FORALL")) {
            throw new IllegalArgumentException("quantifier element expected but found: " + ((Object)element).toString());
        }
        if (list.size() < 2 || list.size() > 3) {
            throw new FormulaCheckException(30750, "exactly two or three arguments expected", element, this.getCurrentContext());
        }
        if (operator.equals("EXISTSU") && !this.existenceChecker.equalityOperatorExists()) {
            this.setLocationWithinModule(listContext + ".getOperator()");
            throw new FormulaCheckException(30570, "the equality predicate was not yet defined", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(listContext + ".getElement(" + 0 + ")");
        this.checkSubjectVariable(list.getElement(0));
        this.setLocationWithinModule(listContext + ".getElement(" + 1 + ")");
        this.checkFormula(list.getElement(1));
        this.setLocationWithinModule(listContext);
        if (FormulaChecker.getBoundSubjectVariables(list.getElement(1)).contains(list.getElement(0))) {
            throw new FormulaCheckException(30550, "subject variable is already bound in sub formula", list.getElement(1), this.getCurrentContext());
        }
        if (list.size() > 3) {
            throw new FormulaCheckException(30750, "exactly two or three arguments expected", list, this.getCurrentContext());
        }
        if (list.size() > 2) {
            this.setLocationWithinModule(listContext + ".getElement(" + 2 + ")");
            this.checkFormula(list.getElement(2));
            this.setLocationWithinModule(listContext);
            if (FormulaChecker.getBoundSubjectVariables(list.getElement(2)).contains(list.getElement(0))) {
                throw new FormulaCheckException(30550, "subject variable is already bound in sub formula", list.getElement(2), this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(1, list);
        }
        this.setLocationWithinModule(context);
        Trace.end(CLASS, this, "checkQuantifier");
    }

    private void checkTerm(Element element) throws LogicalCheckException {
        String method = "checkTerm";
        Trace.begin(CLASS, this, "checkTerm");
        Trace.param(CLASS, (Object)this, "checkTerm", "element", element);
        String context = this.getCurrentContext().getLocationWithinModule();
        Trace.param(CLASS, (Object)this, "checkTerm", "context", context);
        this.checkList(element);
        ElementList list = element.getList();
        String listContext = context + ".getList()";
        this.setLocationWithinModule(listContext);
        String operator = list.getOperator();
        if (operator.equals("VAR")) {
            this.checkSubjectVariable(element);
        } else if (operator.equals("FUNCON") || operator.equals("FUNVAR")) {
            if (operator.equals("FUNCON") && list.size() < 1) {
                throw new TermCheckException(30720, "at least one argument expected for ", element, this.getCurrentContext());
            }
            if (operator.equals("FUNVAR") && list.size() < 2) {
                throw new TermCheckException(30740, "more than one argument expected for the operator ", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(0)");
            this.checkAtomFirst(list.getElement(0));
            this.setLocationWithinModule(listContext);
            for (int i = 1; i < list.size(); ++i) {
                this.setLocationWithinModule(listContext + ".getElement(" + i + ")");
                this.checkTerm(list.getElement(i));
            }
            this.setLocationWithinModule(listContext);
            this.checkFreeAndBoundDisjunct(1, list);
            this.setLocationWithinModule(listContext);
            if ("FUNCON".equals(operator) && !this.existenceChecker.functionExists(list.getElement(0).getAtom().getString(), list.size() - 1)) {
                throw new FormulaCheckException(30690, "this function constant is unknown (at least for this argument number): \"" + list.getElement(0).getAtom().getString() + "\"", element, this.getCurrentContext());
            }
        } else if (operator.equals("CLASS")) {
            if (list.size() != 2) {
                throw new TermCheckException(30760, "exactly two or three arguments expected", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(" + 0 + ")");
            if (!this.isSubjectVariable(list.getElement(0))) {
                throw new TermCheckException(30540, "subject variable expected", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(" + 1 + ")");
            this.checkFormula(list.getElement(1));
            this.setLocationWithinModule(listContext);
            if (!this.existenceChecker.classOperatorExists()) {
                throw new FormulaCheckException(30680, "the class operator is still undefined", element, this.getCurrentContext());
            }
            this.setLocationWithinModule(listContext + ".getElement(" + 0 + ")");
            if (FormulaChecker.getBoundSubjectVariables(list.getElement(1)).contains(list.getElement(0))) {
                throw new TermCheckException(30550, "subject variable is already bound in sub formula", list.getElement(0), this.getCurrentContext());
            }
        } else {
            this.setLocationWithinModule(listContext + ".getOperator()");
            throw new TermCheckException(30620, "unknown term operator: \"" + operator + "\"", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        Trace.end(CLASS, this, "checkTerm");
    }

    private void checkFreeAndBoundDisjunct(int start, ElementList list) throws LogicalCheckException {
        String context = this.getCurrentContext().getLocationWithinModule();
        ElementSet free = new ElementSet();
        ElementSet bound = new ElementSet();
        for (int i = start; i < list.size(); ++i) {
            this.setLocationWithinModule(context + ".getElement(" + i + ")");
            ElementSet newFree = this.getFreeSubjectVariables(list.getElement(i));
            ElementSet newBound = FormulaChecker.getBoundSubjectVariables(list.getElement(i));
            ElementSet interBound = newFree.newIntersection(bound);
            if (!interBound.isEmpty()) {
                throw new FormulaCheckException(30780, "these free variables were already bound in previous formulas: " + interBound, list.getElement(i), this.getCurrentContext());
            }
            ElementSet interFree = newBound.newIntersection(free);
            if (!interFree.isEmpty()) {
                throw new FormulaCheckException(30770, "these bound variables are already free in previous formulas: " + interFree, list.getElement(i), this.getCurrentContext());
            }
            bound.union(newBound);
            free.union(newFree);
        }
        this.setLocationWithinModule(context);
    }

    private final boolean isSubjectVariable(Element element) {
        if (element == null || !element.isList() || element.getList() == null) {
            return false;
        }
        ElementList list = element.getList();
        if (list.getOperator().equals("VAR")) {
            if (list.size() != 1) {
                return false;
            }
            Element first = element.getList().getElement(0);
            if (first == null || !first.isAtom() || first.getAtom() == null) {
                return false;
            }
            Atom atom = first.getAtom();
            return atom.getString() != null && atom.getAtom().getString() != null && atom.getString().length() != 0;
        }
        return false;
    }

    private final void checkSubjectVariable(Element element) throws LogicalCheckException {
        String context = this.getCurrentContext().getLocationWithinModule();
        this.checkList(element);
        this.setLocationWithinModule(context + ".getList()");
        if (element.getList().getOperator().equals("VAR")) {
            if (element.getList().size() != 1) {
                throw new FormulaCheckException(30710, "exactly one argument expected for the operator ", element.getList(), this.getCurrentContext());
            }
        } else {
            this.setLocationWithinModule(context + ".getList().getOperator()");
            throw new FormulaCheckException(30540, "subject variable expected", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context + ".getList().getElement(0)");
        this.checkAtomFirst(element.getList().getElement(0));
        this.setLocationWithinModule(context);
    }

    private final ElementSet getFreeSubjectVariables(Element element) {
        ElementSet free = new ElementSet();
        if (this.isSubjectVariable(element)) {
            free.add(element);
        } else if (element.isList()) {
            ElementList list = element.getList();
            String operator = list.getOperator();
            if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS")) {
                for (int i = 1; i < list.size(); ++i) {
                    free.union(this.getFreeSubjectVariables(list.getElement(i)));
                }
                free.remove(list.getElement(0));
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    free.union(this.getFreeSubjectVariables(list.getElement(i)));
                }
            }
        }
        return free;
    }

    public static final ElementSet getBoundSubjectVariables(Element element) {
        ElementSet bound;
        block4: {
            bound = new ElementSet();
            if (!element.isList()) break block4;
            ElementList list = element.getList();
            String operator = list.getOperator();
            if (operator.equals("EXISTS") || operator.equals("EXISTSU") || operator.equals("FORALL") || operator.equals("CLASS")) {
                bound.add(list.getElement(0));
                for (int i = 1; i < list.size(); ++i) {
                    bound.union(FormulaChecker.getBoundSubjectVariables(list.getElement(i)));
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    bound.union(FormulaChecker.getBoundSubjectVariables(list.getElement(i)));
                }
            }
        }
        return bound;
    }

    private void checkList(Element element) throws ElementCheckException {
        String context = this.getCurrentContext().getLocationWithinModule();
        if (element == null) {
            throw new ElementCheckException(30400, "element must not be null", null, this.getCurrentContext());
        }
        if (!element.isList()) {
            throw new ElementCheckException(30470, "an atom is no formula", element, this.getCurrentContext());
        }
        ElementList list = element.getList();
        this.setLocationWithinModule(context + ".getList()");
        if (list == null) {
            throw new ElementCheckException(30420, "list must not be null", element, this.getCurrentContext());
        }
        String operator = list.getOperator();
        this.setLocationWithinModule(context + ".getList().getOperator()");
        if (operator == null) {
            throw new ElementCheckException(30450, "operator content must not be null\"" + operator + "\"", element, this.getCurrentContext());
        }
        if (operator.length() == 0) {
            throw new ElementCheckException(30460, "operator content must not be empty\"" + operator + "\"", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
    }

    private void checkAtomFirst(Element element) throws ElementCheckException {
        String context = this.getCurrentContext().getLocationWithinModule();
        if (element == null) {
            throw new ElementCheckException(30400, "element must not be null", null, this.getCurrentContext());
        }
        if (!element.isAtom()) {
            throw new ElementCheckException(30730, "first argument must be an atom", element, this.getCurrentContext());
        }
        Atom atom = element.getAtom();
        this.setLocationWithinModule(context + ".getAtom()");
        if (atom == null) {
            throw new ElementCheckException(30410, "atom must not be null", element, this.getCurrentContext());
        }
        if (atom.getString() == null) {
            throw new ElementCheckException(30430, "atom content must not be null", element, this.getCurrentContext());
        }
        if (atom.getString().length() == 0) {
            throw new ElementCheckException(30440, "atom content must not be empty", element, this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
    }

    protected void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    protected final ModuleContext getCurrentContext() {
        return this.currentContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

