/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.util.ArrayList;
import org.qedeq.kernel.bo.control.KernelModuleReferenceList;
import org.qedeq.kernel.bo.control.KernelQedeqBo;
import org.qedeq.kernel.bo.logic.ExistenceChecker;
import org.qedeq.kernel.common.DependencyState;
import org.qedeq.kernel.common.LoadingState;
import org.qedeq.kernel.common.LogicalState;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.ModuleLabels;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.module.QedeqVo;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.StringUtility;

public class StateManager {
    private static final Class CLASS = class$org$qedeq$kernel$bo$control$StateManager == null ? (class$org$qedeq$kernel$bo$control$StateManager = StateManager.class$("org.qedeq.kernel.bo.control.StateManager")) : class$org$qedeq$kernel$bo$control$StateManager;
    private final KernelQedeqBo bo;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$StateManager;

    StateManager(KernelQedeqBo bo) {
        this.bo = bo;
    }

    public void setLoadingCompleteness(int completeness) {
        this.bo.setLoadingCompleteness(completeness);
    }

    public void delete() {
        this.checkIfDeleted();
        this.invalidateOtherDependentModulesToLoaded();
        this.bo.setLoadingState(LoadingState.STATE_DELETED);
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.bo.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.bo.setLogicalState(LogicalState.STATE_UNCHECKED);
        this.bo.setException(null);
        ModuleEventLog.getInstance().removeModule(this.bo);
    }

    public void setLoadingProgressState(LoadingState state) {
        this.checkIfDeleted();
        if (state == LoadingState.STATE_LOADED) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoaded");
        }
        if (state != LoadingState.STATE_DELETED && state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLoadingFailureState for " + state);
        }
        if (this.bo.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            ModuleEventLog.getInstance().addModule(this.bo);
        }
        if (state == LoadingState.STATE_LOADING_FROM_BUFFER) {
            this.invalidateOtherDependentModulesToLoaded();
        }
        if (state == LoadingState.STATE_DELETED) {
            throw new IllegalArgumentException("call delete for " + state);
        }
        this.bo.setLoadingState(state);
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.bo.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.bo.setLogicalState(LogicalState.STATE_UNCHECKED);
        this.bo.setException(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        this.checkIfDeleted();
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        if (this.bo.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            ModuleEventLog.getInstance().addModule(this.bo);
        }
        this.invalidateOtherDependentModulesToLoaded();
        this.bo.setQedeqVo(null);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(null);
        this.bo.setLoadingState(state);
        this.bo.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.bo.setLogicalState(LogicalState.STATE_UNCHECKED);
        this.bo.setException(e);
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLoaded(QedeqVo qedeq, ModuleLabels labels) {
        this.checkIfDeleted();
        if (qedeq == null) {
            throw new NullPointerException("Qedeq is null");
        }
        this.invalidateOtherDependentModulesToLoaded();
        this.bo.setLoadingState(LoadingState.STATE_LOADED);
        this.bo.setQedeqVo(qedeq);
        this.bo.getKernelRequiredModules().clear();
        this.bo.getDependentModules().clear();
        this.bo.setLabels(labels);
        this.bo.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.bo.setLogicalState(LogicalState.STATE_UNCHECKED);
        this.bo.setException(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setDependencyProgressState(DependencyState state) {
        this.checkIfDeleted();
        if (!this.bo.isLoaded() && state != DependencyState.STATE_UNDEFINED) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setDependencyFailureState");
        }
        if (state == DependencyState.STATE_LOADED_REQUIRED_MODULES) {
            throw new IllegalArgumentException("this state could only be set by calling method setLoadedRequiredModules");
        }
        if (state == DependencyState.STATE_LOADING_REQUIRED_MODULES) {
            this.invalidateOtherDependentModulesToLoaded();
        }
        this.bo.setLogicalState(LogicalState.STATE_UNCHECKED);
        this.bo.setDependencyState(state);
        this.bo.getKernelRequiredModules().clear();
        this.bo.setException(null);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        this.checkIfDeleted();
        if (!this.bo.isLoaded()) {
            throw new IllegalStateException("module is not yet loaded");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLoadingProgressState");
        }
        this.invalidateOtherDependentModulesToLoadedRequired();
        this.bo.setDependencyState(state);
        this.bo.setException(e);
        if (e == null) {
            throw new NullPointerException("Exception must not be null");
        }
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    private void invalidateOtherDependentModulesToLoaded() {
        String method = "invalidateOtherDependModulesToLoaded";
        Trace.begin(CLASS, this, "invalidateOtherDependModulesToLoaded");
        Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "bo", this.bo);
        if (this.bo.hasLoadedRequiredModules()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                KernelQedeqBo ref = (KernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoaded();
            }
            list.clear();
            dependent.clear();
            KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
            for (int i2 = 0; i2 < required.size(); ++i2) {
                KernelQedeqBo ref = required.getKernelQedeqBo(i2);
                Trace.param(CLASS, (Object)this, "invalidateOtherDependModulesToLoaded", "remove dependence from", ref);
                ref.getDependentModules().remove(this.bo);
            }
            required.clear();
        }
        Trace.end(CLASS, this, "invalidateOtherDependModulesToLoaded");
    }

    private void invalidateDependentModulesToLoaded() {
        String method = "invalidateDependentModulesToLoaded";
        Trace.begin(CLASS, this, "invalidateDependentModulesToLoaded");
        Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "bo", this.bo);
        if (this.bo.hasLoadedRequiredModules()) {
            int i;
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "begin list of dependent modules");
            ArrayList<KernelQedeqBo> list = new ArrayList<KernelQedeqBo>();
            for (i = 0; i < dependent.size(); ++i) {
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "" + i, dependent.getKernelQedeqBo(i));
                list.add(dependent.getKernelQedeqBo(i));
            }
            Trace.trace(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "end list of dependent modules");
            for (i = 0; i < list.size(); ++i) {
                KernelQedeqBo ref = (KernelQedeqBo)list.get(i);
                if (!dependent.contains(ref)) continue;
                ref.getStateManager().invalidateDependentModulesToLoaded();
            }
            list.clear();
            dependent.clear();
            KernelModuleReferenceList required = this.bo.getKernelRequiredModules();
            for (int i2 = 0; i2 < required.size(); ++i2) {
                KernelQedeqBo ref = required.getKernelQedeqBo(i2);
                Trace.param(CLASS, (Object)this, "invalidateDependentModulesToLoaded", "remove dependence from", ref);
                ref.getDependentModules().remove(this.bo);
            }
            required.clear();
            this.invalidateThisModule();
            this.bo.setLoadingState(LoadingState.STATE_LOADED);
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
        Trace.end(CLASS, this, "invalidateDependentModulesToLoaded");
    }

    private void invalidateOtherDependentModulesToLoadedRequired() {
        if (this.bo.isChecked()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                KernelQedeqBo ref = dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToLoadedRequired();
            }
        }
    }

    private void invalidateDependentModulesToLoadedRequired() {
        if (this.bo.isChecked()) {
            KernelModuleReferenceList dependent = this.bo.getDependentModules();
            for (int i = 0; i < dependent.size(); ++i) {
                KernelQedeqBo ref = dependent.getKernelQedeqBo(i);
                ref.getStateManager().invalidateDependentModulesToLoadedRequired();
            }
            this.invalidateThisModule();
            this.bo.setDependencyState(DependencyState.STATE_LOADED_REQUIRED_MODULES);
            ModuleEventLog.getInstance().stateChanged(this.bo);
        }
    }

    private void invalidateThisModule() {
        this.bo.setLoadingState(LoadingState.STATE_LOADED);
        this.bo.setDependencyState(DependencyState.STATE_UNDEFINED);
        this.bo.setLogicalState(LogicalState.STATE_UNCHECKED);
        this.bo.setException(null);
    }

    public void setLoadedRequiredModules(KernelModuleReferenceList required) {
        this.checkIfDeleted();
        if (!this.bo.isLoaded()) {
            throw new IllegalStateException("Required modules can only be set if module is loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        this.invalidateDependentModulesToLoadedRequired();
        for (int i = 0; i < required.size(); ++i) {
            KernelQedeqBo current = required.getKernelQedeqBo(i);
            try {
                current.getDependentModules().add(required.getModuleContext(i), required.getLabel(i), this.bo);
                continue;
            }
            catch (ModuleDataException me) {
                throw new RuntimeException(me);
            }
        }
        this.bo.setDependencyState(DependencyState.STATE_LOADED_REQUIRED_MODULES);
        this.bo.getKernelRequiredModules().set(required);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setChecked(ExistenceChecker checker) {
        this.checkIfDeleted();
        if (!this.bo.hasLoadedRequiredModules()) {
            throw new IllegalStateException("Checked can only be set if all required modules are loaded.\"\nCurrently the status for the module\"" + this.bo.getName() + "\" is \"" + this.bo.getLoadingState() + "\"");
        }
        this.bo.setLogicalState(LogicalState.STATE_CHECKED);
        this.bo.setExistenceChecker(checker);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLogicalProgressState(LogicalState state) {
        if (this.bo.getDependencyState().getCode() < DependencyState.STATE_LOADED_REQUIRED_MODULES.getCode() && state != LogicalState.STATE_UNCHECKED) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (state.isFailure()) {
            throw new IllegalArgumentException("this is a failure state, call setLogicalFailureState");
        }
        if (state == LogicalState.STATE_CHECKED) {
            throw new IllegalArgumentException("set with setChecked(ExistenceChecker)");
        }
        this.invalidateOtherDependentModulesToLoadedRequired();
        this.bo.setException(null);
        this.bo.setLogicalState(state);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    public void setLogicalFailureState(LogicalState state, SourceFileExceptionList e) {
        if (!(this.bo.isLoaded() && this.bo.hasLoadedRequiredModules() || state == LogicalState.STATE_UNCHECKED)) {
            throw new IllegalArgumentException("this state could only be set if all required modules are loaded ");
        }
        if (!state.isFailure()) {
            throw new IllegalArgumentException("this is no failure state, call setLogicalProgressState");
        }
        this.invalidateDependentModulesToLoadedRequired();
        this.bo.setLogicalState(state);
        this.bo.setException(e);
        ModuleEventLog.getInstance().stateChanged(this.bo);
    }

    private void checkIfDeleted() {
        if (this.bo.getLoadingState() == LoadingState.STATE_DELETED) {
            throw new IllegalStateException("module is already deleted: " + this.bo.getUrl());
        }
    }

    public void printDependencyTree() {
        this.printDependencyTree(0);
        System.out.println();
    }

    private void printDependencyTree(int tab) {
        System.out.println(StringUtility.getSpaces(tab) + this.bo.getName());
        int newTab = tab + this.bo.getName().length();
        KernelModuleReferenceList dependent = this.bo.getDependentModules();
        for (int i = 0; i < dependent.size(); ++i) {
            KernelQedeqBo ref = dependent.getKernelQedeqBo(i);
            ref.getStateManager().printDependencyTree(newTab);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

