/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.bo.control.CheckRequiredModuleException;
import org.qedeq.kernel.bo.control.ControlVisitor;
import org.qedeq.kernel.bo.control.KernelModuleReferenceList;
import org.qedeq.kernel.bo.control.KernelQedeqBo;
import org.qedeq.kernel.bo.control.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.logic.FormulaChecker;
import org.qedeq.kernel.bo.logic.Function;
import org.qedeq.kernel.bo.logic.Predicate;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.IllegalModuleDataException;
import org.qedeq.kernel.common.LogicalState;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.trace.Trace;

public final class QedeqBoFormalLogicChecker
extends ControlVisitor {
    private static final Class CLASS = class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker == null ? (class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker = QedeqBoFormalLogicChecker.class$("org.qedeq.kernel.bo.control.QedeqBoFormalLogicChecker")) : class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker;
    private ModuleConstantsExistenceChecker existence;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker;

    private QedeqBoFormalLogicChecker(KernelQedeqBo prop) {
        super(prop);
    }

    public static void check(KernelQedeqBo prop) throws SourceFileExceptionList {
        if (prop.isChecked()) {
            return;
        }
        if (!prop.hasLoadedRequiredModules()) {
            throw new IllegalStateException("QEDEQ module has not loaded with required files: " + prop);
        }
        prop.setLogicalProgressState(LogicalState.STATE_EXTERNAL_CHECKING);
        KernelModuleReferenceList list = (KernelModuleReferenceList)prop.getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Trace.trace(CLASS, (Object)"check(DefaultQedeqBo)", "checking label", list.getLabel(i));
                QedeqBoFormalLogicChecker.check(list.getKernelQedeqBo(i));
                continue;
            }
            catch (SourceFileExceptionList e) {
                CheckRequiredModuleException md = new CheckRequiredModuleException(11231, "import check failed: " + list.getQedeqBo(i).getModuleAddress(), list.getModuleContext(i));
                SourceFileExceptionList sfl = prop.createSourceFileExceptionList(md);
                prop.setLogicalFailureState(LogicalState.STATE_EXTERNAL_CHECKING_FAILED, sfl);
                throw e;
            }
        }
        prop.setLogicalProgressState(LogicalState.STATE_INTERNAL_CHECKING);
        QedeqBoFormalLogicChecker checker = new QedeqBoFormalLogicChecker(prop);
        try {
            checker.traverse();
        }
        catch (SourceFileExceptionList sfl) {
            prop.setLogicalFailureState(LogicalState.STATE_INTERNAL_CHECKING_FAILED, sfl);
            throw sfl;
        }
        prop.setChecked(checker.existence);
    }

    protected void traverse() throws DefaultSourceFileExceptionList {
        try {
            this.existence = new ModuleConstantsExistenceChecker(this.getQedeqBo());
        }
        catch (ModuleDataException me) {
            this.addModuleDataException(me);
            throw this.getSourceFileExceptionList();
        }
        super.traverse();
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Predicate predicate = new Predicate(definition.getName(), definition.getArgumentNumber());
        if (this.existence.predicateExists(predicate)) {
            throw new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicate, this.getCurrentContext());
        }
        if ("2".equals(predicate.getArguments()) && "equal".equals(predicate.getName())) {
            this.existence.setIdentityOperatorDefined(true, predicate.getName());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = definition.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Function function = new Function(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            throw new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext());
        }
        if (definition.getTerm() != null) {
            this.setLocationWithinModule(context + ".getTerm().getElement()");
            Term term = definition.getTerm();
            FormulaChecker.checkTerm(term.getElement(), this.getCurrentContext(), this.existence);
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
        }
        this.setLocationWithinModule(context);
        this.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        if (rule.getName() != null && "SET_DEFINION_BY_FORMULA".equals(rule.getName())) {
            this.existence.setClassOperatorExists(true);
        }
        this.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

