/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.net.URL;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.bo.control.KernelModuleReferenceList;
import org.qedeq.kernel.bo.control.ModuleLoader;
import org.qedeq.kernel.bo.control.StateManager;
import org.qedeq.kernel.bo.logic.ExistenceChecker;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.DependencyState;
import org.qedeq.kernel.common.LoadingState;
import org.qedeq.kernel.common.LogicalState;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.ModuleLabels;
import org.qedeq.kernel.common.ModuleReferenceList;
import org.qedeq.kernel.common.QedeqBo;
import org.qedeq.kernel.common.SourceArea;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.dto.module.QedeqVo;
import org.qedeq.kernel.utility.EqualsUtility;

public class KernelQedeqBo
implements QedeqBo {
    private final ModuleAddress address;
    private int loadingCompleteness;
    private LoadingState loadingState;
    private DependencyState dependencyState;
    private LogicalState logicalState;
    private QedeqVo qedeq;
    private SourceFileExceptionList exception;
    private KernelModuleReferenceList required;
    private KernelModuleReferenceList dependent;
    private ExistenceChecker checker;
    private String encoding;
    private ModuleLabels labels;
    private ModuleLoader loader;
    private final StateManager stateManager;

    KernelQedeqBo(ModuleAddress address) {
        this.address = address;
        if (address == null) {
            throw new NullPointerException("ModuleAddress must not be null");
        }
        this.loadingState = LoadingState.STATE_UNDEFINED;
        this.loadingCompleteness = 0;
        this.dependencyState = DependencyState.STATE_UNDEFINED;
        this.logicalState = LogicalState.STATE_UNCHECKED;
        this.required = new KernelModuleReferenceList();
        this.dependent = new KernelModuleReferenceList();
        this.stateManager = new StateManager(this);
    }

    public void setLoader(ModuleLoader loader) {
        this.loader = loader;
    }

    public ModuleLoader getLoader() {
        return this.loader;
    }

    public boolean hasFailures() {
        return this.loadingState.isFailure() || this.dependencyState.isFailure() || this.logicalState.isFailure();
    }

    public ModuleAddress getModuleAddress() {
        return this.address;
    }

    public void setLoadingCompleteness(int completeness) {
        this.loadingCompleteness = completeness;
    }

    public int getLoadingCompleteness() {
        return this.loadingCompleteness;
    }

    public void delete() {
        this.stateManager.delete();
    }

    public void setLoadingProgressState(LoadingState state) {
        this.stateManager.setLoadingProgressState(state);
    }

    public void setLoadingFailureState(LoadingState state, SourceFileExceptionList e) {
        this.stateManager.setLoadingFailureState(state, e);
    }

    public LoadingState getLoadingState() {
        return this.loadingState;
    }

    public boolean isLoaded() {
        return this.loadingState == LoadingState.STATE_LOADED;
    }

    public void setLoaded(QedeqVo qedeq, ModuleLabels labels) {
        this.stateManager.setLoaded(qedeq, labels);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Qedeq getQedeq() {
        return this.qedeq;
    }

    public void setDependencyProgressState(DependencyState state) {
        this.stateManager.setDependencyProgressState(state);
    }

    public void setDependencyFailureState(DependencyState state, SourceFileExceptionList e) {
        this.stateManager.setDependencyFailureState(state, e);
    }

    public DependencyState getDependencyState() {
        return this.dependencyState;
    }

    public void setLoadedRequiredModules(KernelModuleReferenceList list) {
        this.stateManager.setLoadedRequiredModules(list);
    }

    public ModuleReferenceList getRequiredModules() {
        return this.getKernelRequiredModules();
    }

    public KernelModuleReferenceList getKernelRequiredModules() {
        return this.required;
    }

    public boolean hasLoadedRequiredModules() {
        return this.isLoaded() && this.dependencyState == DependencyState.STATE_LOADED_REQUIRED_MODULES;
    }

    public KernelModuleReferenceList getDependentModules() {
        return this.dependent;
    }

    public void setChecked(ExistenceChecker checker) {
        this.stateManager.setChecked(checker);
    }

    public ExistenceChecker getExistenceChecker() {
        return this.checker;
    }

    public boolean isChecked() {
        return this.isLoaded() && this.hasLoadedRequiredModules() && this.logicalState == LogicalState.STATE_CHECKED;
    }

    public void setLogicalProgressState(LogicalState state) {
        this.stateManager.setLogicalProgressState(state);
    }

    public void setLogicalFailureState(LogicalState state, SourceFileExceptionList e) {
        this.stateManager.setLogicalFailureState(state, e);
    }

    public LogicalState getLogicalState() {
        return this.logicalState;
    }

    public SourceFileExceptionList getException() {
        return this.exception;
    }

    public SourceFileExceptionList getWarnings() {
        return null;
    }

    public String getStateDescription() {
        if (this.loadingState == LoadingState.STATE_LOADING_FROM_WEB) {
            return this.loadingState.getText() + " (" + this.loadingCompleteness + "%)";
        }
        if (!this.isLoaded()) {
            return this.loadingState.getText();
        }
        if (!this.hasLoadedRequiredModules()) {
            if (this.dependencyState == DependencyState.STATE_UNDEFINED) {
                return this.loadingState.getText();
            }
            return this.dependencyState.getText();
        }
        if (!this.isChecked()) {
            if (this.logicalState == LogicalState.STATE_UNCHECKED) {
                return this.dependencyState.getText();
            }
            return this.logicalState.getText();
        }
        return this.logicalState.getText();
    }

    public String getName() {
        if (this.address == null) {
            return "null";
        }
        return this.address.getName();
    }

    public String getRuleVersion() {
        if (this.address == null || this.qedeq == null || this.qedeq.getHeader() == null || this.qedeq.getHeader().getSpecification() == null || this.qedeq.getHeader().getSpecification().getRuleVersion() == null) {
            return "";
        }
        return this.qedeq.getHeader().getSpecification().getRuleVersion();
    }

    public URL getUrl() {
        if (this.address == null) {
            return null;
        }
        return this.address.getURL();
    }

    public void setLabels(ModuleLabels labels) {
        this.labels = labels;
    }

    public ModuleLabels getLabels() {
        return this.labels;
    }

    public SourceFileExceptionList createSourceFileExceptionList(ModuleDataException exception) {
        SourceFileException e = new SourceFileException(exception, this.createSourceArea(this.qedeq, exception.getContext()), this.loader.createSourceArea(this.qedeq, exception.getReferenceContext()));
        DefaultSourceFileExceptionList list = new DefaultSourceFileExceptionList(e);
        return list;
    }

    public SourceFileExceptionList createSourceFileExceptionList(ModuleDataException exception, Qedeq qedeq) {
        SourceFileException e = new SourceFileException(exception, this.createSourceArea(qedeq, exception.getContext()), this.loader.createSourceArea(qedeq, exception.getReferenceContext()));
        DefaultSourceFileExceptionList list = new DefaultSourceFileExceptionList(e);
        return list;
    }

    public SourceFileException createSourceFileException(ModuleDataException exception) {
        SourceFileException e = new SourceFileException(exception, this.createSourceArea(this.qedeq, exception.getContext()), this.loader.createSourceArea(this.qedeq, exception.getReferenceContext()));
        return e;
    }

    public SourceArea createSourceArea(Qedeq qedeq, ModuleContext context) {
        return this.loader.createSourceArea(qedeq, context);
    }

    protected void setQedeqVo(QedeqVo qedeq) {
        this.qedeq = qedeq;
    }

    protected void setLoadingState(LoadingState state) {
        this.loadingState = state;
    }

    protected void setDependencyState(DependencyState state) {
        this.dependencyState = state;
    }

    protected void setLogicalState(LogicalState state) {
        this.logicalState = state;
    }

    protected void setException(SourceFileExceptionList exception) {
        this.exception = exception;
    }

    protected StateManager getStateManager() {
        return this.stateManager;
    }

    protected void setExistenceChecker(ExistenceChecker checker) {
        this.checker = checker;
    }

    public int hashCode() {
        return this.getModuleAddress() == null ? 0 : this.getModuleAddress().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof KernelQedeqBo) {
            return EqualsUtility.equals(((KernelQedeqBo)obj).getModuleAddress(), this.getModuleAddress());
        }
        return false;
    }

    public String toString() {
        return this.address.getURL().toString();
    }
}

