/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.common.ModuleAddress;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;

public class DefaultModuleAddress
implements ModuleAddress {
    private static final Class CLASS = class$org$qedeq$kernel$bo$control$DefaultModuleAddress == null ? (class$org$qedeq$kernel$bo$control$DefaultModuleAddress = DefaultModuleAddress.class$("org.qedeq.kernel.bo.control.DefaultModuleAddress")) : class$org$qedeq$kernel$bo$control$DefaultModuleAddress;
    private final URL url;
    private final String header;
    private final String path;
    private final String fileName;
    private final boolean relativeAddress;
    private final boolean fileAddress;
    private final String name;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$DefaultModuleAddress;

    public DefaultModuleAddress(String u) throws MalformedURLException {
        this(u, null);
    }

    public DefaultModuleAddress(URL u) throws MalformedURLException {
        this(u.toExternalForm(), null);
    }

    public DefaultModuleAddress(File file) throws MalformedURLException {
        this(IoUtility.toUrl(file));
    }

    public DefaultModuleAddress(String address, ModuleAddress parent) throws MalformedURLException {
        String mname;
        URL urmel;
        String method = "ModuleAddress(String, ModuleAddress)";
        if (address == null) {
            throw new NullPointerException();
        }
        try {
            urmel = parent != null ? new URL(parent.getURL(), address) : new URL(address);
        }
        catch (MalformedURLException e) {
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "address=" + address);
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "parent=" + parent);
            Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", (Throwable)e);
            try {
                String newAddress = "file:" + address;
                urmel = parent != null ? new URL(parent.getURL(), newAddress) : new URL(newAddress);
            }
            catch (MalformedURLException ex) {
                throw e;
            }
        }
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "protocol=" + urmel.getProtocol());
        this.url = urmel;
        this.fileAddress = this.url.getProtocol().equalsIgnoreCase("file");
        String p = urmel.getFile();
        int position = p.lastIndexOf("/");
        if (position >= 0 && position + 1 < p.length()) {
            this.path = p.substring(0, position) + "/";
            this.fileName = p.substring(position + 1);
        } else {
            this.path = "";
            this.fileName = p;
        }
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "path=" + this.path);
        Trace.trace(CLASS, (Object)this, "ModuleAddress(String, ModuleAddress)", "fileName=" + this.fileName);
        boolean bl = this.relativeAddress = !this.path.startsWith("/");
        if (!this.fileName.endsWith(".xml")) {
            throw new MalformedURLException("file name doesn't end with \".xml\": " + this.fileName);
        }
        int positionBefore = this.fileName.lastIndexOf(".");
        this.name = mname = this.fileName.substring(0, positionBefore);
        int positionPath = this.url.toString().lastIndexOf(this.path + this.fileName);
        if (positionPath < 0) {
            throw new IllegalArgumentException("couldn't determine begin of file path: " + this.url.toString());
        }
        this.header = this.url.toString().substring(0, positionPath);
    }

    public final ModuleContext createModuleContext() {
        return new ModuleContext(this);
    }

    public final String getHeader() {
        return this.header;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getName() {
        return this.name;
    }

    public final URL getURL() {
        return this.url;
    }

    public final boolean isRelativeAddress() {
        return this.relativeAddress;
    }

    public final boolean isFileAddress() {
        return this.fileAddress;
    }

    public final String toString() {
        return this.url.toString();
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof DefaultModuleAddress)) {
            return false;
        }
        return this.url.equals(((DefaultModuleAddress)object).url);
    }

    public static final String getModuleFileName(Specification spec) {
        return spec.getName() + ".xml";
    }

    public static final ModuleAddress[] getModulePaths(ModuleAddress address, Specification spec) throws IOException {
        String fileNameEnd = DefaultModuleAddress.getModuleFileName(spec);
        LocationList locations = spec.getLocationList();
        ModuleAddress[] result = new ModuleAddress[locations.size()];
        for (int i = 0; i < locations.size(); ++i) {
            String fileName = locations.get(i).getLocation();
            if (fileName.equals(".")) {
                fileName = "";
            } else if (!fileName.endsWith("/")) {
                fileName = fileName + "/";
            }
            fileName = fileName + fileNameEnd;
            result[i] = new DefaultModuleAddress(fileName, address);
        }
        return result;
    }

    public static final String createRelativeAddress(String origin, String next) {
        if (origin.equals(next)) {
            return "";
        }
        try {
            URL urlOrgin = new URL(origin);
            URL urlNext = new URL(next);
            if (urlOrgin.getProtocol().equals(urlNext.getProtocol()) && urlOrgin.getHost().equals(urlNext.getHost()) && urlOrgin.getPort() == urlNext.getPort()) {
                String org = urlOrgin.getFile();
                String nex = urlNext.getFile();
                int i = -1;
                int j = 0;
                while (0 <= (i = org.indexOf("/", j)) && i >= 0 && nex.length() > i && org.substring(j, i).equals(nex.substring(j, i))) {
                    j = i + 1;
                }
                if (j > 0) {
                    i = j;
                    StringBuffer result = new StringBuffer(nex.length());
                    while (0 <= (i = org.indexOf("/", i))) {
                        ++i;
                        result.append("../");
                    }
                    result.append(nex.substring(j));
                    return result.toString();
                }
                return "/" + nex;
            }
            return urlNext.toString();
        }
        catch (MalformedURLException e) {
            return next;
        }
    }

    public static final String newEnding(String address, String newEnding) {
        if (address.length() == 0) {
            return "";
        }
        int i = address.lastIndexOf(".");
        if (i > 0) {
            return address.substring(0, i + 1) + newEnding;
        }
        return address + "." + newEnding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

