/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import org.qedeq.kernel.bo.control.KernelQedeqBo;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.common.DefaultSourceFileExceptionList;
import org.qedeq.kernel.common.ModuleContext;
import org.qedeq.kernel.common.ModuleDataException;
import org.qedeq.kernel.common.SourceFileException;

public abstract class ControlVisitor
extends AbstractModuleVisitor {
    private final KernelQedeqBo prop;
    private final QedeqNotNullTraverser traverser;
    private DefaultSourceFileExceptionList errorList;

    protected ControlVisitor(KernelQedeqBo prop) {
        if (prop.getQedeq() == null) {
            throw new NullPointerException("Programming error, Module not loaded: " + prop.getModuleAddress());
        }
        this.prop = prop;
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
    }

    protected KernelQedeqBo getQedeqBo() {
        return this.prop;
    }

    protected void traverse() throws DefaultSourceFileExceptionList {
        try {
            this.traverser.accept(this.prop.getQedeq());
        }
        catch (ModuleDataException me) {
            this.addModuleDataException(me);
        }
        if (this.errorList != null) {
            throw this.errorList;
        }
    }

    protected ModuleContext getCurrentContext() {
        return this.traverser.getCurrentContext();
    }

    public DefaultSourceFileExceptionList getSourceFileExceptionList() {
        return this.errorList;
    }

    protected void addModuleDataException(ModuleDataException me) {
        this.addSourceFileException(this.prop.createSourceFileException(me));
    }

    protected void addSourceFileException(SourceFileException sf) {
        if (this.errorList == null) {
            this.errorList = new DefaultSourceFileExceptionList(sf);
        } else {
            this.errorList.add(sf);
        }
    }

    protected void setBlocked(boolean blocked) {
        this.traverser.setBlocked(blocked);
    }
}

