/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.xml.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Author;
import org.qedeq.kernel.base.module.AuthorList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.ChapterList;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Header;
import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LinkList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.Location;
import org.qedeq.kernel.base.module.LocationList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proof;
import org.qedeq.kernel.base.module.ProofList;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.SectionList;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.SubsectionList;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.base.module.UsedByList;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.dto.list.Enumerator;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.mapper.LocationFoundException;
import org.qedeq.kernel.xml.mapper.LocationNotFoundException;
import org.qedeq.kernel.xml.tracker.SimpleXPath;

public final class Context2SimpleXPath
extends AbstractModuleVisitor {
    private static final Class CLASS = class$org$qedeq$kernel$xml$mapper$Context2SimpleXPath == null ? (class$org$qedeq$kernel$xml$mapper$Context2SimpleXPath = Context2SimpleXPath.class$("org.qedeq.kernel.xml.mapper.Context2SimpleXPath")) : class$org$qedeq$kernel$xml$mapper$Context2SimpleXPath;
    private QedeqNotNullTraverser traverser;
    private Qedeq qedeq;
    private final ModuleContext find;
    private SimpleXPath current;
    private final List elements;
    private int level;
    private boolean matching;
    private String matchingBegin;
    private SimpleXPath matchingPath;
    static /* synthetic */ Class class$org$qedeq$kernel$xml$mapper$Context2SimpleXPath;

    private Context2SimpleXPath(ModuleContext find, Qedeq qedeq) {
        this.qedeq = qedeq;
        this.traverser = new QedeqNotNullTraverser(find.getModuleLocation(), this);
        this.find = find;
        this.elements = new ArrayList(20);
    }

    public static SimpleXPath getXPath(ModuleContext find, Qedeq qedeq) throws ModuleDataException {
        Context2SimpleXPath converter = new Context2SimpleXPath(find, qedeq);
        return converter.find();
    }

    private final SimpleXPath find() throws ModuleDataException {
        String method = "find()";
        Trace.paramInfo(CLASS, (Object)this, "find()", "find", this.find);
        this.elements.clear();
        this.level = 0;
        this.current = new SimpleXPath();
        try {
            this.traverser.accept(this.qedeq);
        }
        catch (LocationFoundException e) {
            Trace.paramInfo(CLASS, (Object)this, "find()", "location found", this.current);
            return this.current;
        }
        Trace.param(CLASS, (Object)this, "find()", "level", this.level);
        Trace.info(CLASS, this, "find()", "location was not found");
        throw new LocationNotFoundException(this.find);
    }

    public final void visitEnter(Qedeq qedeq) throws ModuleDataException {
        this.enter("QEDEQ");
        String method = "visitEnter(Qedeq)";
        Trace.param(CLASS, (Object)this, "visitEnter(Qedeq)", "current", this.current);
        this.checkMatching("visitEnter(Qedeq)");
    }

    public final void visitLeave(Qedeq qedeq) {
        this.leave();
    }

    public final void visitEnter(Header header) throws ModuleDataException {
        this.enter("HEADER");
        String method = "visitEnter(Header)";
        Trace.param(CLASS, (Object)this, "visitEnter(Header)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Header)");
        this.traverser.setLocationWithinModule(context + ".getEmail()");
        this.current.setAttribute("email");
        this.checkIfFound();
    }

    public final void visitLeave(Header header) {
        this.leave();
    }

    public final void visitEnter(Specification specification) throws ModuleDataException {
        this.enter("SPECIFICATION");
        String method = "visitEnter(Specification)";
        Trace.param(CLASS, (Object)this, "visitEnter(Specification)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Specification)");
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getRuleVersion()");
        this.current.setAttribute("ruleVersion");
        this.checkIfFound();
    }

    public final void visitLeave(Specification specification) {
        this.leave();
    }

    /*
     * WARNING - void declaration
     */
    public final void visitEnter(LatexList latexList) throws ModuleDataException {
        void var4_4;
        String name;
        String method = "visitEnter(LatexList)";
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.endsWith(".getTitle()")) {
            name = "TITLE";
        } else if (context.endsWith(".getSummary()")) {
            name = "ABSTRACT";
        } else if (context.endsWith(".getIntroduction()")) {
            name = "INTRODUCTION";
        } else if (context.endsWith(".getName()")) {
            name = "NAME";
        } else if (context.endsWith(".getPrecedingText()")) {
            name = "PRECEDING";
        } else if (context.endsWith(".getSucceedingText()")) {
            name = "SUCCEEDING";
        } else if (context.endsWith(".getLatex()")) {
            name = "TEXT";
        } else if (context.endsWith(".getDescription()")) {
            name = "DESCRIPTION";
        } else if (context.endsWith(".getNonFormalProof()")) {
            name = null;
        } else if (context.endsWith(".getItem()")) {
            name = null;
        } else {
            throw new IllegalArgumentException("unknown LatexList " + context);
        }
        Trace.param(CLASS, (Object)this, "visitEnter(LatexList)", "name", var4_4);
        if (var4_4 != null) {
            this.enter((String)var4_4);
        }
        Trace.param(CLASS, (Object)this, "visitEnter(LatexList)", "current", this.current);
        this.checkMatching("visitEnter(LatexList)");
    }

    public final void visitLeave(LatexList latexList) {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (!context.endsWith(".getNonFormalProof()") && !context.endsWith(".getItem()")) {
            this.leave();
        }
    }

    public final void visitEnter(Latex latex) throws ModuleDataException {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.indexOf(".getAuthorList().get(") >= 0) {
            this.enter("NAME");
        }
        this.enter("LATEX");
        String method = "visitEnter(Latex)";
        Trace.param(CLASS, (Object)this, "visitEnter(Latex)", "current", this.current);
        this.checkMatching("visitEnter(Latex)");
        this.traverser.setLocationWithinModule(context + ".getLanguage()");
        this.current.setAttribute("language");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatex()");
        this.current.setAttribute(null);
        this.checkIfFound();
    }

    public final void visitLeave(Latex latex) {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.indexOf(".getAuthorList().get(") >= 0) {
            this.leave();
        }
        this.leave();
    }

    public final void visitEnter(LocationList locationList) throws ModuleDataException {
        this.enter("LOCATIONS");
        String method = "visitEnter(LocationList)";
        Trace.param(CLASS, (Object)this, "visitEnter(LocationList)", "current", this.current);
        this.checkMatching("visitEnter(LocationList)");
    }

    public final void visitLeave(LocationList locationList) {
        this.leave();
    }

    public final void visitEnter(Location location) throws ModuleDataException {
        this.enter("LOCATION");
        String method = "visitEnter(Location)";
        Trace.param(CLASS, (Object)this, "visitEnter(Location)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Location)");
        this.traverser.setLocationWithinModule(context + ".getLocation()");
        this.current.setAttribute("value");
        this.checkIfFound();
    }

    public final void visitLeave(Location location) {
        this.leave();
    }

    public final void visitEnter(AuthorList authorList) throws ModuleDataException {
        this.enter("AUTHORS");
        String method = "visitEnter(AuthorList)";
        Trace.param(CLASS, (Object)this, "visitEnter(AuthorList)", "current", this.current);
        this.checkMatching("visitEnter(AuthorList)");
    }

    public final void visitLeave(AuthorList authorList) {
        this.leave();
    }

    public final void visitEnter(Author author) throws ModuleDataException {
        this.enter("AUTHOR");
        String method = "visitEnter(Author)";
        Trace.param(CLASS, (Object)this, "visitEnter(Author)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Author)");
        this.traverser.setLocationWithinModule(context + ".getEmail()");
        this.current.setAttribute("email");
        this.checkIfFound();
    }

    public final void visitLeave(Author author) {
        this.leave();
    }

    public final void visitEnter(ImportList importList) throws ModuleDataException {
        this.enter("IMPORTS");
        String method = "visitEnter(ImportList)";
        Trace.param(CLASS, (Object)this, "visitEnter(ImportList)", "current", this.current);
        this.checkMatching("visitEnter(ImportList)");
    }

    public final void visitLeave(ImportList importList) {
        this.leave();
    }

    public final void visitEnter(Import imp) throws ModuleDataException {
        this.enter("IMPORT");
        String method = "visitEnter(Import)";
        Trace.param(CLASS, (Object)this, "visitEnter(Import)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Import)");
        this.traverser.setLocationWithinModule(context + ".getLabel()");
        this.current.setAttribute("label");
        this.checkIfFound();
    }

    public final void visitLeave(Import imp) {
        this.leave();
    }

    public final void visitEnter(UsedByList usedByList) throws ModuleDataException {
        this.enter("USEDBY");
        String method = "visitEnter(UsedByList)";
        Trace.param(CLASS, (Object)this, "visitEnter(UsedByList)", "current", this.current);
        this.checkMatching("visitEnter(UsedByList)");
    }

    public final void visitLeave(UsedByList usedByList) {
        this.leave();
    }

    public final void visitEnter(ChapterList chapterList) throws ModuleDataException {
        String method = "visitEnter(ChapterList)";
        this.checkMatching("visitEnter(ChapterList)");
    }

    public final void visitLeave(ChapterList chapterList) {
        this.traverser.setBlocked(false);
    }

    public final void visitEnter(Chapter chapter) throws ModuleDataException {
        this.enter("CHAPTER");
        String method = "visitEnter(Chapter)";
        Trace.param(CLASS, (Object)this, "visitEnter(Chapter)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Chapter)");
        this.traverser.setLocationWithinModule(context + ".getNoNumber()");
        this.current.setAttribute("noNumber");
        this.checkIfFound();
    }

    public final void visitLeave(Chapter chapter) {
        this.leave();
    }

    public final void visitEnter(SectionList sectionList) throws ModuleDataException {
        String method = "visitEnter(SectionList)";
        this.checkMatching("visitEnter(SectionList)");
    }

    public final void visitLeave(SectionList sectionList) {
        this.traverser.setBlocked(false);
    }

    public final void visitEnter(Section section) throws ModuleDataException {
        this.enter("SECTION");
        String method = "visitEnter(Section)";
        Trace.param(CLASS, (Object)this, "visitEnter(Section)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Section)");
        this.traverser.setLocationWithinModule(context + ".getNoNumber()");
        this.current.setAttribute("noNumber");
        this.checkIfFound();
    }

    public final void visitLeave(Section section) {
        this.leave();
    }

    public final void visitEnter(SubsectionList subsectionList) throws ModuleDataException {
        this.enter("SUBSECTIONS");
        String method = "visitEnter(SubsectionList)";
        Trace.param(CLASS, (Object)this, "visitEnter(SubsectionList)", "current", this.current);
        this.checkMatching("visitEnter(SubsectionList)");
    }

    public final void visitLeave(SubsectionList subsectionList) {
        this.leave();
    }

    public final void visitEnter(Subsection subsection) throws ModuleDataException {
        this.enter("SUBSECTION");
        String method = "visitEnter(Subsection)";
        Trace.param(CLASS, (Object)this, "visitEnter(Subsection)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Subsection)");
        this.traverser.setLocationWithinModule(context + ".getId()");
        this.current.setAttribute("id");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLevel()");
        this.current.setAttribute("level");
        this.checkIfFound();
    }

    public final void visitLeave(Subsection subsection) {
        this.leave();
    }

    public final void visitEnter(Node node) throws ModuleDataException {
        this.enter("NODE");
        String method = "visitEnter(Node)";
        Trace.param(CLASS, (Object)this, "visitEnter(Node)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Node)");
        this.traverser.setLocationWithinModule(context + ".getId()");
        this.current.setAttribute("id");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLevel()");
        this.current.setAttribute("level");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getNodeType()");
        this.current.setAttribute(null);
        this.checkIfFound();
    }

    public final void visitLeave(Node node) {
        this.leave();
    }

    public final void visitEnter(Axiom axiom) throws ModuleDataException {
        this.enter("AXIOM");
        String method = "visitEnter(Axiom)";
        Trace.param(CLASS, (Object)this, "visitEnter(Axiom)", "current", this.current);
        this.checkMatching("visitEnter(Axiom)");
    }

    public final void visitLeave(Axiom axiom) {
        this.leave();
    }

    public final void visitEnter(Proposition proposition) throws ModuleDataException {
        this.enter("THEOREM");
        String method = "visitEnter(Proposition)";
        Trace.param(CLASS, (Object)this, "visitEnter(Proposition)", "current", this.current);
        this.checkMatching("visitEnter(Proposition)");
    }

    public final void visitLeave(Proposition proposition) {
        this.leave();
    }

    public final void visitEnter(ProofList proofList) throws ModuleDataException {
        String method = "visitEnter(ProofList)";
        this.checkMatching("visitEnter(ProofList)");
    }

    public final void visitEnter(Proof proof) throws ModuleDataException {
        this.enter("PROOF");
        String method = "visitEnter(Proof)";
        Trace.param(CLASS, (Object)this, "visitEnter(Proof)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Proof)");
        this.traverser.setLocationWithinModule(context + ".getKind()");
        this.current.setAttribute("kind");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLevel()");
        this.current.setAttribute("level");
        this.checkIfFound();
    }

    public final void visitLeave(Proof proof) {
        this.leave();
    }

    public final void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        this.enter("DEFINITION_PREDICATE");
        String method = "visitEnter(PredicateDefinition)";
        Trace.param(CLASS, (Object)this, "visitEnter(PredicateDefinition)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(PredicateDefinition)");
        this.traverser.setLocationWithinModule(context + ".getArgumentNumber()");
        this.current.setAttribute("arguments");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatexPattern()");
        this.enter("LATEXPATTERN");
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            if (definition.getLatexPattern() == null) {
                this.leave();
            }
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
        this.leave();
    }

    public final void visitLeave(PredicateDefinition definition) {
        this.leave();
    }

    public final void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        this.enter("DEFINITION_FUNCTION");
        String method = "visitEnter(FunctionDefinition)";
        Trace.param(CLASS, (Object)this, "visitEnter(FunctionDefinition)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(FunctionDefinition)");
        this.traverser.setLocationWithinModule(context + ".getArgumentNumber()");
        this.current.setAttribute("arguments");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context + ".getLatexPattern()");
        this.enter("LATEXPATTERN");
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            if (definition.getLatexPattern() == null) {
                this.leave();
            }
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
        this.leave();
    }

    public final void visitLeave(FunctionDefinition definition) {
        this.leave();
    }

    public final void visitEnter(Rule rule) throws ModuleDataException {
        this.enter("RULE");
        String method = "visitEnter(Rule)";
        Trace.param(CLASS, (Object)this, "visitEnter(Rule)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(Rule)");
        this.traverser.setLocationWithinModule(context + ".getName()");
        this.current.setAttribute("name");
        this.checkIfFound();
    }

    public final void visitLeave(Rule rule) {
        this.leave();
    }

    public final void visitEnter(LinkList linkList) throws ModuleDataException {
        String method = "visitEnter(LinkList)";
        Trace.param(CLASS, (Object)this, "visitEnter(LinkList)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(LinkList)");
        for (int i = 0; i < linkList.size(); ++i) {
            this.enter("LINK");
            if (linkList.get(i) != null) {
                this.traverser.setLocationWithinModule(context + ".get(" + i + ")");
                this.current.setAttribute("id");
                this.checkIfFound();
            }
            this.leave();
        }
    }

    public final void visitLeave(LinkList linkList) {
    }

    public final void visitEnter(Formula formula) throws ModuleDataException {
        this.enter("FORMULA");
        String method = "visitEnter(Formula)";
        Trace.param(CLASS, (Object)this, "visitEnter(Formula)", "current", this.current);
        this.checkMatching("visitEnter(Formula)");
    }

    public final void visitLeave(Formula formula) {
        this.leave();
    }

    public final void visitEnter(Term term) throws ModuleDataException {
        this.enter("TERM");
        String method = "visitEnter(Term)";
        Trace.param(CLASS, (Object)this, "visitEnter(Term)", "current", this.current);
        this.checkMatching("visitEnter(Term)");
    }

    public final void visitLeave(Term term) {
        this.leave();
    }

    public final void visitEnter(VariableList variableList) throws ModuleDataException {
        this.enter("VARLIST");
        String method = "visitEnter(VariableList)";
        Trace.param(CLASS, (Object)this, "visitEnter(VariableList)", "current", this.current);
        this.checkMatching("visitEnter(VariableList)");
    }

    public final void visitLeave(VariableList variableList) {
        this.leave();
    }

    public final void visitEnter(ElementList list) throws ModuleDataException {
        boolean firstIsAtom;
        String operator = list.getOperator();
        this.enter(operator);
        String method = "visitEnter(ElementList)";
        Trace.param(CLASS, (Object)this, "visitEnter(ElementList)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (context.startsWith(this.find.getLocationWithinModule())) {
            throw new LocationFoundException(this.find);
        }
        this.checkMatching("visitEnter(ElementList)");
        this.traverser.setLocationWithinModule(context + ".getOperator()");
        this.checkIfFound();
        this.traverser.setLocationWithinModule(context);
        boolean bl = firstIsAtom = list.size() > 0 && list.getElement(0).isAtom();
        if (firstIsAtom) {
            this.traverser.setLocationWithinModule(context + ".getElement(0).getAtom()");
            if ("VAR".equals(operator) || "PREDVAR".equals(operator) || "FUNVAR".equals(operator)) {
                this.current.setAttribute("id");
                this.checkIfFound();
            } else if ("PREDCON".equals(operator) || "FUNCON".equals(operator)) {
                this.current.setAttribute("ref");
                this.checkIfFound();
            } else {
                this.current.setAttribute(null);
                Trace.info(CLASS, this, "visitEnter(ElementList)", "unknown operator " + operator);
                throw new LocationFoundException(this.traverser.getCurrentContext());
            }
        }
    }

    public final void visitLeave(ElementList list) {
        this.leave();
    }

    public final void visitEnter(LiteratureItemList list) throws ModuleDataException {
        this.enter("BIBLIOGRAPHY");
        String method = "visitEnter(LiteratureItemList)";
        Trace.param(CLASS, (Object)this, "visitEnter(LiteratureItemList)", "current", this.current);
        this.checkMatching("visitEnter(LiteratureItemList)");
    }

    public final void visitLeave(LiteratureItemList list) {
        this.leave();
    }

    public final void visitEnter(LiteratureItem item) throws ModuleDataException {
        this.enter("ITEM");
        String method = "visitEnter(LiteratureItem)";
        Trace.param(CLASS, (Object)this, "visitEnter(LiteratureItem)", "current", this.current);
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        this.checkMatching("visitEnter(LiteratureItem)");
        this.traverser.setLocationWithinModule(context + ".getLabel()");
        this.current.setAttribute("label");
        this.checkIfFound();
    }

    public final void visitLeave(LiteratureItem item) {
        this.leave();
    }

    private final void checkIfFound() throws LocationFoundException {
        if (this.find.getLocationWithinModule().equals(this.traverser.getCurrentContext().getLocationWithinModule())) {
            throw new LocationFoundException(this.traverser.getCurrentContext());
        }
    }

    private final void checkMatching(String method) throws LocationNotFoundException, LocationFoundException {
        String context = this.traverser.getCurrentContext().getLocationWithinModule();
        if (this.find.getLocationWithinModule().startsWith(context)) {
            Trace.info(CLASS, this, method, "beginning matches");
            Trace.paramInfo(CLASS, (Object)this, method, "context", context);
            this.matching = true;
            this.matchingBegin = context;
            this.matchingPath = new SimpleXPath(this.current);
        } else {
            if (this.matching && !context.startsWith(this.matchingBegin)) {
                Trace.info(CLASS, this, method, "matching lost");
                Trace.paramInfo(CLASS, (Object)this, method, "last match     ", this.matchingBegin);
                Trace.paramInfo(CLASS, (Object)this, method, "current context", context);
                Trace.paramInfo(CLASS, (Object)this, method, "find context   ", this.find.getLocationWithinModule());
                Trace.traceStack(CLASS, this, method);
                Trace.info(CLASS, this, method, "changing XPath to last matching one");
                this.current = this.matchingPath;
                throw new LocationFoundException(new ModuleContext(this.find.getModuleLocation(), this.matchingBegin));
            }
            this.traverser.setBlocked(true);
        }
        this.checkIfFound();
    }

    private final void enter(String element) {
        ++this.level;
        this.current.addElement(element, this.addOccurence(element));
    }

    private final void enterFirst(String element) {
        ++this.level;
        this.current.addElement(element);
    }

    private final void leave() {
        --this.level;
        this.current.deleteLastElement();
        this.traverser.setBlocked(false);
    }

    private final int addOccurence(String name) {
        Enumerator counter;
        while (this.level < this.elements.size()) {
            this.elements.remove(this.elements.size() - 1);
        }
        while (this.level > this.elements.size()) {
            this.elements.add(new HashMap());
        }
        Map levelMap = (Map)this.elements.get(this.level - 1);
        if (levelMap.containsKey(name)) {
            counter = (Enumerator)levelMap.get(name);
            counter.increaseNumber();
        } else {
            counter = new Enumerator(1);
            levelMap.put(name, counter);
        }
        return counter.getNumber();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

