/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.utility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;

public final class ResourceLoaderUtility {
    private static final Class CLASS = class$org$qedeq$kernel$utility$ResourceLoaderUtility == null ? (class$org$qedeq$kernel$utility$ResourceLoaderUtility = ResourceLoaderUtility.class$("org.qedeq.kernel.utility.ResourceLoaderUtility")) : class$org$qedeq$kernel$utility$ResourceLoaderUtility;
    static /* synthetic */ Class class$org$qedeq$kernel$utility$ResourceLoaderUtility;
    static /* synthetic */ Class class$java$lang$Thread;

    private ResourceLoaderUtility() {
    }

    public static Class loadClass(String name) throws ClassNotFoundException {
        return ResourceLoaderUtility.loadClass(name, null);
    }

    public static URL getResourceUrl(String name) {
        return ResourceLoaderUtility.getResourceUrl(name, (class$org$qedeq$kernel$utility$ResourceLoaderUtility == null ? (class$org$qedeq$kernel$utility$ResourceLoaderUtility = ResourceLoaderUtility.class$("org.qedeq.kernel.utility.ResourceLoaderUtility")) : class$org$qedeq$kernel$utility$ResourceLoaderUtility).getClassLoader());
    }

    public static InputStream getResourceAsStream(String name) {
        return ResourceLoaderUtility.getResourceAsStream(name, null);
    }

    public static Class loadClass(String name, ClassLoader callerClassLoader) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader loader = ResourceLoaderUtility.getContextClassLoader();
            if (loader != null) {
                clazz = loader.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = callerClassLoader != null ? callerClassLoader.loadClass(name) : Class.forName(name);
        }
        return clazz;
    }

    public static URL getResourceUrl(String name, ClassLoader callerClassLoader) {
        ResourceLoaderUtility.checkResourceName(name);
        URL url = null;
        ClassLoader loader = ResourceLoaderUtility.getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(name);
        }
        if (url == null) {
            url = callerClassLoader != null ? callerClassLoader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String name, ClassLoader callerClassLoader) {
        ResourceLoaderUtility.checkResourceName(name);
        InputStream stream = null;
        ClassLoader loader = ResourceLoaderUtility.getContextClassLoader();
        if (loader != null) {
            stream = loader.getResourceAsStream(name);
        }
        if (stream == null) {
            stream = callerClassLoader != null ? callerClassLoader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        return stream;
    }

    public static ClassLoader getContextClassLoader() {
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = ResourceLoaderUtility.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void checkResourceName(String name) {
        if (name != null && name.startsWith("/")) {
            Trace.info(CLASS, "ClassLoaderUtility", "checkResourceName", "resource name not portable: " + name);
        }
    }

    public static URL getResourceUrl(File startDirectory, String resourceDirectoryName, String resourceName) {
        URL url;
        File resourceDir = new File(startDirectory, resourceDirectoryName);
        File resource = new File(resourceDir, resourceName);
        if (resource.exists()) {
            url = IoUtility.toUrl(resource);
        } else {
            url = ResourceLoaderUtility.getResourceUrl(resourceDirectoryName + "/" + resourceName);
            try {
                if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                    Trace.info(class$org$qedeq$kernel$utility$ResourceLoaderUtility == null ? (class$org$qedeq$kernel$utility$ResourceLoaderUtility = ResourceLoaderUtility.class$("org.qedeq.kernel.utility.ResourceLoaderUtility")) : class$org$qedeq$kernel$utility$ResourceLoaderUtility, "getResourceUrlAndMakeLocalCopy", "creation failed: " + resourceDir);
                }
                IoUtility.saveFile(url, resource);
            }
            catch (IOException e) {
                Trace.fatal(class$org$qedeq$kernel$utility$ResourceLoaderUtility == null ? (class$org$qedeq$kernel$utility$ResourceLoaderUtility = ResourceLoaderUtility.class$("org.qedeq.kernel.utility.ResourceLoaderUtility")) : class$org$qedeq$kernel$utility$ResourceLoaderUtility, "getResourceUrlAndMakeLocalCopy", "resource can not be saved", e);
            }
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

