/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.parser;

import java.util.Stack;
import org.qedeq.kernel.utility.TextInput;

public class MementoTextInput {
    private final Stack stack = new Stack();
    private final TextInput input;

    public MementoTextInput(TextInput input) {
        this.input = input;
    }

    public void markPosition() {
        this.stack.push(new Integer(this.input.getPosition()));
    }

    public long rewindPosition() {
        long oldPosition = this.getPosition();
        this.input.setPosition((Integer)this.stack.pop());
        return oldPosition;
    }

    public void clearMark() {
        this.stack.pop();
    }

    public long getPosition() {
        return this.input.getPosition();
    }

    public int getChar() {
        return this.input.getChar();
    }

    public int readChar() {
        return this.input.read();
    }

    public final boolean eof() {
        return this.input.isEmpty();
    }

    public int getRewindStackSize() {
        return this.stack.size();
    }

    public int getColumn() {
        return this.input.getColumn();
    }

    public int getRow() {
        return this.input.getRow();
    }

    public String getLine() {
        return this.input.getLine();
    }
}

