/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.latex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.qedeq.kernel.base.list.Element;
import org.qedeq.kernel.base.list.ElementList;
import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Chapter;
import org.qedeq.kernel.base.module.ChapterList;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.LiteratureItem;
import org.qedeq.kernel.base.module.LiteratureItemList;
import org.qedeq.kernel.base.module.Node;
import org.qedeq.kernel.base.module.NodeType;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Section;
import org.qedeq.kernel.base.module.SectionList;
import org.qedeq.kernel.base.module.Subsection;
import org.qedeq.kernel.base.module.SubsectionList;
import org.qedeq.kernel.base.module.SubsectionType;
import org.qedeq.kernel.base.module.VariableList;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.latex.Element2Latex;
import org.qedeq.kernel.latex.LatexTextParser;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.ReplaceUtility;

public final class Qedeq2Wiki {
    private static final Class CLASS = class$org$qedeq$kernel$latex$Qedeq2Wiki == null ? (class$org$qedeq$kernel$latex$Qedeq2Wiki = Qedeq2Wiki.class$("org.qedeq.kernel.latex.Qedeq2Wiki")) : class$org$qedeq$kernel$latex$Qedeq2Wiki;
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private final ModuleProperties prop;
    private PrintStream printer;
    private String language;
    private final Element2Latex elementConverter;
    private File outputDirectory;
    static /* synthetic */ Class class$org$qedeq$kernel$latex$Qedeq2Wiki;

    public Qedeq2Wiki(ModuleProperties prop) {
        this.prop = prop;
        this.elementConverter = new Element2Latex(prop.hasLoadedRequiredModules() ? prop.getRequiredModules() : null);
    }

    public final synchronized void printWiki(String language, String level, File outputDirectory) throws IOException {
        this.language = language == null ? "en" : language;
        this.outputDirectory = outputDirectory;
        this.printQedeqChapters();
        this.printQedeqBibliography();
        if (this.printer.checkError()) {
            throw new IOException("TODO mime: better use another OutputStream");
        }
    }

    private void printQedeqChapters() throws IOException {
        ChapterList chapters = this.prop.getModule().getQedeq().getChapterList();
        for (int i = 0; i < chapters.size(); ++i) {
            SectionList sections;
            String label = this.prop.getModule().getQedeq().getHeader().getSpecification().getName() + "_ch_" + i;
            FileOutputStream outputStream = new FileOutputStream(new File(this.outputDirectory, label + "_" + this.language + ".wiki"));
            this.printer = new PrintStream(outputStream);
            Chapter chapter = chapters.get(i);
            this.printer.print("\\chapter");
            if (chapter.getNoNumber() != null && chapter.getNoNumber().booleanValue()) {
                this.printer.print("*");
            }
            this.printer.println("== " + this.getLatexListEntry(chapter.getTitle()) + " ==");
            this.printer.println();
            this.printer.println("<div id=\"" + label + "\"></div>");
            this.printer.println();
            if (chapter.getIntroduction() != null) {
                this.printer.println(this.getLatexListEntry(chapter.getIntroduction()));
                this.printer.println();
            }
            if ((sections = chapter.getSectionList()) != null) {
                this.printSections(i, sections);
                this.printer.println();
            }
            this.printer.println("%% end of chapter " + this.getLatexListEntry(chapter.getTitle()));
            this.printer.println();
        }
    }

    private void printQedeqBibliography() {
        LiteratureItemList items = this.prop.getModule().getQedeq().getLiteratureItemList();
        if (items == null) {
            return;
        }
        this.printer.println("\\begin{thebibliography}{99}");
        for (int i = 0; i < items.size(); ++i) {
            LiteratureItem item = items.get(i);
            this.printer.print("\\bibitem{" + item.getLabel() + "} ");
            this.printer.println(this.getLatexListEntry(item.getItem()));
            this.printer.println();
        }
        this.printer.println("\\end{thebibliography}");
        this.printer.println("\\addcontentsline{toc}{chapter}{Literaturverzeichnis}");
    }

    private void printSections(int chapter, SectionList sections) {
        if (sections == null) {
            return;
        }
        for (int i = 0; i < sections.size(); ++i) {
            Section section = sections.get(i);
            this.printer.print("\\section{");
            this.printer.print(this.getLatexListEntry(section.getTitle()));
            String label = "chapter" + chapter + "_section" + i;
            this.printer.println("} \\label{" + label + "} \\hypertarget{" + label + "}{}");
            this.printer.println(this.getLatexListEntry(section.getIntroduction()));
            this.printer.println();
            this.printSubsections(section.getSubsectionList());
        }
    }

    private void printSubsections(SubsectionList nodes) {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            SubsectionType subsectionType = nodes.get(i);
            if (subsectionType instanceof Node) {
                Node node = (Node)subsectionType;
                this.printer.println(this.getLatexListEntry(node.getPrecedingText()));
                this.printer.println();
                this.printer.println("\\par");
                String id = node.getId();
                NodeType type = node.getNodeType();
                String title = null;
                if (node.getTitle() != null) {
                    title = this.getLatexListEntry(node.getTitle());
                }
                if (type instanceof Axiom) {
                    this.printAxiom((Axiom)type, title, id);
                } else if (type instanceof PredicateDefinition) {
                    this.printPredicateDefinition((PredicateDefinition)type, title, id);
                } else if (type instanceof FunctionDefinition) {
                    this.printFunctionDefinition((FunctionDefinition)type, title, id);
                } else if (type instanceof Proposition) {
                    this.printProposition((Proposition)type, title, id);
                } else if (type instanceof Rule) {
                    this.printRule((Rule)type, title, id);
                } else {
                    throw new RuntimeException(type != null ? "unknown type: " + type.getClass().getName() : "node type empty");
                }
                this.printer.println();
                this.printer.println(this.getLatexListEntry(node.getSucceedingText()));
            } else {
                Subsection subsection = (Subsection)subsectionType;
                if (subsection.getTitle() != null) {
                    this.printer.print("\\subsection{");
                    this.printer.println(this.getLatexListEntry(subsection.getTitle()));
                    this.printer.println("}");
                }
                this.printer.println(this.getLatexListEntry(subsection.getLatex()));
            }
            this.printer.println();
            this.printer.println();
        }
    }

    private void printAxiom(Axiom axiom, String title, String id) {
        this.printer.println("\\begin{ax}" + (title != null ? "[" + title + "]" : ""));
        this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
        this.printFormula(axiom.getFormula().getElement());
        this.printer.println(this.getLatexListEntry(axiom.getDescription()));
        this.printer.println("\\end{ax}");
    }

    private void printTopFormula(Element element, String mainLabel) {
        if (!element.isList() || !element.getList().getOperator().equals("AND")) {
            this.printFormula(element);
            return;
        }
        ElementList list = element.getList();
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{0.9\\linewidth}l}}");
        for (int i = 0; i < list.size(); ++i) {
            String label = i < ALPHABET.length() ? "" + ALPHABET.charAt(i) : "" + i;
            this.printer.println("\\centering $" + this.getLatex(list.getElement(i)) + "$" + " & \\label{" + mainLabel + ":" + label + "} \\hypertarget{" + mainLabel + ":" + label + "}{} \\mbox{\\emph{(" + label + ")}} " + (i + 1 < list.size() ? "\\\\" : ""));
        }
        this.printer.println("\\end{longtable}");
    }

    private void printFormula(Element element) {
        this.printer.println("\\mbox{}");
        this.printer.println("\\begin{longtable}{{@{\\extracolsep{\\fill}}p{\\linewidth}}}");
        this.printer.println("\\centering $" + this.getLatex(element) + "$");
        this.printer.println("\\end{longtable}");
    }

    private void printPredicateDefinition(PredicateDefinition definition, String title, String id) {
        StringBuffer define = new StringBuffer("$$" + definition.getLatexPattern());
        VariableList list = definition.getVariableList();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Trace.trace(CLASS, (Object)this, "printDefinition", "replacing!");
                ReplaceUtility.replace(define, "#" + (i + 1), this.getLatex(list.get(i)));
            }
        }
        if (definition.getFormula() != null) {
            this.printer.println("\\begin{defn}" + (title != null ? "[" + title + "]" : ""));
            this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
            define.append("\\ :\\leftrightarrow \\ ");
            define.append(this.getLatex(definition.getFormula().getElement()));
        } else {
            this.printer.println("\\begin{idefn}" + (title != null ? "[" + title + "]" : ""));
            this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
        }
        define.append("$$");
        this.elementConverter.addPredicate(definition);
        Trace.param(CLASS, (Object)this, "printDefinition", "define", define);
        this.printer.println(define);
        this.printer.println(this.getLatexListEntry(definition.getDescription()));
        if (definition.getFormula() != null) {
            this.printer.println("\\end{defn}");
        } else {
            this.printer.println("\\end{idefn}");
        }
    }

    private void printFunctionDefinition(FunctionDefinition definition, String title, String id) {
        StringBuffer define = new StringBuffer("$$" + definition.getLatexPattern());
        VariableList list = definition.getVariableList();
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Trace.trace(CLASS, (Object)this, "printDefinition", "replacing!");
                ReplaceUtility.replace(define, "#" + (i + 1), this.getLatex(list.get(i)));
            }
        }
        if (definition.getTerm() != null) {
            this.printer.println("\\begin{defn}" + (title != null ? "[" + title + "]" : ""));
            this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
            define.append("\\ := \\ ");
            define.append(this.getLatex(definition.getTerm().getElement()));
        } else {
            this.printer.println("\\begin{idefn}" + (title != null ? "[" + title + "]" : ""));
            this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
        }
        define.append("$$");
        this.elementConverter.addFunction(definition);
        Trace.param(CLASS, (Object)this, "printDefinition", "define", define);
        this.printer.println(define);
        this.printer.println(this.getLatexListEntry(definition.getDescription()));
        if (definition.getTerm() != null) {
            this.printer.println("\\end{defn}");
        } else {
            this.printer.println("\\end{idefn}");
        }
    }

    private void printProposition(Proposition proposition, String title, String id) {
        this.printer.println("\\begin{prop}" + (title != null ? "[" + title + "]" : ""));
        this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
        this.printTopFormula(proposition.getFormula().getElement(), id);
        this.printer.println(this.getLatexListEntry(proposition.getDescription()));
        this.printer.println("\\end{prop}");
        if (proposition.getProofList() != null) {
            for (int i = 0; i < proposition.getProofList().size(); ++i) {
                this.printer.println("\\begin{proof}");
                this.printer.println(this.getLatexListEntry(proposition.getProofList().get(i).getNonFormalProof()));
                this.printer.println("\\end{proof}");
            }
        }
    }

    private void printRule(Rule rule, String title, String id) {
        this.printer.println("\\begin{rul}" + (title != null ? "[" + title + "]" : ""));
        this.printer.println("\\label{" + id + "} \\hypertarget{" + id + "}{}");
        this.printer.println(this.getLatexListEntry(rule.getDescription()));
        this.printer.println("\\end{rul}");
        if (rule.getProofList() != null) {
            for (int i = 0; i < rule.getProofList().size(); ++i) {
                this.printer.println("\\begin{proof}");
                this.printer.println(this.getLatexListEntry(rule.getProofList().get(i).getNonFormalProof()));
                this.printer.println("\\end{proof}");
            }
        }
    }

    private String getLatex(Element element) {
        return this.elementConverter.getLatex(element);
    }

    private String getLatexListEntry(LatexList list) {
        int i;
        if (list == null) {
            return "";
        }
        for (i = 0; i < list.size(); ++i) {
            if (!this.language.equals(list.get(i).getLanguage())) continue;
            return this.getLatex(list.get(i));
        }
        for (i = 0; i < list.size(); ++i) {
            if (list.get(i).getLanguage() != null) continue;
            return this.getLatex(list.get(i));
        }
        i = 0;
        if (i < list.size()) {
            return "MISSING! OTHER: " + this.getLatex(list.get(i));
        }
        return "MISSING!";
    }

    private String getLatex(Latex latex) {
        if (latex == null || latex.getLatex() == null) {
            return "";
        }
        return LatexTextParser.transform(latex.getLatex());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

