/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.qedeq.kernel.bo.load.DefaultModuleProperties;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.trace.Trace;

class Modules {
    private static final Class CLASS = class$org$qedeq$kernel$bo$load$Modules == null ? (class$org$qedeq$kernel$bo$load$Modules = Modules.class$("org.qedeq.kernel.bo.load.Modules")) : class$org$qedeq$kernel$bo$load$Modules;
    private final Map moduleProperties = new HashMap();
    static /* synthetic */ Class class$org$qedeq$kernel$bo$load$Modules;

    Modules() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ModuleProperties getModuleProperties(ModuleAddress address) {
        Map map = this.moduleProperties;
        synchronized (map) {
            if (this.moduleProperties.containsKey(address)) {
                return (ModuleProperties)this.moduleProperties.get(address);
            }
            DefaultModuleProperties prop = new DefaultModuleProperties(address);
            this.moduleProperties.put(address, prop);
            return prop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeAllModules() {
        String method = "removeAllModules";
        Trace.begin(CLASS, this, "removeAllModules");
        try {
            Map map = this.moduleProperties;
            synchronized (map) {
                Iterator iterator = this.moduleProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ModuleProperties prop = (ModuleProperties)entry.getValue();
                    Trace.trace(CLASS, (Object)this, "removeAllModules", "remove " + prop);
                    ModuleEventLog.getInstance().removeModule(prop);
                }
                this.moduleProperties.clear();
            }
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "removeAllModules", (Throwable)e);
        }
        finally {
            Trace.end(CLASS, this, "removeAllModules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeModule(ModuleProperties prop) {
        String method = "removeModule";
        Trace.begin(CLASS, this, "removeModule");
        try {
            Map map = this.moduleProperties;
            synchronized (map) {
                Trace.trace(CLASS, (Object)this, "removeModule", "remove module " + prop.getUrl());
                if (!prop.isLoaded()) {
                    Trace.trace(CLASS, (Object)this, "removeModule", "removing " + prop.getUrl());
                    ModuleEventLog.getInstance().removeModule(prop);
                    this.moduleProperties.remove(prop.getModuleAddress());
                } else {
                    Trace.trace(CLASS, (Object)this, "removeModule", "module number=" + this.moduleProperties.size());
                    Trace.trace(CLASS, (Object)this, "removeModule", "removing module itself: " + prop.getUrl());
                    ModuleEventLog.getInstance().removeModule(prop);
                    this.moduleProperties.remove(prop.getModuleAddress());
                    Trace.trace(CLASS, (Object)this, "removeModule", "module number=" + this.moduleProperties.size());
                }
            }
        }
        catch (RuntimeException e) {
            Trace.trace(CLASS, (Object)this, "removeModule", (Throwable)e);
        }
        finally {
            Trace.end(CLASS, this, "removeModule");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ModuleAddress[] getAllLoadedModules() {
        String method = "getAllModules";
        Trace.begin(CLASS, this, "getAllModules");
        try {
            ArrayList<ModuleAddress> list = new ArrayList<ModuleAddress>();
            ModuleAddress[] moduleAddressArray = this.moduleProperties;
            synchronized (this.moduleProperties) {
                Iterator iterator = this.moduleProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ModuleProperties prop = (ModuleProperties)entry.getValue();
                    if (prop.getLoadingState().getCode() < LoadingState.STATE_LOADED.getCode()) continue;
                    list.add(prop.getModuleAddress());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                moduleAddressArray = list.toArray(new ModuleAddress[0]);
                return moduleAddressArray;
            }
        }
        finally {
            Trace.end(CLASS, this, "getAllModules");
        }
    }

    final int getNumberOfLoadedModules() {
        return this.getAllLoadedModules().length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

