/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.xml.parsers.ParserConfigurationException;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Specification;
import org.qedeq.kernel.bo.control.LoadRequiredModules;
import org.qedeq.kernel.bo.load.DefaultModuleAddress;
import org.qedeq.kernel.bo.load.DefaultQedeqBo;
import org.qedeq.kernel.bo.load.ModuleFileNotFoundException;
import org.qedeq.kernel.bo.load.Modules;
import org.qedeq.kernel.bo.load.QedeqBoFactory;
import org.qedeq.kernel.bo.module.Kernel;
import org.qedeq.kernel.bo.module.LoadingState;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.ModuleFactory;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.common.SourceFileException;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.log.QedeqLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.utility.IoUtility;
import org.qedeq.kernel.utility.ReplaceUtility;
import org.qedeq.kernel.xml.handler.module.QedeqHandler;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;
import org.qedeq.kernel.xml.parser.DefaultSourceFileExceptionList;
import org.qedeq.kernel.xml.parser.SaxDefaultHandler;
import org.qedeq.kernel.xml.parser.SaxParser;
import org.xml.sax.SAXException;

public class DefaultModuleFactory
implements ModuleFactory {
    private static final Class CLASS = class$org$qedeq$kernel$bo$load$DefaultModuleFactory == null ? (class$org$qedeq$kernel$bo$load$DefaultModuleFactory = DefaultModuleFactory.class$("org.qedeq.kernel.bo.load.DefaultModuleFactory")) : class$org$qedeq$kernel$bo$load$DefaultModuleFactory;
    private final String monitor = new String();
    private final String syncToken = new String();
    private int processCounter = 0;
    private final Modules modules = new Modules();
    private final Kernel kernel;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$load$DefaultModuleFactory;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$load$DefaultModuleAddress;

    public DefaultModuleFactory(Kernel kernel) {
        this.kernel = kernel;
    }

    public void startup() {
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            this.autoReloadLastSessionChecked();
        }
    }

    public void autoReloadLastSessionChecked() {
        if (this.kernel.getConfig().isAutoReloadLastSessionChecked()) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String method = "start()";
                    try {
                        Trace.begin(CLASS, this, "start()");
                        QedeqLog.getInstance().logMessage("Trying to load previously successfully loaded modules.");
                        int number = DefaultModuleFactory.this.kernel.getConfig().getPreviouslyCheckedModules().length;
                        if (DefaultModuleFactory.this.loadPreviouslySuccessfullyLoadedModules()) {
                            QedeqLog.getInstance().logMessage("Loading of " + number + " previously successfully loaded module" + (number != 1 ? "s" : "") + " successfully done.");
                        } else {
                            QedeqLog.getInstance().logMessage("Loading of all previously successfully checked modules failed. " + number + " module" + (number != 1 ? "s" : "") + " were tried.");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(CLASS, (Object)this, "start()", (Throwable)e);
                    }
                    finally {
                        Trace.begin(CLASS, this, "start()");
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllModules() {
        while (true) {
            String string = this.syncToken;
            synchronized (string) {
                if (this.processCounter == 0) {
                    this.getModules().removeAllModules();
                    return;
                }
            }
            string = this.monitor;
            synchronized (string) {
                try {
                    this.monitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void removeModule(ModuleAddress address) throws IOException {
        ModuleProperties prop = this.getModuleProperties(address);
        if (prop == null) {
            throw new IOException("Module not known: " + address);
        }
        this.removeModule(this.getModuleProperties(address));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModule(ModuleProperties prop) {
        while (true) {
            String string = this.syncToken;
            synchronized (string) {
                if (this.processCounter == 0) {
                    this.getModules().removeModule(prop);
                    return;
                }
            }
            string = this.monitor;
            synchronized (string) {
                try {
                    this.monitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void clearLocalBuffer() throws IOException {
        this.removeAllModules();
        File bufferDir = this.getBufferDirectory().getCanonicalFile();
        if (bufferDir.exists() && !IoUtility.deleteDir(bufferDir, false)) {
            throw new IOException("buffer could not be deleted: " + bufferDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleProperties loadModule(ModuleAddress address) throws SourceFileExceptionList {
        ModuleProperties moduleProperties;
        ModuleProperties prop;
        String method = "loadModule(URL)";
        this.processInc();
        try {
            ModuleProperties moduleProperties2 = prop = this.getModules().getModuleProperties(address);
            synchronized (moduleProperties2) {
                if (prop.isLoaded()) {
                    ModuleProperties moduleProperties3 = prop;
                    // MONITOREXIT @DISABLED, blocks:[0, 7, 14] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.processDec();
                    return moduleProperties3;
                }
            }
        }
        catch (Throwable throwable) {
            this.processDec();
            throw throwable;
        }
        {
            try {
                this.loadLocalModule(prop);
                ModuleProperties moduleProperties4 = prop;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
                this.processDec();
                return moduleProperties4;
            }
            catch (ModuleFileNotFoundException e) {
            }
            catch (SourceFileExceptionList e) {
                Trace.trace(CLASS, (Object)this, "loadModule(URL)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", address.getURL(), e.toString());
                throw e;
            }
            try {
                this.makeLocalCopy(prop);
            }
            catch (IOException e) {
                Trace.trace(CLASS, (Object)this, "loadModule(URL)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", address.getURL(), e.toString());
                throw this.createXmlFileExceptionList(e);
            }
            try {
                this.loadLocalModule(prop);
            }
            catch (ModuleFileNotFoundException e) {
                Trace.trace(CLASS, (Object)this, "loadModule(URL)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", address.getURL(), e.getMessage());
                SourceFileException sf = new SourceFileException(1021, "Loading of module \"" + address.getURL() + "\"failed", e, null, null);
                DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList(sf);
                throw sfl;
            }
            catch (SourceFileExceptionList e) {
                Trace.trace(CLASS, (Object)this, "loadModule(URL)", (Throwable)e);
                QedeqLog.getInstance().logFailureState("Loading of module failed!", address.getURL(), e.getMessage());
                throw e;
            }
            moduleProperties = prop;
        }
        this.processDec();
        return moduleProperties;
    }

    /*
     * Exception decompiling
     */
    public ModuleProperties loadModule(QedeqBo module, Specification spec) throws SourceFileExceptionList {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[MONITOR]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModuleAddress[] getAllLoadedModules() {
        return this.getModules().getAllLoadedModules();
    }

    public void loadRequiredModules(ModuleAddress address) throws SourceFileExceptionList {
        ModuleProperties prop = this.loadModule(address);
        LoadRequiredModules.loadRequired(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadPreviouslySuccessfullyLoadedModules() {
        this.processInc();
        try {
            String[] list = this.kernel.getConfig().getPreviouslyCheckedModules();
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    this.loadModule(address);
                    continue;
                }
                catch (SourceFileExceptionList e) {
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadAllModulesFromQedeq() {
        this.processInc();
        try {
            String prefix = "http://qedeq.org/" + this.kernel.getKernelVersionDirectory() + "/";
            String[] list = new String[]{prefix + "doc/math/qedeq_logic_v1.xml", prefix + "doc/math/qedeq_set_theory_v1.xml", prefix + "doc/project/qedeq_basic_concept.xml", prefix + "doc/project/qedeq_logic_language.xml", prefix + "sample/qedeq_sample1.xml", prefix + "sample/qedeq_error_sample_00.xml", prefix + "sample/qedeq_error_sample_01.xml", prefix + "sample/qedeq_error_sample_02.xml", prefix + "sample/qedeq_error_sample_03.xml", prefix + "sample/qedeq_error_sample_04.xml", prefix + "sample/qedeq_sample2_error.xml", prefix + "sample/qedeq_sample3_error.xml", prefix + "sample/qedeq_sample4_error.xml", prefix + "sample/qedeq_sample5_error.xml", prefix + "sample/qedeq_sample6_error.xml", prefix + "sample/qedeq_sample7_error.xml"};
            boolean errors = false;
            for (int i = 0; i < list.length; ++i) {
                try {
                    ModuleAddress address = this.getModuleAddress(list[i]);
                    this.loadModule(address);
                    continue;
                }
                catch (SourceFileExceptionList e) {
                    errors = true;
                    continue;
                }
                catch (IOException e) {
                    Trace.fatal(CLASS, this, "loadPreviouslySuccessfullyLoadedModules", "internal error: saved URLs are malformed", e);
                    errors = true;
                }
            }
            boolean bl = !errors;
            return bl;
        }
        finally {
            this.processDec();
        }
    }

    private final void loadLocalModule(ModuleProperties prop) throws ModuleFileNotFoundException, SourceFileExceptionList {
        DefaultQedeqBo qedeqBo;
        File file;
        String method = "loadLocalModule";
        File localFile = this.getLocalFilePath(prop.getModuleAddress());
        try {
            file = localFile.getCanonicalFile();
        }
        catch (IOException e) {
            Trace.trace(CLASS, (Object)this, "loadLocalModule", (Throwable)e);
            throw new ModuleFileNotFoundException("file path not correct: " + localFile);
        }
        if (!file.canRead()) {
            Trace.trace(CLASS, (Object)this, "loadLocalModule", "file not readable=" + file);
            throw new ModuleFileNotFoundException("file not found: " + file);
        }
        if (prop.getLoadingState() == LoadingState.STATE_UNDEFINED) {
            prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_BUFFER);
            ModuleEventLog.getInstance().addModule(prop);
        } else {
            prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_BUFFER);
            ModuleEventLog.getInstance().stateChanged(prop);
        }
        SaxDefaultHandler handler = new SaxDefaultHandler();
        QedeqHandler simple = new QedeqHandler(handler);
        handler.setBasisDocumentHandler(simple);
        Qedeq qedeq = null;
        SaxParser parser = null;
        try {
            parser = new SaxParser(handler);
        }
        catch (SAXException e) {
            Trace.trace(CLASS, (Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, new DefaultSourceFileExceptionList(e));
            ModuleEventLog.getInstance().stateChanged(prop);
            throw this.createXmlFileExceptionList(e);
        }
        catch (ParserConfigurationException e) {
            Trace.trace(CLASS, (Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, new DefaultSourceFileExceptionList(new RuntimeException("XML parser configuration error", e)));
            ModuleEventLog.getInstance().stateChanged(prop);
            throw this.createXmlFileExceptionList(e);
        }
        try {
            parser.parse(file, prop.getUrl());
        }
        catch (SourceFileExceptionList e) {
            Trace.trace(CLASS, (Object)this, "loadLocalModule", (Throwable)e);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_BUFFER_FAILED, e);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw e;
        }
        qedeq = simple.getQedeq();
        prop.setLoadingProgressState(LoadingState.STATE_LOADING_INTO_MEMORY);
        ModuleEventLog.getInstance().stateChanged(prop);
        try {
            qedeqBo = QedeqBoFactory.createQedeq(prop.getModuleAddress(), qedeq);
        }
        catch (ModuleDataException e) {
            Trace.trace(CLASS, (Object)this, "loadLocalModule", (Throwable)e);
            SourceFileExceptionList xl = ModuleDataException2XmlFileException.createXmlFileExceptionList(e, qedeq);
            prop.setLoadingFailureState(LoadingState.STATE_LOADING_INTO_MEMORY_FAILED, xl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw xl;
        }
        prop.setLoaded(qedeqBo);
        ModuleEventLog.getInstance().stateChanged(prop);
    }

    /*
     * Loose catch block
     */
    private final synchronized void makeLocalCopy(ModuleProperties prop) throws IOException {
        block22: {
            int bytesRead;
            String method = "makeLocalCopy";
            Trace.begin(CLASS, this, "makeLocalCopy");
            if (prop.getLoadingState() == LoadingState.STATE_UNDEFINED) {
                prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
                ModuleEventLog.getInstance().addModule(prop);
            } else {
                prop.setLoadingProgressState(LoadingState.STATE_LOADING_FROM_WEB);
                ModuleEventLog.getInstance().stateChanged(prop);
            }
            if (prop.getModuleAddress().isFileAddress()) {
                return;
            }
            FileOutputStream out = null;
            InputStream in = null;
            File f = this.getLocalFilePath(prop.getModuleAddress());
            URLConnection connection = prop.getUrl().openConnection();
            in = connection.getInputStream();
            int maximum = connection.getContentLength();
            if (!prop.getUrl().equals(connection.getURL())) {
                throw new FileNotFoundException("\"" + prop.getUrl() + "\" was substituted by " + "\"" + connection.getURL() + "\" from server");
            }
            IoUtility.createNecessaryDirectories(f);
            out = new FileOutputStream(f);
            byte[] buffer = new byte[4096];
            int position = 0;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                int completeness = (position += bytesRead) * 100 / maximum;
                if (completeness < 0) {
                    completeness = 0;
                }
                if (completeness > 100) {
                    completeness = 100;
                }
                prop.setLoadingCompleteness(completeness);
            }
            prop.setLoadingCompleteness(100);
            Object var13_15 = null;
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                in.close();
                break block22;
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                break block22;
                catch (IOException e) {
                    Trace.trace(CLASS, (Object)this, "makeLocalCopy", (Throwable)e);
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        f.delete();
                    }
                    catch (Exception ex) {
                        Trace.trace(CLASS, (Object)this, "makeLocalCopy", (Throwable)ex);
                    }
                    prop.setLoadingFailureState(LoadingState.STATE_LOADING_FROM_WEB_FAILED, new DefaultSourceFileExceptionList(e));
                    ModuleEventLog.getInstance().stateChanged(prop);
                    Trace.trace(CLASS, (Object)this, "makeLocalCopy", "Couldn't access " + prop.getUrl());
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Trace.end(CLASS, this, "makeLocalCopy");
                throw throwable;
            }
        }
        Trace.end(CLASS, this, "makeLocalCopy");
    }

    public final File getLocalFilePath(ModuleAddress address) {
        String method = "localizeInFileSystem(URL)";
        if (address.isFileAddress()) {
            return new File(address.getURL().getFile());
        }
        URL url = address.getURL();
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "protocol", url.getProtocol());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "host", url.getHost());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "port", url.getPort());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "path", url.getPath());
        Trace.param(CLASS, (Object)this, "localizeInFileSystem(URL)", "file", url.getFile());
        StringBuffer file = new StringBuffer(url.getFile());
        ReplaceUtility.replace(file, "_", "__");
        ReplaceUtility.replace(file, "/", "_1");
        String encoded = file.toString();
        try {
            encoded = URLEncoder.encode(file.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(class$org$qedeq$kernel$bo$load$DefaultModuleAddress == null ? (class$org$qedeq$kernel$bo$load$DefaultModuleAddress = DefaultModuleFactory.class$("org.qedeq.kernel.bo.load.DefaultModuleAddress")) : class$org$qedeq$kernel$bo$load$DefaultModuleAddress, "localizeInFileSystem(String)", e);
        }
        file.setLength(0);
        file.append(encoded);
        ReplaceUtility.replace(file, "#", "##");
        ReplaceUtility.replace(file, "_1", "#");
        ReplaceUtility.replace(file, "__", "_");
        StringBuffer adr = new StringBuffer(url.toExternalForm());
        try {
            adr = new StringBuffer(new URL(url.getProtocol(), url.getHost(), url.getPort(), file.toString()).toExternalForm());
        }
        catch (MalformedURLException e) {
            Trace.fatal(CLASS, this, "localizeInFileSystem(URL)", "unexpected", e);
            e.printStackTrace();
        }
        ReplaceUtility.replace(adr, "://", "_");
        ReplaceUtility.replace(adr, ":", "_");
        return new File(this.kernel.getBufferDirectory(), adr.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processInc() {
        String string = this.syncToken;
        synchronized (string) {
            ++this.processCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processDec() {
        String string = this.syncToken;
        synchronized (string) {
            --this.processCounter;
        }
    }

    public File getBufferDirectory() {
        return this.kernel.getConfig().getBufferDirectory();
    }

    public File getGenerationDirectory() {
        return this.kernel.getConfig().getGenerationDirectory();
    }

    public ModuleProperties getModuleProperties(ModuleAddress address) {
        return this.getModules().getModuleProperties(address);
    }

    public ModuleAddress getModuleAddress(URL url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(String url) throws IOException {
        return new DefaultModuleAddress(url);
    }

    public ModuleAddress getModuleAddress(File file) throws IOException {
        return new DefaultModuleAddress(file);
    }

    private final Modules getModules() {
        return this.modules;
    }

    private SourceFileExceptionList createXmlFileExceptionList(IOException e) {
        return new DefaultSourceFileExceptionList(e);
    }

    private SourceFileExceptionList createXmlFileExceptionList(ModuleFileNotFoundException e) {
        return new DefaultSourceFileExceptionList(e);
    }

    private SourceFileExceptionList createXmlFileExceptionList(ParserConfigurationException e) {
        return new DefaultSourceFileExceptionList(e);
    }

    private DefaultSourceFileExceptionList createXmlFileExceptionList(SAXException e) {
        return new DefaultSourceFileExceptionList(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

