/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import org.qedeq.kernel.base.module.Axiom;
import org.qedeq.kernel.base.module.Formula;
import org.qedeq.kernel.base.module.FunctionDefinition;
import org.qedeq.kernel.base.module.PredicateDefinition;
import org.qedeq.kernel.base.module.Proposition;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.base.module.Rule;
import org.qedeq.kernel.base.module.Term;
import org.qedeq.kernel.bo.control.CheckRequiredModuleException;
import org.qedeq.kernel.bo.control.ModuleConstantsExistenceChecker;
import org.qedeq.kernel.bo.logic.FormulaChecker;
import org.qedeq.kernel.bo.logic.Function;
import org.qedeq.kernel.bo.logic.Predicate;
import org.qedeq.kernel.bo.module.IllegalModuleDataException;
import org.qedeq.kernel.bo.module.LogicalState;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.ModuleReferenceList;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;

public final class QedeqBoFormalLogicChecker
extends AbstractModuleVisitor {
    private static final Class CLASS = class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker == null ? (class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker = QedeqBoFormalLogicChecker.class$("org.qedeq.kernel.bo.control.QedeqBoFormalLogicChecker")) : class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker;
    private final ModuleProperties prop;
    private final QedeqNotNullTraverser traverser;
    private ModuleConstantsExistenceChecker existence;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$QedeqBoFormalLogicChecker;

    private QedeqBoFormalLogicChecker(ModuleProperties prop) {
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
        this.prop = prop;
    }

    public static void check(ModuleProperties prop) throws SourceFileExceptionList {
        if (prop.isChecked()) {
            return;
        }
        if (!prop.hasLoadedRequiredModules()) {
            throw new IllegalStateException("QEDEQ module has not loaded with required files: " + prop);
        }
        prop.setLogicalProgressState(LogicalState.STATE_EXTERNAL_CHECKING);
        ModuleEventLog.getInstance().stateChanged(prop);
        ModuleReferenceList list = prop.getRequiredModules();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Trace.trace(CLASS, (Object)"check(ModuleProperties)", "checking label", list.getLabel(i));
                QedeqBoFormalLogicChecker.check(list.getModuleProperties(i));
                continue;
            }
            catch (SourceFileExceptionList e) {
                CheckRequiredModuleException md = new CheckRequiredModuleException(11231, "import check failed: " + list.getModuleProperties(i).getModuleAddress(), list.getModuleContext(i));
                SourceFileExceptionList sfl = ModuleDataException2XmlFileException.createXmlFileExceptionList(md, prop.getModule().getQedeq());
                prop.setLogicalFailureState(LogicalState.STATE_EXTERNAL_CHECKING_FAILED, sfl);
                ModuleEventLog.getInstance().stateChanged(prop);
                throw e;
            }
        }
        prop.setLogicalProgressState(LogicalState.STATE_INTERNAL_CHECKING);
        ModuleEventLog.getInstance().stateChanged(prop);
        QedeqBoFormalLogicChecker checker = new QedeqBoFormalLogicChecker(prop);
        try {
            checker.check();
        }
        catch (ModuleDataException e) {
            SourceFileExceptionList sfl = ModuleDataException2XmlFileException.createXmlFileExceptionList(e, prop.getModule().getQedeq());
            prop.setLogicalFailureState(LogicalState.STATE_INTERNAL_CHECKING_FAILED, sfl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw sfl;
        }
        prop.setChecked(checker.existence);
        ModuleEventLog.getInstance().stateChanged(prop);
    }

    private void check() throws ModuleDataException {
        this.existence = new ModuleConstantsExistenceChecker(this.prop);
        this.traverser.accept(this.prop.getModule().getQedeq());
    }

    public void visitEnter(Axiom axiom) throws ModuleDataException {
        if (axiom == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (axiom.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = axiom.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
        }
        this.setLocationWithinModule(context);
        this.traverser.setBlocked(true);
    }

    public void visitLeave(Axiom axiom) {
        this.traverser.setBlocked(false);
    }

    public void visitEnter(PredicateDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Predicate predicate = new Predicate(definition.getName(), definition.getArgumentNumber());
        if (this.existence.predicateExists(predicate)) {
            throw new IllegalModuleDataException(40400, "predicate was already defined for this argument number: " + predicate, this.getCurrentContext());
        }
        if ("2".equals(predicate.getArguments()) && "equal".equals(predicate.getName())) {
            this.existence.setIdentityOperatorDefined(true, predicate.getName());
        }
        if (definition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = definition.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        this.traverser.setBlocked(true);
    }

    public void visitLeave(PredicateDefinition definition) {
        this.traverser.setBlocked(false);
    }

    public void visitEnter(FunctionDefinition definition) throws ModuleDataException {
        if (definition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        Function function = new Function(definition.getName(), definition.getArgumentNumber());
        if (this.existence.functionExists(function)) {
            throw new IllegalModuleDataException(40400, "function was already defined for this argument number: " + function, this.getCurrentContext());
        }
        if (definition.getTerm() != null) {
            this.setLocationWithinModule(context + ".getTerm().getElement()");
            Term term = definition.getTerm();
            FormulaChecker.checkTerm(term.getElement(), this.getCurrentContext(), this.existence);
        }
        this.existence.add(definition);
        this.setLocationWithinModule(context);
        this.traverser.setBlocked(true);
    }

    public void visitLeave(FunctionDefinition definition) {
        this.traverser.setBlocked(false);
    }

    public void visitEnter(Proposition proposition) throws ModuleDataException {
        if (proposition == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        if (proposition.getFormula() != null) {
            this.setLocationWithinModule(context + ".getFormula().getElement()");
            Formula formula = proposition.getFormula();
            FormulaChecker.checkFormula(formula.getElement(), this.getCurrentContext(), this.existence);
        }
        this.setLocationWithinModule(context);
        this.traverser.setBlocked(true);
    }

    public void visitLeave(Proposition definition) {
        this.traverser.setBlocked(false);
    }

    public void visitEnter(Rule rule) throws ModuleDataException {
        if (rule == null) {
            return;
        }
        if (rule.getName() != null && "SET_DEFINION_BY_FORMULA".equals(rule.getName())) {
            this.existence.setClassOperatorExists(true);
        }
        this.traverser.setBlocked(true);
    }

    public void visitLeave(Rule rule) {
        this.traverser.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public final ModuleContext getCurrentContext() {
        return this.traverser.getCurrentContext();
    }

    protected final Qedeq getQedeqOriginal() {
        return this.prop.getModule().getQedeq();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

