/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import java.util.HashMap;
import org.qedeq.kernel.base.module.Latex;
import org.qedeq.kernel.base.module.LatexList;
import org.qedeq.kernel.base.module.Qedeq;
import org.qedeq.kernel.bo.control.LatexListDataException;
import org.qedeq.kernel.bo.module.ModuleAddress;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.QedeqBo;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTraverser;

public final class QedeqBoDuplicateLanguageChecker
extends AbstractModuleVisitor {
    private final QedeqBo original;
    private final QedeqNotNullTraverser traverser;

    private QedeqBoDuplicateLanguageChecker(ModuleAddress globalContext, QedeqBo qedeq) {
        this.traverser = new QedeqNotNullTraverser(globalContext, this);
        this.original = qedeq;
    }

    public static void check(ModuleAddress globalContext, QedeqBo qedeq) throws ModuleDataException {
        QedeqBoDuplicateLanguageChecker checker = new QedeqBoDuplicateLanguageChecker(globalContext, qedeq);
        checker.check();
    }

    private final void check() throws ModuleDataException {
        this.traverser.accept(this.original.getQedeq());
    }

    public final void visitEnter(LatexList list) throws ModuleDataException {
        if (list == null) {
            return;
        }
        String context = this.getCurrentContext().getLocationWithinModule();
        HashMap<String, ModuleContext> languages = new HashMap<String, ModuleContext>();
        for (int i = 0; i < list.size(); ++i) {
            Latex latex = list.get(i);
            this.setLocationWithinModule(context + ".get(" + i + ")");
            if (latex == null) {
                throw new LatexListDataException(1000, "Null pointer not permitted.", this.getCurrentContext());
            }
            if (languages.containsKey(latex.getLanguage())) {
                throw new LatexListDataException(1001, "Language entry exists already", this.getCurrentContext(), (ModuleContext)languages.get(latex.getLanguage()));
            }
            languages.put(list.get(i).getLanguage(), this.getCurrentContext());
        }
        this.setLocationWithinModule(context);
        this.traverser.setBlocked(true);
    }

    public final void visitLeave(LatexList list) {
        this.traverser.setBlocked(false);
    }

    public void setLocationWithinModule(String locationWithinModule) {
        this.getCurrentContext().setLocationWithinModule(locationWithinModule);
    }

    public final ModuleContext getCurrentContext() {
        return this.traverser.getCurrentContext();
    }

    protected final Qedeq getQedeqOriginal() {
        return this.original.getQedeq();
    }
}

