/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import org.qedeq.kernel.bo.control.ClassOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.control.IdentityOperatorAlreadyExistsException;
import org.qedeq.kernel.bo.logic.DefaultExistenceChecker;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.ModuleReferenceList;

public class ModuleConstantsExistenceChecker
extends DefaultExistenceChecker {
    private final ModuleProperties prop;

    public ModuleConstantsExistenceChecker(ModuleProperties prop) throws ModuleDataException {
        this.prop = prop;
        this.init();
    }

    public void init() throws ModuleDataException {
        this.clear();
        boolean identityOperatorExists = false;
        boolean classOperatorExists = false;
        ModuleReferenceList list = this.prop.getRequiredModules();
        String identityOperator = null;
        for (int i = 0; i < list.size(); ++i) {
            if (list.getModuleProperties(i).getExistenceChecker().equalityOperatorExists()) {
                if (identityOperatorExists) {
                    throw new IdentityOperatorAlreadyExistsException(123476, "identity operator already defined", list.getModuleContext(i));
                }
                identityOperatorExists = true;
                identityOperator = list.getLabel(i) + "." + list.getModuleProperties(i).getExistenceChecker().getIdentityOperator();
            }
            if (!list.getModuleProperties(i).getExistenceChecker().classOperatorExists()) continue;
            if (classOperatorExists) {
                throw new ClassOperatorAlreadyExistsException(123478, "class operator already defined", list.getModuleContext(i));
            }
            classOperatorExists = true;
        }
        this.setIdentityOperatorDefined(identityOperatorExists, identityOperator);
        this.setClassOperatorExists(classOperatorExists);
    }

    public boolean predicateExists(String name, int arguments) {
        int external = name.indexOf(".");
        if (external < 0) {
            return super.predicateExists(name, arguments);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        ModuleProperties newProp = ref.getModuleProperties(label);
        if (newProp == null) {
            return false;
        }
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().predicateExists(shortName, arguments);
    }

    public boolean functionExists(String name, int arguments) {
        int external = name.indexOf(".");
        if (external < 0) {
            return super.functionExists(name, arguments);
        }
        String label = name.substring(0, external);
        ModuleReferenceList ref = this.prop.getRequiredModules();
        ModuleProperties newProp = ref.getModuleProperties(label);
        String shortName = name.substring(external + 1);
        return newProp.getExistenceChecker().functionExists(shortName, arguments);
    }
}

