/*
 * Decompiled with CFR 0.152.
 */
package org.qedeq.kernel.bo.control;

import org.qedeq.kernel.base.module.Import;
import org.qedeq.kernel.base.module.ImportList;
import org.qedeq.kernel.bo.control.LoadRequiredModuleException;
import org.qedeq.kernel.bo.module.DependencyState;
import org.qedeq.kernel.bo.module.ModuleContext;
import org.qedeq.kernel.bo.module.ModuleDataException;
import org.qedeq.kernel.bo.module.ModuleProperties;
import org.qedeq.kernel.bo.module.ModuleReferenceList;
import org.qedeq.kernel.bo.visitor.AbstractModuleVisitor;
import org.qedeq.kernel.bo.visitor.QedeqNotNullTraverser;
import org.qedeq.kernel.common.SourceFileExceptionList;
import org.qedeq.kernel.context.KernelContext;
import org.qedeq.kernel.log.ModuleEventLog;
import org.qedeq.kernel.trace.Trace;
import org.qedeq.kernel.xml.mapper.ModuleDataException2XmlFileException;
import org.qedeq.kernel.xml.parser.DefaultSourceFileExceptionList;

public final class LoadRequiredModules
extends AbstractModuleVisitor {
    private static final Class CLASS = class$org$qedeq$kernel$bo$control$LoadRequiredModules == null ? (class$org$qedeq$kernel$bo$control$LoadRequiredModules = LoadRequiredModules.class$("org.qedeq.kernel.bo.control.LoadRequiredModules")) : class$org$qedeq$kernel$bo$control$LoadRequiredModules;
    private final QedeqNotNullTraverser traverser;
    private final ModuleProperties prop;
    private final ModuleReferenceList required;
    static /* synthetic */ Class class$org$qedeq$kernel$bo$control$LoadRequiredModules;

    private LoadRequiredModules(ModuleProperties prop) {
        this.prop = prop;
        this.traverser = new QedeqNotNullTraverser(prop.getModuleAddress(), this);
        this.required = new ModuleReferenceList();
    }

    public static void loadRequired(ModuleProperties prop) throws SourceFileExceptionList {
        String method = "loadRequired(ModuleProperties)";
        if (prop.getDependencyState().areAllRequiredLoaded()) {
            return;
        }
        KernelContext.getInstance().loadModule(prop.getModuleAddress());
        prop.setDependencyProgressState(DependencyState.STATE_LOADING_REQUIRED_MODULES);
        ModuleEventLog.getInstance().stateChanged(prop);
        LoadRequiredModules converter = new LoadRequiredModules(prop);
        try {
            converter.loadRequired();
            prop.setLoadedRequiredModules(converter.required);
            ModuleEventLog.getInstance().stateChanged(prop);
        }
        catch (ModuleDataException e) {
            SourceFileExceptionList sfl = ModuleDataException2XmlFileException.createXmlFileExceptionList(e, prop.getModule().getQedeq());
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, sfl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw sfl;
        }
        catch (RuntimeException e) {
            Trace.fatal(class$org$qedeq$kernel$bo$control$LoadRequiredModules == null ? (class$org$qedeq$kernel$bo$control$LoadRequiredModules = LoadRequiredModules.class$("org.qedeq.kernel.bo.control.LoadRequiredModules")) : class$org$qedeq$kernel$bo$control$LoadRequiredModules, "loadRequired(ModuleProperties)", "programming error", e);
            LoadRequiredModuleException me = new LoadRequiredModuleException(10, e.toString(), converter.traverser.getCurrentContext());
            DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList(me);
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, sfl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw sfl;
        }
        catch (Throwable e) {
            LoadRequiredModuleException me = new LoadRequiredModuleException(10, e.toString(), converter.traverser.getCurrentContext());
            DefaultSourceFileExceptionList sfl = new DefaultSourceFileExceptionList(me);
            prop.setDependencyFailureState(DependencyState.STATE_LOADING_REQUIRED_MODULES_FAILED, sfl);
            ModuleEventLog.getInstance().stateChanged(prop);
            throw sfl;
        }
    }

    private final void loadRequired() throws ModuleDataException {
        this.traverser.accept(this.prop.getModule().getQedeq());
    }

    public void visitEnter(Import imp) throws ModuleDataException {
        try {
            ModuleProperties propNew = KernelContext.getInstance().loadModule(this.prop.getModule(), imp.getSpecification());
            this.required.add(new ModuleContext(this.traverser.getCurrentContext()), imp.getLabel(), propNew);
            Trace.param(CLASS, "visitEnter(Import)", "adding context", this.traverser.getCurrentContext());
            LoadRequiredModules.loadRequired(propNew);
        }
        catch (SourceFileExceptionList e) {
            Trace.trace(CLASS, (Object)this, "visitEnter(Import)", (Throwable)e);
            throw new LoadRequiredModuleException(e.get(0).getErrorCode(), "import of module labeled \"" + imp.getLabel() + "\" failed: " + e.get(0).getMessage(), this.traverser.getCurrentContext());
        }
    }

    public void visitLeave(ImportList imports) {
        this.traverser.setBlocked(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

